/*
 * Decompiled with CFR 0.152.
 */
package com.kuma.library.twitterfavo;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.AnimationDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import com.kuma.library.twitterfavo.R;

public class TwitterFavoImageButton
extends ImageButton {
    private static final String TAG = TwitterFavoImageButton.class.getSimpleName();
    private static final int[] STATE_TOGGLED_ON = new int[]{R.attr.state_toggled_on};
    boolean isToggledOn;
    final boolean toggleOnClick;
    View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };

    public TwitterFavoImageButton(Context context) {
        this(context, null);
    }

    public TwitterFavoImageButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TwitterFavoImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TwitterFavoImageButton, defStyle, 0);
            this.toggleOnClick = a.getBoolean(R.styleable.TwitterFavoImageButton_toggleOnClick, true);
            this.setImageResource(R.drawable.tw__like_action);
            this.setToggledOn(this.toggleOnClick);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        this.setOnClickListener(this.clickListener);
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l == null ? this.clickListener : l);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 2);
        if (this.isToggledOn) {
            TwitterFavoImageButton.mergeDrawableStates((int[])drawableState, (int[])STATE_TOGGLED_ON);
        }
        return drawableState;
    }

    public boolean performClick() {
        if (this.toggleOnClick) {
            this.toggle();
        }
        return super.performClick();
    }

    public void setToggledOn(boolean isToggledOn) {
        this.isToggledOn = isToggledOn;
        if (Build.VERSION.SDK_INT >= 21) {
            this.refreshDrawableState();
        } else if (isToggledOn) {
            this.setImageResource(R.drawable.animation_list_favo);
            AnimationDrawable favoAnimation = (AnimationDrawable)this.getDrawable();
            favoAnimation.start();
        } else {
            this.setImageResource(R.drawable.tw__like_action);
        }
    }

    public void toggle() {
        this.setToggledOn(!this.isToggledOn);
    }

    public boolean isToggledOn() {
        return this.isToggledOn;
    }
}

