/*
 * Decompiled with CFR 0.152.
 */
package com.natasa.progressviews;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import com.natasa.progressviews.ArcProgressBar;
import com.natasa.progressviews.ColorsHelper;
import com.natasa.progressviews.R;
import com.natasa.progressviews.utils.OnProgressViewListener;
import com.natasa.progressviews.utils.ProgressShape;
import com.natasa.progressviews.utils.ProgressStartPoint;

abstract class ProgressView
extends View
implements ProgressShape {
    protected float progress = 0.0f;
    protected float strokeWidth = this.getResources().getDimension(R.dimen.default_stroke_width);
    protected float backgroundStrokeWidth = this.getResources().getDimension(R.dimen.default_background_stroke_width);
    protected int backgroundColor = this.getResources().getColor(R.color.background_color);
    protected int color = this.getResources().getColor(R.color.progress_color);
    protected int height;
    protected int width;
    protected int min;
    protected Paint backgroundPaint;
    protected Paint foregroundPaint;
    private String PROGRESS = this.getResources().getString(R.string.progress);
    protected int startPosInDegrees = ProgressStartPoint.DEFAULT.ordinal();
    private ObjectAnimator objAnimator;
    protected ProgressViewTextData text_data = new ProgressViewTextData(-3355444, 42);
    private OnProgressViewListener listenr;
    protected boolean isShadow_background;
    protected boolean isShadow_progress;
    protected float maximum_progress = 100.0f;
    private int shaderColor = this.getResources().getColor(R.color.shader_color);
    protected ColorsHelper colorHelper;
    protected int[] gradColors;
    protected boolean isRoundEdge;

    abstract void init();

    public void setOnProgressViewListener(OnProgressViewListener listener) {
        this.listenr = listener;
    }

    public ProgressView(Context context) {
        super(context);
        this.init();
        this.colorHelper = new ColorsHelper();
    }

    public ProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initTypedArray(context, attrs);
        this.init();
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTypedArray(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircleProgressBar, 0, 0);
        try {
            this.progress = typedArray.getFloat(R.styleable.CircleProgressBar_progress, this.progress);
            this.strokeWidth = typedArray.getDimension(R.styleable.CircleProgressBar_progress_width, this.strokeWidth);
            this.backgroundStrokeWidth = typedArray.getDimension(R.styleable.CircleProgressBar_bar_width, this.backgroundStrokeWidth);
            this.color = typedArray.getInt(R.styleable.CircleProgressBar_progress_color, this.color);
            this.backgroundColor = typedArray.getInt(R.styleable.CircleProgressBar_bar_color, this.backgroundColor);
            this.text_data.textColor = typedArray.getInt(R.styleable.CircleProgressBar_text_color, this.text_data.textColor);
            this.text_data.textSize = typedArray.getInt(R.styleable.CircleProgressBar_text_size, this.text_data.textSize);
        }
        finally {
            typedArray.recycle();
        }
        this.setShadowLayer();
        this.colorHelper = new ColorsHelper();
    }

    private void setShadowLayer() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.backgroundPaint);
            this.setLayerType(1, this.foregroundPaint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.min = this.setDimensions(widthMeasureSpec, heightMeasureSpec);
    }

    protected int setDimensions(int widthMeasureSpec, int heightMeasureSpec) {
        this.height = ProgressView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.width = ProgressView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int smallerDimens = Math.min(this.width, this.height);
        if (this instanceof ArcProgressBar) {
            this.setMeasuredDimension(smallerDimens, smallerDimens / 2);
        } else {
            this.setMeasuredDimension(smallerDimens, smallerDimens);
        }
        return smallerDimens;
    }

    protected float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.setProgressInView(progress);
    }

    private void setProgressInView(float progress) {
        this.progress = progress <= this.maximum_progress ? progress : this.maximum_progress;
        this.invalidate();
        this.trackProgressInView(progress);
    }

    public void resetProgressBar() {
        this.setProgress(0.0f);
    }

    public void setWidth(int circleWidth) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = circleWidth;
        this.requestLayout();
    }

    public float getWidthProgressBarLine() {
        return this.strokeWidth;
    }

    public void setWidthProgressBarLine(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.foregroundPaint.setStrokeWidth(strokeWidth);
        this.invalidate();
        this.requestLayout();
    }

    public float getWidthProgressBackground() {
        return this.backgroundStrokeWidth;
    }

    public void setWidthProgressBackground(float backgroundStrokeWidth) {
        this.backgroundStrokeWidth = backgroundStrokeWidth;
        this.backgroundPaint.setStrokeWidth(this.strokeWidth);
        this.invalidate();
        this.requestLayout();
    }

    protected void initForegroundColor() {
        this.foregroundPaint = new Paint(1);
        this.foregroundPaint.setColor(this.color);
        this.foregroundPaint.setStyle(Paint.Style.STROKE);
        this.foregroundPaint.setStrokeWidth(this.strokeWidth);
        if (this.isRoundEdge) {
            this.foregroundPaint.setStrokeCap(Paint.Cap.ROUND);
        }
    }

    protected void initBackgroundColor() {
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setColor(this.backgroundColor);
        this.backgroundPaint.setStyle(Paint.Style.STROKE);
        this.backgroundPaint.setStrokeWidth(this.backgroundStrokeWidth);
        if (this.isShadow_background) {
            this.backgroundPaint.setShadowLayer(2.0f, 2.0f, 4.0f, this.shaderColor);
        }
    }

    public void setRoundEdgeProgress(boolean isRoundEdge) {
        this.isRoundEdge = isRoundEdge;
        this.init();
    }

    public int getProgressColor() {
        return this.color;
    }

    public void setProgressColor(int color2) {
        this.color = color2;
        this.foregroundPaint.setColor(color2);
        this.invalidate();
        this.requestLayout();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.backgroundPaint.setColor(backgroundColor);
        this.invalidate();
        this.requestLayout();
    }

    private void initAnimator(float progres) {
        this.objAnimator = ObjectAnimator.ofFloat((Object)this, (String)this.PROGRESS, (float[])new float[]{progres});
        this.objAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.trackProgressInView(this.progress);
    }

    private void trackProgressInView(float progress) {
        if (this.listenr != null) {
            this.listenr.onProgressUpdate(progress);
            if (progress >= this.maximum_progress) {
                this.listenr.onFinish();
            }
        }
    }

    public void setProgressIndeterminateAnimation(int animSpeedMillisec) {
        this.initAnimator(this.maximum_progress);
        this.objAnimator.setDuration((long)animSpeedMillisec);
        this.objAnimator.setRepeatCount(-1);
        this.objAnimator.start();
    }

    public void cancelAnimation() {
        if (this.objAnimator != null) {
            this.objAnimator.cancel();
        }
    }

    public int getTextColor() {
        return this.text_data.textColor;
    }

    public void setTextColor(int textColor) {
        this.text_data.textColor = textColor;
        this.invalidate();
    }

    public int getTextSize() {
        return this.text_data.textSize;
    }

    public void setTextSize(int textSize) {
        this.text_data.textSize = textSize;
    }

    public void setText(String text) {
        this.text_data.isWithText = true;
        this.text_data.progressText = text;
        this.invalidate();
    }

    public void setText(String text, int color2) {
        this.text_data.isWithText = true;
        this.text_data.progressText = text;
        this.text_data.textColor = color2;
        this.invalidate();
    }

    public void setText(String text, int textSize, int color2) {
        this.text_data.isWithText = true;
        this.text_data.progressText = text;
        this.text_data.textColor = color2;
        this.text_data.textSize = textSize;
        this.invalidate();
    }

    protected void drawText(Canvas canvas) {
        if (this.text_data.isWithText) {
            this.colorHelper.drawTextCenter(canvas, this.text_data.progressText, this.text_data.textColor, this.text_data.textSize, this.min);
        }
    }

    protected void drawTextLine(Canvas canvas) {
        if (this.text_data.isWithText) {
            this.colorHelper.drawTextCenter(canvas, this.text_data.progressText, this.text_data.textColor, this.text_data.textSize, this.width);
        }
    }

    private void convertStringToIntColor(String hexColor) {
        if (hexColor != null) {
            try {
                this.shaderColor = Color.parseColor((String)hexColor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class ProgressViewTextData {
        public int textColor;
        public int textSize;
        public boolean isWithText;
        public String progressText;

        public ProgressViewTextData(int textColor, int textSize) {
            this.textColor = textColor;
            this.textSize = textSize;
        }
    }
}

