/*
 * Decompiled with CFR 0.152.
 */
package com.natasa.progressviews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.natasa.progressviews.ProgressView;
import com.natasa.progressviews.utils.ProgressStartPoint;
import com.natasa.progressviews.utils.ShapeType;

public class CircleProgressBar
extends ProgressView {
    private int PADDING = 3;
    private RectF rectF;
    private float bottom;
    private float right;
    private float top;
    private float left;
    private float angle;
    private int radius;
    private boolean isGradientColor;
    private boolean isSweepGradientColor;
    private int colorStart;
    private int colorEnd;

    public CircleProgressBar(Context context) {
        super(context);
    }

    public CircleProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public CircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init() {
        this.rectF = new RectF();
        this.initBackgroundColor();
        this.initForegroundColor();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawGradientColor();
        this.drawStrokeCircle(canvas);
    }

    private void drawStrokeCircle(Canvas canvas) {
        canvas.drawOval(this.rectF, this.backgroundPaint);
        this.angle = 360.0f * this.getProgress() / this.maximum_progress;
        canvas.drawArc(this.rectF, (float)this.startPosInDegrees, this.angle, false, this.foregroundPaint);
        this.drawText(canvas);
    }

    private void drawGradientColor() {
        if (this.isGradientColor) {
            this.setLinearGradientProgress(this.gradColors);
        }
        if (this.isSweepGradientColor) {
            this.setSweepGradPaint();
        }
    }

    public void setLinearGradientProgress(boolean isGradientColor) {
        this.isGradientColor = isGradientColor;
    }

    public void setLinearGradientProgress(boolean isGradientColor, int[] colors) {
        this.isGradientColor = isGradientColor;
        this.gradColors = colors;
    }

    public void setSweepGradientProgress(boolean isGradientColor, int colorStart, int colorEnd) {
        this.isSweepGradientColor = isGradientColor;
        this.colorStart = colorStart;
        this.colorEnd = colorEnd;
    }

    private void setSweepGradPaint() {
        if (this.colorStart != 0 && this.colorEnd != 0 && this.colorHelper != null) {
            this.colorHelper.setSweepGradientPaint(this.foregroundPaint, this.min / 2, this.min / 2, this.colorStart, this.colorEnd);
        }
    }

    private void setLinearGradientProgress(int[] gradColors) {
        if (gradColors != null) {
            this.colorHelper.setGradientPaint(this.foregroundPaint, this.left, this.top, this.right, this.bottom, gradColors);
        } else {
            this.colorHelper.setGradientPaint(this.foregroundPaint, this.left, this.top, this.right, this.bottom);
        }
    }

    public void setCircleViewPadding(int padding) {
        this.PADDING = padding;
        this.invalidate();
    }

    public int getPadding() {
        return this.PADDING;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.left = 0.0f + this.strokeWidth / 2.0f;
        this.top = 0.0f + this.strokeWidth / 2.0f;
        this.right = (float)this.min - this.strokeWidth / 2.0f;
        this.bottom = (float)this.min - this.strokeWidth / 2.0f;
        this.rectF.set(this.left + (float)this.PADDING, this.top + (float)this.PADDING, this.right - (float)this.PADDING, this.bottom - (float)this.PADDING);
    }

    public int getProgressStartPosition() {
        return this.startPosInDegrees;
    }

    public void setStartPositionInDegrees(int degrees) {
        this.startPosInDegrees = degrees;
    }

    public void setStartPositionInDegrees(ProgressStartPoint position) {
        this.startPosInDegrees = position.getValue();
    }

    @Override
    public ShapeType setType(ShapeType type) {
        return ShapeType.CIRCLE;
    }
}

