/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.style;

import android.content.Context;
import android.content.res.Resources;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.ProgressViewInterface;
import com.kongzue.dialogx.iostheme.R;
import com.kongzue.dialogx.style.views.ProgressView;

public class IOSStyle
extends DialogXStyle {
    public static IOSStyle style() {
        return new IOSStyle();
    }

    public int layout(boolean light) {
        return light ? R.layout.layout_dialogx_ios : R.layout.layout_dialogx_ios_dark;
    }

    public int enterAnimResId() {
        return R.anim.anim_dialogx_ios_enter;
    }

    public int exitAnimResId() {
        return 0;
    }

    public int[] verticalButtonOrder() {
        return new int[]{1, 5, 3, 5, 2};
    }

    public int[] horizontalButtonOrder() {
        return new int[]{2, 5, 3, 5, 1};
    }

    public int splitWidthPx() {
        return 1;
    }

    public int splitColorRes(boolean light) {
        return light ? R.color.dialogxIOSSplitLight : R.color.dialogxIOSSplitDark;
    }

    public DialogXStyle.BlurBackgroundSetting messageDialogBlurSettings() {
        return new DefaultBlurBackgroundSetting();
    }

    private int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public DialogXStyle.HorizontalButtonRes overrideHorizontalButtonRes() {
        return new DefaultHorizontalButtonRes();
    }

    public DialogXStyle.VerticalButtonRes overrideVerticalButtonRes() {
        return new DefaultVerticalButtonRes();
    }

    public DialogXStyle.WaitTipRes overrideWaitTipRes() {
        return new DefaultWaitTipRes();
    }

    public DialogXStyle.BottomDialogRes overrideBottomDialogRes() {
        return new DefaultBottomDialogRes();
    }

    public DialogXStyle.PopTipSettings popTipSettings() {
        return new DefaultPopTipSettings();
    }

    public DialogXStyle.PopNotificationSettings popNotificationSettings() {
        return new DefaultPopNotificationSettings();
    }

    public DialogXStyle.PopMenuSettings popMenuSettings() {
        return new DefaultPopMenuSettings();
    }

    public class DefaultPopMenuSettings
    extends DialogXStyle.PopMenuSettings {
        public DefaultPopMenuSettings() {
            super((DialogXStyle)IOSStyle.this);
        }

        public int layout(boolean light) {
            return light ? R.layout.layout_dialogx_popmenu_ios : R.layout.layout_dialogx_popmenu_ios_dark;
        }

        public DialogXStyle.BlurBackgroundSetting blurBackgroundSettings() {
            return new DialogXStyle.BlurBackgroundSetting(){

                public boolean blurBackground() {
                    return true;
                }

                public int blurForwardColorRes(boolean light) {
                    return light ? R.color.dialogxIOSBkgLight : R.color.dialogxIOSBkgDark;
                }

                public int blurBackgroundRoundRadiusPx() {
                    return IOSStyle.this.dip2px(15.0f);
                }
            };
        }

        public int backgroundMaskColorRes() {
            return R.color.black20;
        }

        public int overrideMenuDividerDrawableRes(boolean light) {
            return light ? R.drawable.rect_dialogx_ios_menu_split_divider : R.drawable.rect_dialogx_ios_menu_split_divider_night;
        }

        public int overrideMenuDividerHeight(boolean light) {
            return 1;
        }

        public int overrideMenuTextColor(boolean light) {
            return 0;
        }

        public int overrideMenuItemLayoutRes(boolean light) {
            return light ? R.layout.item_dialogx_ios_popmenu_light : R.layout.item_dialogx_ios_popmenu_dark;
        }

        public int overrideMenuItemBackgroundRes(boolean light, int index, int count, boolean isContentVisibility) {
            if (light) {
                if (index == 0) {
                    return R.drawable.button_dialogx_ios_top_light;
                }
                if (index == count - 1) {
                    return R.drawable.button_dialogx_ios_bottom_light;
                }
                return R.drawable.button_dialogx_ios_center_light;
            }
            if (index == 0) {
                return R.drawable.button_dialogx_ios_top_night;
            }
            if (index == count - 1) {
                return R.drawable.button_dialogx_ios_bottom_night;
            }
            return R.drawable.button_dialogx_ios_center_night;
        }

        public int overrideSelectionMenuBackgroundColor(boolean light) {
            return 0;
        }

        public boolean selectionImageTint(boolean light) {
            return false;
        }

        public int paddingVertical() {
            return 0;
        }
    }

    public class DefaultPopNotificationSettings
    extends DialogXStyle.PopNotificationSettings {
        public int layout(boolean light) {
            return light ? R.layout.layout_dialogx_popnotification_ios : R.layout.layout_dialogx_popnotification_ios_dark;
        }

        public DialogXStyle.PopNotificationSettings.ALIGN align() {
            return DialogXStyle.PopNotificationSettings.ALIGN.TOP;
        }

        public int enterAnimResId(boolean light) {
            return R.anim.anim_dialogx_notification_enter;
        }

        public int exitAnimResId(boolean light) {
            return R.anim.anim_dialogx_notification_exit;
        }

        public boolean tintIcon() {
            return false;
        }

        public DialogXStyle.BlurBackgroundSetting blurBackgroundSettings() {
            return new DialogXStyle.BlurBackgroundSetting(){

                public boolean blurBackground() {
                    return true;
                }

                public int blurForwardColorRes(boolean light) {
                    return light ? R.color.dialogxIOSNotificationBkgLight : R.color.dialogxIOSNotificationBkgDark;
                }

                public int blurBackgroundRoundRadiusPx() {
                    return IOSStyle.this.dip2px(18.0f);
                }
            };
        }
    }

    public class DefaultPopTipSettings
    extends DialogXStyle.PopTipSettings {
        public int layout(boolean light) {
            return light ? R.layout.layout_dialogx_poptip_ios : R.layout.layout_dialogx_poptip_ios_dark;
        }

        public DialogXStyle.PopTipSettings.ALIGN align() {
            return DialogXStyle.PopTipSettings.ALIGN.TOP;
        }

        public int enterAnimResId(boolean light) {
            return R.anim.anim_dialogx_ios_top_enter;
        }

        public int exitAnimResId(boolean light) {
            return R.anim.anim_dialogx_ios_top_exit;
        }

        public boolean tintIcon() {
            return false;
        }
    }

    public class DefaultBottomDialogRes
    extends DialogXStyle.BottomDialogRes {
        public DefaultBottomDialogRes() {
            super((DialogXStyle)IOSStyle.this);
        }

        public boolean touchSlide() {
            return false;
        }

        public int overrideDialogLayout(boolean light) {
            return light ? R.layout.layout_dialogx_bottom_ios : R.layout.layout_dialogx_bottom_ios_dark;
        }

        public int overrideMenuDividerDrawableRes(boolean light) {
            return light ? R.drawable.rect_dialogx_ios_menu_split_divider : R.drawable.rect_dialogx_ios_menu_split_divider_night;
        }

        public int overrideMenuDividerHeight(boolean light) {
            return 1;
        }

        public int overrideMenuTextColor(boolean light) {
            return light ? R.color.dialogxIOSBlue : R.color.dialogxIOSBlueDark;
        }

        public float overrideBottomDialogMaxHeight() {
            return 0.0f;
        }

        public int overrideMenuItemLayout(boolean light, int index, int count, boolean isContentVisibility) {
            if (light) {
                if (index == 0) {
                    return isContentVisibility ? R.layout.item_dialogx_ios_bottom_menu_center_light : R.layout.item_dialogx_ios_bottom_menu_top_light;
                }
                if (index == count - 1) {
                    return R.layout.item_dialogx_ios_bottom_menu_bottom_light;
                }
                return R.layout.item_dialogx_ios_bottom_menu_center_light;
            }
            if (index == 0) {
                return isContentVisibility ? R.layout.item_dialogx_ios_bottom_menu_center_dark : R.layout.item_dialogx_ios_bottom_menu_top_dark;
            }
            if (index == count - 1) {
                return R.layout.item_dialogx_ios_bottom_menu_bottom_dark;
            }
            return R.layout.item_dialogx_ios_bottom_menu_center_dark;
        }

        public int overrideSelectionMenuBackgroundColor(boolean light) {
            return 0;
        }

        public boolean selectionImageTint(boolean light) {
            return true;
        }

        public int overrideSelectionImage(boolean light, boolean isSelected) {
            return 0;
        }

        public int overrideMultiSelectionImage(boolean light, boolean isSelected) {
            return 0;
        }
    }

    public class DefaultWaitTipRes
    extends DialogXStyle.WaitTipRes {
        public DefaultWaitTipRes() {
            super((DialogXStyle)IOSStyle.this);
        }

        public int overrideWaitLayout(boolean light) {
            return R.layout.layout_dialogx_wait_ios;
        }

        public int overrideRadiusPx() {
            return -1;
        }

        public boolean blurBackground() {
            return true;
        }

        public int overrideBackgroundColorRes(boolean light) {
            return light ? R.color.dialogxIOSWaitBkgDark : R.color.dialogxIOSWaitBkgLight;
        }

        public int overrideTextColorRes(boolean light) {
            return 0;
        }

        public ProgressViewInterface overrideWaitView(Context context, boolean light) {
            return new ProgressView(context).setLightMode(light);
        }
    }

    public class DefaultVerticalButtonRes
    extends DialogXStyle.VerticalButtonRes {
        public DefaultVerticalButtonRes() {
            super((DialogXStyle)IOSStyle.this);
        }

        public int overrideVerticalOkButtonBackgroundRes(int visibleButtonCount, boolean light) {
            return light ? R.drawable.button_dialogx_ios_center_light : R.drawable.button_dialogx_ios_center_night;
        }

        public int overrideVerticalCancelButtonBackgroundRes(int visibleButtonCount, boolean light) {
            return light ? R.drawable.button_dialogx_ios_bottom_light : R.drawable.button_dialogx_ios_bottom_night;
        }

        public int overrideVerticalOtherButtonBackgroundRes(int visibleButtonCount, boolean light) {
            return light ? R.drawable.button_dialogx_ios_center_light : R.drawable.button_dialogx_ios_center_night;
        }
    }

    public class DefaultHorizontalButtonRes
    extends DialogXStyle.HorizontalButtonRes {
        public DefaultHorizontalButtonRes() {
            super((DialogXStyle)IOSStyle.this);
        }

        public int overrideHorizontalOkButtonBackgroundRes(int visibleButtonCount, boolean light) {
            if (visibleButtonCount == 1) {
                return light ? R.drawable.button_dialogx_ios_bottom_light : R.drawable.button_dialogx_ios_bottom_night;
            }
            return light ? R.drawable.button_dialogx_ios_right_light : R.drawable.button_dialogx_ios_right_night;
        }

        public int overrideHorizontalCancelButtonBackgroundRes(int visibleButtonCount, boolean light) {
            return light ? R.drawable.button_dialogx_ios_left_light : R.drawable.button_dialogx_ios_left_night;
        }

        public int overrideHorizontalOtherButtonBackgroundRes(int visibleButtonCount, boolean light) {
            return light ? R.drawable.button_dialogx_ios_center_light : R.drawable.button_dialogx_ios_center_night;
        }
    }

    public class DefaultBlurBackgroundSetting
    extends DialogXStyle.BlurBackgroundSetting {
        public DefaultBlurBackgroundSetting() {
            super((DialogXStyle)IOSStyle.this);
        }

        public boolean blurBackground() {
            return true;
        }

        public int blurForwardColorRes(boolean light) {
            return light ? R.color.dialogxIOSBkgLight : R.color.dialogxIOSBkgDark;
        }

        public int blurBackgroundRoundRadiusPx() {
            return IOSStyle.this.dip2px(15.0f);
        }
    }
}

