/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.style.views;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewTreeObserver;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.BlurViewType;
import com.kongzue.dialogx.iostheme.R;
import com.kongzue.dialogx.util.views.MaxLinearLayout;

public class BlurLinearLayout
extends MaxLinearLayout
implements BlurViewType {
    private float mDownSampleFactor = 4.0f;
    private int mOverlayColor = -1;
    private float mBlurRadius = 35.0f;
    private boolean noAlpha = false;
    private boolean overrideOverlayColor = false;
    private float mRadius = 0.0f;
    private boolean mDirty;
    private Bitmap mBitmapToBlur;
    private Bitmap mBlurredBitmap;
    private Canvas mBlurringCanvas;
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mBlurScript;
    private Allocation mBlurInput;
    private Allocation mBlurOutput;
    private boolean mIsRendering;
    private final Rect mRectSrc = new Rect();
    private final Rect mRectDst = new Rect();
    private View mDecorView;
    private boolean mDifferentRoot;
    private static int RENDERING_COUNT;
    private Paint mPaint;
    private RectF mRectF;
    private boolean isInit = false;
    private boolean darkMode = false;
    Paint cutPaint;
    Paint overlayPaint;
    private final ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onPreDraw() {
            if (!BlurLinearLayout.this.isAlive()) {
                BlurLinearLayout.this.destroy();
                return false;
            }
            int[] locations = new int[2];
            Bitmap oldBmp = BlurLinearLayout.this.mBlurredBitmap;
            View decor = BlurLinearLayout.this.mDecorView;
            if (decor != null && BlurLinearLayout.this.isShown() && BlurLinearLayout.this.prepare()) {
                boolean redrawBitmap;
                block13: {
                    redrawBitmap = BlurLinearLayout.this.mBlurredBitmap != oldBmp;
                    decor.getLocationOnScreen(locations);
                    int x = -locations[0];
                    int y = -locations[1];
                    BlurLinearLayout.this.getLocationOnScreen(locations);
                    x += locations[0];
                    y += locations[1];
                    BlurLinearLayout.this.mBitmapToBlur.eraseColor(BlurLinearLayout.this.getOverlayColor() & 0xFFFFFF);
                    int rc = BlurLinearLayout.this.mBlurringCanvas.save();
                    BlurLinearLayout.this.mIsRendering = true;
                    RENDERING_COUNT++;
                    try {
                        BlurLinearLayout.this.mBlurringCanvas.scale(1.0f * (float)BlurLinearLayout.this.mBitmapToBlur.getWidth() / (float)BlurLinearLayout.this.getWidth(), 1.0f * (float)BlurLinearLayout.this.mBitmapToBlur.getHeight() / (float)BlurLinearLayout.this.getHeight());
                        BlurLinearLayout.this.mBlurringCanvas.translate((float)(-x), (float)(-y));
                        if (decor.getBackground() != null) {
                            decor.getBackground().draw(BlurLinearLayout.this.mBlurringCanvas);
                        }
                        decor.draw(BlurLinearLayout.this.mBlurringCanvas);
                    }
                    catch (Exception e) {
                        if (BlurLinearLayout.isDebug()) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        BlurLinearLayout.this.mIsRendering = false;
                        RENDERING_COUNT--;
                        BlurLinearLayout.this.mBlurringCanvas.restoreToCount(rc);
                    }
                    try {
                        BlurLinearLayout.this.blur(BlurLinearLayout.this.mBitmapToBlur, BlurLinearLayout.this.mBlurredBitmap);
                    }
                    catch (Exception e) {
                        if (!BlurLinearLayout.isDebug()) break block13;
                        e.printStackTrace();
                    }
                }
                if (redrawBitmap || BlurLinearLayout.this.mDifferentRoot) {
                    BlurLinearLayout.this.invalidate();
                }
            }
            return true;
        }
    };
    private static boolean supportRenderScript;
    private boolean useBlur = true;
    public static boolean DEBUGMODE;

    public BlurLinearLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public BlurLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BlurLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (!this.isInit && context != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RealtimeBlurView);
            this.darkMode = a.getBoolean(R.styleable.RealtimeBlurView_dialogxDarkMode, false);
            this.mBlurRadius = a.getDimension(R.styleable.RealtimeBlurView_realtimeBlurRadius, (float)this.dip2px(context, 35.0f));
            this.mDownSampleFactor = a.getFloat(R.styleable.RealtimeBlurView_realtimeDownsampleFactor, 4.0f);
            this.mOverlayColor = a.getColor(R.styleable.RealtimeBlurView_realtimeOverlayColor, this.getResources().getColor(this.darkMode ? R.color.dialogxIOSBkgDark : R.color.dialogxIOSBkgLight));
            this.mRadius = a.getDimension(R.styleable.RealtimeBlurView_realtimeRadius, (float)this.dip2px(context, 15.0f));
            this.noAlpha = a.getBoolean(R.styleable.RealtimeBlurView_dialogxOverlayColorNoAlpha, false);
            a.recycle();
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mRectF = new RectF();
            this.cutPaint = new Paint();
            this.cutPaint.setAntiAlias(true);
            this.cutPaint.setColor(this.getOverlayColor());
            this.overlayPaint = new Paint();
            this.overlayPaint.setAntiAlias(true);
            this.isInit = true;
            if (!this.isCompatMode()) {
                this.setOutlineProvider(new ViewOutlineProvider(){

                    public void getOutline(View view, Outline outline) {
                        outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), BlurLinearLayout.this.mRadius);
                    }
                });
                this.setClipToOutline(true);
            }
        }
    }

    private boolean isCompatMode() {
        return Build.VERSION.SDK_INT < 21;
    }

    public void setBlurRadius(float radius) {
        if (this.mBlurRadius != radius) {
            this.mBlurRadius = radius;
            this.mDirty = true;
            this.invalidate();
        }
    }

    public void setRadiusPx(float r) {
        if (this.mRadius != r) {
            this.mRadius = r;
            this.mDirty = true;
            this.invalidate();
            if (!this.isCompatMode()) {
                this.setOutlineProvider(new ViewOutlineProvider(){

                    public void getOutline(View view, Outline outline) {
                        outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), BlurLinearLayout.this.mRadius);
                    }
                });
                this.setClipToOutline(true);
            }
        }
    }

    public void setRadiusPx(Float r) {
        if (r != null) {
            this.setRadiusPx(r.floatValue());
        }
    }

    public void setDownsampleFactor(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Downsample factor must be greater than 0.");
        }
        if (this.mDownSampleFactor != factor) {
            this.mDownSampleFactor = factor;
            this.mDirty = true;
            this.releaseBitmap();
            this.invalidate();
        }
    }

    public void setOverlayColor(int color2) {
        if (this.mOverlayColor != color2) {
            this.mOverlayColor = color2;
            this.invalidate();
        }
    }

    public void setOverlayColor(Integer color2) {
        if (color2 != null) {
            this.setOverlayColor((int)color2);
        }
    }

    private void releaseBitmap() {
        if (this.mBlurInput != null) {
            this.mBlurInput.destroy();
            this.mBlurInput = null;
        }
        if (this.mBlurOutput != null) {
            this.mBlurOutput.destroy();
            this.mBlurOutput = null;
        }
        if (this.mBitmapToBlur != null) {
            this.mBitmapToBlur.recycle();
            this.mBitmapToBlur = null;
        }
        if (this.mBlurredBitmap != null) {
            this.mBlurredBitmap.recycle();
            this.mBlurredBitmap = null;
        }
    }

    private void releaseScript() {
        if (this.mRenderScript != null) {
            this.mRenderScript.destroy();
            this.mRenderScript = null;
        }
        if (this.mBlurScript != null) {
            this.mBlurScript.destroy();
            this.mBlurScript = null;
        }
    }

    protected void release() {
        this.releaseBitmap();
        this.releaseScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepare() {
        block21: {
            if (this.mBlurRadius == 0.0f || !this.isAlive()) {
                this.release();
                return false;
            }
            float downsampleFactor = this.mDownSampleFactor;
            if ((this.mDirty || this.mRenderScript == null) && supportRenderScript && this.useBlur) {
                if (this.mRenderScript == null) {
                    try {
                        this.mRenderScript = RenderScript.create((Context)this.getContext());
                        this.mBlurScript = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
                    }
                    catch (Exception e) {
                        supportRenderScript = false;
                        if (BlurLinearLayout.isDebug()) {
                            e.printStackTrace();
                        }
                        return false;
                    }
                }
                this.mDirty = false;
                float radius = this.mBlurRadius / downsampleFactor;
                if (radius > 25.0f) {
                    downsampleFactor = downsampleFactor * radius / 25.0f;
                    radius = 25.0f;
                }
                if (this.mBlurScript != null) {
                    this.mBlurScript.setRadius(radius);
                }
            }
            int width = this.getWidth();
            int height = this.getHeight();
            int scaledWidth = Math.max(1, (int)((float)width / downsampleFactor));
            int scaledHeight = Math.max(1, (int)((float)height / downsampleFactor));
            if (this.mBlurringCanvas == null || this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
                this.releaseBitmap();
                boolean r = false;
                try {
                    this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    if (this.mBitmapToBlur == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
                    if (!supportRenderScript || !this.useBlur) {
                        boolean bl = true;
                        return bl;
                    }
                    this.mBlurInput = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)this.mBitmapToBlur, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
                    this.mBlurOutput = Allocation.createTyped((RenderScript)this.mRenderScript, (Type)this.mBlurInput.getType());
                    this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    if (this.mBlurredBitmap == null) {
                        boolean bl = false;
                        return bl;
                    }
                    r = true;
                }
                catch (Exception e) {
                    if (BlurLinearLayout.isDebug()) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (r) break block21;
                    this.releaseBitmap();
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isAlive() {
        Context context = this.getContext();
        if (context instanceof Activity) {
            return this.isAttachedToWindow() && !((Activity)context).isDestroyed();
        }
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return this.isAttachedToWindow() && !((Activity)context).isDestroyed();
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return this.isAttachedToWindow() && this.getContext() != null;
    }

    protected void blur(Bitmap bitmapToBlur, Bitmap blurredBitmap) {
        this.mBlurInput.copyFrom(bitmapToBlur);
        this.mBlurScript.setInput(this.mBlurInput);
        this.mBlurScript.forEach(this.mBlurOutput);
        this.mBlurOutput.copyTo(blurredBitmap);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Activity activity = this.getContext() instanceof Activity ? (Activity)this.getContext() : BaseDialog.getTopActivity();
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        if (decorView.getChildCount() >= 1) {
            this.mDecorView = decorView.getChildAt(0);
        }
        if (this.mDecorView != null) {
            BlurLinearLayout.log("mDecorView is ok.");
            this.mDecorView.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
            boolean bl = this.mDifferentRoot = this.mDecorView.getRootView() != this.getRootView();
            if (this.mDifferentRoot) {
                this.mDecorView.postInvalidate();
            }
        } else {
            BlurLinearLayout.log("mDecorView is NULL.");
            this.mDifferentRoot = false;
        }
    }

    protected void onDetachedFromWindow() {
        this.destroy();
        super.onDetachedFromWindow();
    }

    private void destroy() {
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
        }
        this.release();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.isCompatMode()) {
            this.drawBlurredBitmapCompat(canvas);
        } else {
            this.drawBlurredBitmap(canvas, this.mBlurredBitmap);
        }
        super.dispatchDraw(canvas);
    }

    public void draw(Canvas canvas) {
        BlurLinearLayout.log("#draw");
        if (!this.useBlur || !supportRenderScript) {
            this.mRectF.right = this.getWidth();
            this.mRectF.bottom = this.getHeight();
            this.overlayPaint.setColor(this.getOverlayColor());
            canvas.drawRoundRect(this.mRectF, this.mRadius, this.mRadius, this.overlayPaint);
        } else if (!this.mIsRendering && RENDERING_COUNT <= 0) {
            BlurLinearLayout.log("draw: ok");
            super.draw(canvas);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isCompatMode()) {
            this.drawBlurredBitmapCompat(canvas);
        } else {
            this.drawBlurredBitmap(canvas, this.mBlurredBitmap);
        }
        super.onDraw(canvas);
    }

    private void drawBlurredBitmapCompat(Canvas canvas) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.mBlurredBitmap != null) {
            this.mRectDst.right = this.getWidth();
            this.mRectDst.bottom = this.getHeight();
            if (this.getWidth() > 0 && this.getHeight() > 0) {
                Bitmap readyDrawBitmap = this.getRoundedCornerBitmap(this.resizeImage(this.mBlurredBitmap, this.getWidth(), this.getHeight()), this.mRectDst);
                if (readyDrawBitmap != null) {
                    canvas.drawBitmap(readyDrawBitmap, 0.0f, 0.0f, null);
                } else {
                    Bitmap overlyBitmap = this.drawOverlyColor(Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888));
                    if (overlyBitmap != null) {
                        canvas.drawBitmap(overlyBitmap, 0.0f, 0.0f, null);
                    }
                }
            }
        } else {
            Bitmap overlyBitmap = this.drawOverlyColor(Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888));
            if (overlyBitmap != null) {
                canvas.drawBitmap(overlyBitmap, 0.0f, 0.0f, null);
            }
        }
    }

    protected void drawBlurredBitmap(Canvas canvas, Bitmap blurredBitmap) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (blurredBitmap != null) {
            this.mRectSrc.right = blurredBitmap.getWidth();
            this.mRectSrc.bottom = blurredBitmap.getHeight();
            this.mRectDst.right = this.getWidth();
            this.mRectDst.bottom = this.getHeight();
            canvas.drawBitmap(blurredBitmap, this.mRectSrc, this.mRectDst, null);
            canvas.drawColor(this.getOverlayColor());
        } else {
            Bitmap overlyBitmap = this.drawOverlyColor(Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888));
            if (overlyBitmap != null) {
                canvas.drawBitmap(overlyBitmap, 0.0f, 0.0f, null);
            }
        }
    }

    private Bitmap getRoundedCornerBitmap(Bitmap bitmap, Rect mRectDst) {
        if ((bitmap = this.drawOverlyColor(this.resizeImage(bitmap, mRectDst.width(), mRectDst.height()))) == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)bitmapShader);
        canvas.drawRoundRect(new RectF(mRectDst), this.mRadius, this.mRadius, paint);
        return output;
    }

    private Bitmap drawOverlyColor(Bitmap bitmap) {
        if (bitmap != null) {
            Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            Rect originRect = new Rect();
            originRect.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
            canvas.drawBitmap(bitmap, originRect, originRect, this.overlayPaint);
            canvas.drawColor(this.getOverlayColor());
            return output;
        }
        return null;
    }

    private Bitmap resizeImage(Bitmap bitmap, int newWidth, int newHeight) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            float scaleWidth = (float)newWidth / (float)width;
            float scaleHeight = (float)newHeight / (float)height;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return null;
    }

    public boolean isUseBlur() {
        return this.useBlur;
    }

    public BlurLinearLayout setUseBlur(boolean useBlur) {
        this.useBlur = useBlur;
        this.invalidate();
        return this;
    }

    private boolean needRemoveAlphaColor() {
        if (this.overrideOverlayColor) {
            return false;
        }
        return this.noAlpha || !supportRenderScript || !this.useBlur;
    }

    private static int removeAlphaColor(int color2) {
        int alpha = 255;
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private static int replaceAlphaColor(int color2, int alpha) {
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    static boolean isDebug() {
        return DEBUGMODE && DialogX.DEBUGMODE;
    }

    private static void log(Object o) {
        if (BlurLinearLayout.isDebug()) {
            Log.i((String)">>>", (String)("DialogX.BlurView: " + o.toString()));
        }
    }

    public static void error(Object o) {
        if (BlurLinearLayout.isDebug()) {
            Log.e((String)">>>", (String)o.toString());
        }
    }

    public BlurLinearLayout setOverrideOverlayColor(boolean overrideOverlayColor) {
        BlurLinearLayout.log("setOverrideOverlayColor: " + overrideOverlayColor);
        this.overrideOverlayColor = overrideOverlayColor;
        return this;
    }

    private int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private int getOverlayColor() {
        return this.needRemoveAlphaColor() ? BlurLinearLayout.removeAlphaColor(this.mOverlayColor) : this.mOverlayColor;
    }

    static {
        supportRenderScript = false;
        new Thread(){

            @Override
            public void run() {
                try {
                    BlurLinearLayout.class.getClassLoader().loadClass(RenderScript.class.getCanonicalName());
                    supportRenderScript = true;
                }
                catch (Throwable e) {
                    if (BlurLinearLayout.isDebug()) {
                        e.printStackTrace();
                    }
                    supportRenderScript = false;
                }
            }
        }.start();
        DEBUGMODE = false;
    }
}

