/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.baseokhttp.util;

import android.util.Log;
import com.kongzue.baseokhttp.util.JsonMap;
import java.util.Map;
import java.util.TreeMap;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class Parameter
extends TreeMap<String, Object> {
    public Parameter add(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public String toParameterString() {
        String result = "";
        if (!this.entrySet().isEmpty()) {
            for (Map.Entry entry : this.entrySet()) {
                result = result + (String)entry.getKey() + "=" + entry.getValue() + "&";
            }
            if (result.endsWith("&")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    @Deprecated
    public void toPrintString() {
        this.toPrintString(0);
    }

    @Deprecated
    public void toPrintString(int e) {
        if (!this.entrySet().isEmpty()) {
            for (Map.Entry entry : this.entrySet()) {
                if (e == 0) {
                    Log.i((String)">>>>>>", (String)((String)entry.getKey() + "=" + entry.getValue()));
                    continue;
                }
                Log.e((String)">>>>>>", (String)((String)entry.getKey() + "=" + entry.getValue()));
            }
        }
    }

    public RequestBody toOkHttpParameter() {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry entry : this.entrySet()) {
            builder.add((String)entry.getKey() + "", entry.getValue() + "");
        }
        FormBody requestBody = builder.build();
        return requestBody;
    }

    public JSONObject toParameterJson() {
        JSONObject result = new JSONObject();
        try {
            if (!this.entrySet().isEmpty()) {
                for (Map.Entry entry : this.entrySet()) {
                    result.put((String)entry.getKey(), entry.getValue());
                }
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonMap toParameterJsonMap() {
        JsonMap result = new JsonMap();
        try {
            if (!this.entrySet().isEmpty()) {
                for (Map.Entry entry : this.entrySet()) {
                    result.put((String)entry.getKey(), entry.getValue());
                }
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        Object value = this.get(key);
        if (this.isNull(String.valueOf(value))) {
            return defaultValue;
        }
        return value == null ? "" : String.valueOf(value);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int emptyValue) {
        int result = emptyValue;
        try {
            result = Integer.parseInt(this.get(key) + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean emptyValue) {
        boolean result = emptyValue;
        try {
            result = Boolean.parseBoolean(this.get(key) + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long emptyValue) {
        long result = emptyValue;
        try {
            result = Long.parseLong(this.get(key) + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short emptyValue) {
        short result = emptyValue;
        try {
            result = Short.parseShort(this.get(key) + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double emptyValue) {
        double result = emptyValue;
        try {
            result = Double.parseDouble(this.get(key) + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float emptyValue) {
        float result = emptyValue;
        try {
            result = Float.parseFloat(this.get(key) + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return emptyValue;
    }

    private boolean isNull(String s) {
        return s == null || s.trim().isEmpty() || "null".equals(s);
    }

    @Override
    public boolean equals(Object o) {
        return this.toString().equals(o.toString());
    }
}

