/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.spring.SpringResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

public class SpringMvcApiReader
extends AbstractReader
implements ClassSwaggerReader {
    private String resourcePath;

    public SpringMvcApiReader(Swagger swagger, LogAdapter log) {
        super(swagger, log);
    }

    @Override
    public Swagger read(Set<Class<?>> classes) throws GenerateException {
        Map<String, SpringResource> resourceMap = this.generateResourceMap(classes);
        for (String str : resourceMap.keySet()) {
            SpringResource resource = resourceMap.get(str);
            this.read(resource);
        }
        return this.swagger;
    }

    public Swagger read(SpringResource resource) {
        if (this.swagger == null) {
            this.swagger = new Swagger();
        }
        List<Method> methods = resource.getMethods();
        HashMap<String, Tag> tags = new HashMap();
        ArrayList<SecurityRequirement> resourceSecurities = new ArrayList();
        Class<?> controller = resource.getControllerClass();
        RequestMapping controllerRM = (RequestMapping)AnnotationUtils.findAnnotation(controller, RequestMapping.class);
        String[] controllerProduces = new String[]{};
        String[] controllerConsumes = new String[]{};
        if (controllerRM != null) {
            controllerConsumes = controllerRM.consumes();
            controllerProduces = controllerRM.produces();
        }
        if (controller != null && controller.isAnnotationPresent(Api.class)) {
            Api api = (Api)AnnotationUtils.findAnnotation(controller, Api.class);
            if (!this.canReadApi(false, api)) {
                return this.swagger;
            }
            tags = this.updateTagsForApi(null, api);
            resourceSecurities = this.getSecurityRequirements(api);
        }
        this.resourcePath = resource.getControllerMapping();
        Map<String, List<Method>> apiMethodMap = this.collectApisByRequestMapping(methods);
        for (String path : apiMethodMap.keySet()) {
            for (Method method : apiMethodMap.get(path)) {
                ApiOperation apiOperation;
                RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                if (requestMapping == null || (apiOperation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class)) == null || apiOperation.hidden()) continue;
                String httpMethod = null;
                HashMap<String, String> regexMap = new HashMap<String, String>();
                String operationPath = this.parseOperationPath(path, regexMap);
                for (RequestMethod requestMethod : requestMapping.method()) {
                    httpMethod = requestMethod.toString().toLowerCase();
                    Operation operation = this.parseMethod(method);
                    this.updateOperationParameters(new ArrayList<Parameter>(), regexMap, operation);
                    this.updateOperationProtocols(apiOperation, operation);
                    String[] apiProduces = requestMapping.produces();
                    String[] apiConsumes = requestMapping.consumes();
                    apiProduces = apiProduces == null || apiProduces.length == 0 ? controllerProduces : apiProduces;
                    apiConsumes = apiConsumes == null || apiProduces.length == 0 ? controllerConsumes : apiConsumes;
                    apiConsumes = this.updateOperationConsumes(new String[0], apiConsumes, operation);
                    apiProduces = this.updateOperationProduces(new String[0], apiProduces, operation);
                    this.updateTagsForOperation(operation, apiOperation);
                    this.updateOperation(apiConsumes, apiProduces, tags, resourceSecurities, operation);
                    this.updatePath(operationPath, httpMethod, operation);
                }
            }
        }
        return this.swagger;
    }

    /*
     * WARNING - void declaration
     */
    private Operation parseMethod(Method method) {
        ApiResponses apiResponses;
        Operation operation = new Operation();
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        Type responseClass = null;
        ArrayList<String> produces = new ArrayList<String>();
        ArrayList<String> consumes = new ArrayList<String>();
        String responseContainer = null;
        String operationId = method.getName();
        Map<String, Property> defaultResponseHeaders = null;
        Set<Map<String, Object>> customExtensions = null;
        ApiOperation apiOperation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class);
        if (apiOperation.hidden()) {
            return null;
        }
        if (!"".equals(apiOperation.nickname())) {
            operationId = apiOperation.nickname();
        }
        defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
        operation.summary(apiOperation.value()).description(apiOperation.notes());
        customExtensions = this.parseCustomExtensions(apiOperation.extensions());
        if (customExtensions != null) {
            for (Map<String, Object> map : customExtensions) {
                if (map == null) continue;
                for (Map.Entry<String, Object> map2 : map.entrySet()) {
                    operation.setVendorExtension(map2.getKey().startsWith("x-") ? map2.getKey() : "x-" + map2.getKey(), map2.getValue());
                }
            }
        }
        if (apiOperation.response() != null && !Void.class.equals((Object)apiOperation.response())) {
            responseClass = apiOperation.response();
        }
        if (!"".equals(apiOperation.responseContainer())) {
            responseContainer = apiOperation.responseContainer();
        }
        if (apiOperation.authorizations() != null) {
            ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
            for (Authorization auth : apiOperation.authorizations()) {
                AuthorizationScope[] scopes;
                if (auth.value() == null || "".equals(auth.value())) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : scopes = auth.scopes()) {
                    if (scope.scope() == null || "".equals(scope.scope())) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
            if (securities.size() > 0) {
                for (SecurityRequirement sec : securities) {
                    operation.security(sec);
                }
            }
        }
        if (responseClass == null) {
            this.LOG.info("picking up response class from method " + method);
            responseClass = method.getGenericReturnType();
        }
        if (responseClass instanceof ParameterizedType && ResponseEntity.class.equals((Object)((ParameterizedType)responseClass).getRawType())) {
            responseClass = ((ParameterizedType)responseClass).getActualTypeArguments()[0];
        }
        boolean hasApiAnnotation = false;
        if (responseClass instanceof Class) {
            boolean bl = hasApiAnnotation = AnnotationUtils.findAnnotation((Class)responseClass, Api.class) != null;
        }
        if (!(responseClass == null || responseClass.equals(Void.class) || responseClass.equals(ResponseEntity.class) || hasApiAnnotation)) {
            if (this.isPrimitive(responseClass)) {
                Object var13_18 = null;
                Property property = ModelConverters.getInstance().readAsProperty(responseClass);
                if (property != null) {
                    void var13_22;
                    if ("list".equalsIgnoreCase(responseContainer)) {
                        ArrayProperty arrayProperty = new ArrayProperty(property);
                    } else if ("map".equalsIgnoreCase(responseContainer)) {
                        MapProperty mapProperty = new MapProperty(property);
                    } else {
                        Property property2 = property;
                    }
                    operation.response(apiOperation.code(), new Response().description("successful operation").schema((Property)var13_22).headers(defaultResponseHeaders));
                }
            } else if (!responseClass.equals(Void.class) && !"void".equals(responseClass.toString())) {
                Map map = ModelConverters.getInstance().read(responseClass);
                if (map.size() == 0) {
                    Property pp = ModelConverters.getInstance().readAsProperty(responseClass);
                    operation.response(apiOperation.code(), new Response().description("successful operation").schema(pp).headers(defaultResponseHeaders));
                }
                for (String key : map.keySet()) {
                    Object responseProperty = null;
                    responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty((Property)new RefProperty().asDefault(key)) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty((Property)new RefProperty().asDefault(key)) : new RefProperty().asDefault(key));
                    operation.response(apiOperation.code(), new Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                    this.swagger.model(key, (Model)map.get(key));
                }
                Map map3 = ModelConverters.getInstance().readAll(responseClass);
                for (String key : map3.keySet()) {
                    this.swagger.model(key, (Model)map3.get(key));
                }
            }
        }
        operation.operationId(operationId);
        if (requestMapping.produces() != null) {
            for (String str : Arrays.asList(requestMapping.produces())) {
                if (produces.contains(str)) continue;
                produces.add(str);
            }
        }
        if (requestMapping.consumes() != null) {
            for (String str : Arrays.asList(requestMapping.consumes())) {
                if (consumes.contains(str)) continue;
                consumes.add(str);
            }
        }
        if ((apiResponses = (ApiResponses)AnnotationUtils.findAnnotation((Method)method, ApiResponses.class)) != null) {
            this.updateApiResponse(operation, apiResponses);
        } else {
            ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation((Method)method, ResponseStatus.class);
            if (responseStatus != null) {
                operation.response(responseStatus.value().value(), new Response().description(responseStatus.reason()));
            }
        }
        Deprecated annotation = (Deprecated)AnnotationUtils.findAnnotation((Method)method, Deprecated.class);
        if (annotation != null) {
            operation.deprecated(Boolean.valueOf(true));
        }
        boolean hidden = false;
        if (apiOperation != null) {
            hidden = apiOperation.hidden();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = genericParameterTypes[i];
            List<Annotation> annotations = Arrays.asList(paramAnnotations[i]);
            List<Parameter> parameters = this.getParameters(type, annotations);
            for (Parameter parameter : parameters) {
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            operation.defaultResponse(new Response().description("successful operation"));
        }
        this.readImplicitParameters(method, operation);
        return operation;
    }

    private Map<String, List<Method>> collectApisByRequestMapping(List<Method> methods) {
        HashMap<String, List<Method>> apiMethodMap = new HashMap<String, List<Method>>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(RequestMapping.class)) continue;
            RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            String path = "";
            path = requestMapping.value() != null && requestMapping.value().length != 0 ? this.generateFullPath(requestMapping.value()[0]) : this.resourcePath;
            if (apiMethodMap.containsKey(path)) {
                ((List)apiMethodMap.get(path)).add(method);
                continue;
            }
            ArrayList<Method> ms = new ArrayList<Method>();
            ms.add(method);
            apiMethodMap.put(path, ms);
        }
        return apiMethodMap;
    }

    private String generateFullPath(String path) {
        if (StringUtils.isNotEmpty((String)path)) {
            return this.resourcePath + (path.startsWith("/") ? path : '/' + path);
        }
        return this.resourcePath;
    }

    private Class<?> getGenericSubtype(Class<?> clazz, Type t) {
        if (!clazz.getName().equals("void") && !t.toString().equals("void")) {
            try {
                ParameterizedType paramType = (ParameterizedType)t;
                Type[] argTypes = paramType.getActualTypeArguments();
                if (argTypes.length > 0) {
                    Class c = (Class)argTypes[0];
                    return c;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private Map<String, SpringResource> analyzeController(Class<?> clazz, Map<String, SpringResource> resourceMap, String description) throws ClassNotFoundException {
        String controllerCanonicalName = clazz.getCanonicalName();
        String[] controllerRequestMappingValues = null;
        controllerRequestMappingValues = AnnotationUtils.findAnnotation(clazz, RequestMapping.class) != null && ((RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class)).value() != null ? ((RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class)).value() : new String[]{""};
        for (int i = 0; i < controllerRequestMappingValues.length; ++i) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                RequestMethod[] requestMappingRequestMethods;
                RequestMapping methodRequestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                if (!(methodRequestMapping instanceof RequestMapping)) continue;
                for (RequestMethod requestMappingRequestMethod : requestMappingRequestMethods = methodRequestMapping.method()) {
                    String[] methodRequestMappingValues = methodRequestMapping.value();
                    if (methodRequestMappingValues == null || methodRequestMappingValues.length == 0) {
                        String resourceKey = controllerCanonicalName + controllerRequestMappingValues[i] + requestMappingRequestMethod;
                        if (!resourceMap.containsKey(resourceKey)) {
                            resourceMap.put(resourceKey, new SpringResource(clazz, controllerRequestMappingValues[i], resourceKey, description));
                        }
                        resourceMap.get(resourceKey).addMethod(method);
                        continue;
                    }
                    String[] stringArray = methodRequestMappingValues;
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        String methodRequestMappingValue;
                        String resourceName = methodRequestMappingValue = stringArray[j];
                        String resourceKey = controllerCanonicalName + controllerRequestMappingValues[i] + resourceName + requestMappingRequestMethod;
                        if (resourceName.equals("")) continue;
                        if (!resourceMap.containsKey(resourceKey)) {
                            resourceMap.put(resourceKey, new SpringResource(clazz, resourceName, resourceKey, description));
                        }
                        resourceMap.get(resourceKey).addMethod(method);
                    }
                }
            }
        }
        clazz.getFields();
        clazz.getDeclaredFields();
        return resourceMap;
    }

    protected Map<String, SpringResource> generateResourceMap(Set<Class<?>> validClasses) throws GenerateException {
        Map<String, SpringResource> resourceMap = new HashMap<String, SpringResource>();
        for (Class<?> c : validClasses) {
            RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(c, RequestMapping.class);
            String description = "";
            try {
                resourceMap = this.analyzeController(c, resourceMap, description);
                ArrayList<Method> mList = new ArrayList<Method>(Arrays.asList(c.getMethods()));
                if (c.getSuperclass() == null) continue;
                mList.addAll(Arrays.asList(c.getSuperclass().getMethods()));
            }
            catch (NoClassDefFoundError e) {
                this.LOG.error(e.getMessage());
                this.LOG.info(c.getName());
            }
            catch (ClassNotFoundException e) {
                this.LOG.error(e.getMessage());
                this.LOG.info(c.getName());
            }
        }
        return resourceMap;
    }
}

