/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.spring;

import io.swagger.annotations.ApiParam;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.reflections.util.Utils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringSwaggerExtension
extends AbstractSwaggerExtension
implements SwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        String defaultValue = "";
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof ModelAttribute) {
                parameters.addAll(this.extractParametersFromModelAttributeAnnotation(annotation, type));
            } else {
                parameter = this.extractParameterFromAnnotation(annotation, defaultValue, type);
            }
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    private Parameter extractParameterFromAnnotation(Annotation annotation, String defaultValue, Type type) {
        PathParameter parameter = null;
        if (annotation instanceof RequestParam) {
            Property schema;
            RequestParam param = (RequestParam)annotation;
            QueryParameter qp = (QueryParameter)new QueryParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                qp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                qp.setProperty(schema);
            }
            qp.setRequired(param.required());
            parameter = qp;
        } else if (annotation instanceof PathVariable) {
            Property schema;
            PathVariable param = (PathVariable)annotation;
            PathParameter pp = (PathParameter)new PathParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                pp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                pp.setProperty(schema);
            }
            parameter = pp;
        } else if (annotation instanceof RequestHeader) {
            RequestHeader param = (RequestHeader)annotation;
            HeaderParameter hp = (HeaderParameter)new HeaderParameter().name(param.value());
            hp.setDefaultValue(defaultValue);
            Property schema = ModelConverters.getInstance().readAsProperty(type);
            if (schema != null) {
                hp.setProperty(schema);
            }
            hp.setRequired(param.required());
            parameter = hp;
        } else if (annotation instanceof CookieValue) {
            Property schema;
            CookieValue param = (CookieValue)annotation;
            CookieParameter cp = (CookieParameter)new CookieParameter().name(param.value());
            if (!defaultValue.isEmpty()) {
                cp.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                cp.setProperty(schema);
            }
            cp.setRequired(param.required());
            parameter = cp;
        }
        return parameter;
    }

    private List<Parameter> extractParametersFromModelAttributeAnnotation(Annotation annotation, Type type) {
        if (!(annotation instanceof ModelAttribute)) {
            return null;
        }
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors((Class)cls)) {
            Class<?> parameterClass;
            Annotation firstMethodParameterAnnotation;
            Annotation propertySetterApiParam;
            Method propertyDescriptorSetter = propertyDescriptor.getWriteMethod();
            if (propertyDescriptorSetter == null || !((propertySetterApiParam = AnnotationUtils.findAnnotation((Method)propertyDescriptorSetter, ApiParam.class)) instanceof ApiParam)) continue;
            Parameter propertySetterExtractedParameter = null;
            Annotation[][] methodAnnotations = propertyDescriptorSetter.getParameterAnnotations();
            if (methodAnnotations == null || methodAnnotations.length == 0) continue;
            String defaultValue = "";
            Annotation[] annotationArray = methodAnnotations[0];
            int n = annotationArray.length;
            for (int i = 0; i < n && !((propertySetterExtractedParameter = this.extractParameterFromAnnotation(firstMethodParameterAnnotation = annotationArray[i], defaultValue, parameterClass = propertyDescriptor.getPropertyType())) instanceof Parameter); ++i) {
            }
            if (!(propertySetterExtractedParameter instanceof Parameter)) {
                QueryParameter qp = (QueryParameter)new QueryParameter().name(propertyDescriptor.getDisplayName());
                Property schema = ModelConverters.getInstance().readAsProperty(propertyDescriptor.getPropertyType());
                if (schema != null) {
                    qp.setProperty(schema);
                }
                ApiParam methodApiParamAnnotation = (ApiParam)propertySetterApiParam;
                qp.setDescription(methodApiParamAnnotation.value());
                qp.setRequired(methodApiParamAnnotation.required());
                qp.setAccess(methodApiParamAnnotation.access());
                if (!Utils.isEmpty((String)methodApiParamAnnotation.name())) {
                    qp.setName(methodApiParamAnnotation.name());
                }
                parameters.add((Parameter)qp);
                continue;
            }
            parameters.add(propertySetterExtractedParameter);
        }
        return parameters;
    }

    public boolean shouldIgnoreType(Type type, Set<Type> typesToSkip) {
        boolean output = false;
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        output = cls.getName().startsWith("org.springframework");
        return output;
    }
}

