/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.rpc;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.extensions.BigIntegerKt;
import org.kethereum.model.Address;
import org.kethereum.model.ChainId;
import org.kethereum.model.SignedTransaction;
import org.kethereum.model.Transaction;
import org.kethereum.rpc.BaseEthereumRPCKt;
import org.kethereum.rpc.ConverterKt;
import org.kethereum.rpc.EthereumRPC;
import org.kethereum.rpc.EthereumRPCException;
import org.kethereum.rpc.OKHttpExtensionsKt;
import org.kethereum.rpc.RPCTransport;
import org.kethereum.rpc.model.BigIntegerAdapter;
import org.kethereum.rpc.model.BlockInformation;
import org.kethereum.rpc.model.BlockInformationResponse;
import org.kethereum.rpc.model.StringResultResponse;
import org.kethereum.rpc.model.TransactionResponse;
import org.kethereum.rpc.model.rpc.BlockInformationRPC;
import org.kethereum.rpc.model.rpc.TransactionRPC;
import org.komputing.khex.model.HexString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J'\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0010H\u0016J'\u0010&\u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b'\u0010(J/\u0010)\u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0016H\u0016J\u001a\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u00102\u001a\u00020\u0016H\u0016J\u001c\u00103\u001a\u0004\u0018\u00010\f2\u0006\u00104\u001a\u00020\u00162\b\b\u0002\u00105\u001a\u00020\u0016H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u00066"}, d2={"Lorg/kethereum/rpc/BaseEthereumRPC;", "Lorg/kethereum/rpc/EthereumRPC;", "transport", "Lorg/kethereum/rpc/RPCTransport;", "(Lorg/kethereum/rpc/RPCTransport;)V", "blockInfoAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/kethereum/rpc/model/BlockInformationResponse;", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "stringResultAdapter", "Lorg/kethereum/rpc/model/StringResultResponse;", "transactionAdapter", "Lorg/kethereum/rpc/model/TransactionResponse;", "blockNumber", "Ljava/math/BigInteger;", "call", "Lorg/komputing/khex/model/HexString;", "transaction", "Lorg/kethereum/model/Transaction;", "block", "", "call-gvVG85o", "(Lorg/kethereum/model/Transaction;Ljava/lang/String;)Ljava/lang/String;", "chainId", "Lorg/kethereum/model/ChainId;", "chainId-az3pVX0", "()Ljava/math/BigInteger;", "clientVersion", "estimateGas", "gasPrice", "getBalance", "address", "Lorg/kethereum/model/Address;", "getBlockByNumber", "Lorg/kethereum/rpc/model/BlockInformation;", "number", "getCode", "getCode-gvVG85o", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "getStorageAt", "position", "getStorageAt-gvVG85o", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "getTransactionByHash", "Lorg/kethereum/model/SignedTransaction;", "hash", "getTransactionCount", "sendRawTransaction", "data", "stringCall", "function", "params", "rpc"})
public class BaseEthereumRPC
implements EthereumRPC {
    private final Moshi moshi;
    private final JsonAdapter<StringResultResponse> stringResultAdapter;
    private final JsonAdapter<BlockInformationResponse> blockInfoAdapter;
    private final JsonAdapter<TransactionResponse> transactionAdapter;
    private final RPCTransport transport;

    private final StringResultResponse stringCall(String function, String params) {
        StringResultResponse stringResultResponse;
        String string = this.transport.call(function, params);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            boolean bl3 = false;
            stringResultResponse = OKHttpExtensionsKt.fromJsonNoThrow(this.stringResultAdapter, string3);
        } else {
            stringResultResponse = null;
        }
        return stringResultResponse;
    }

    static /* synthetic */ StringResultResponse stringCall$default(BaseEthereumRPC baseEthereumRPC, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stringCall");
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        return baseEthereumRPC.stringCall(string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public BlockInformation getBlockByNumber(@NotNull BigInteger number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        String string = this.transport.call("eth_getBlockByNumber", '\"' + BigIntegerKt.toHexString((BigInteger)number) + "\", true");
        Object object = string;
        if (string == null) return null;
        String string2 = object;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = string2;
        boolean bl3 = false;
        BlockInformationResponse blockInformationResponse = OKHttpExtensionsKt.fromJsonNoThrow(this.blockInfoAdapter, string3);
        object = blockInformationResponse;
        if (blockInformationResponse == null) return null;
        BlockInformationRPC blockInformationRPC = ((BlockInformationResponse)object).getResult();
        object = blockInformationRPC;
        if (blockInformationRPC == null) return null;
        BlockInformation blockInformation = ConverterKt.toBlockInformation((BlockInformationRPC)object);
        return blockInformation;
    }

    @Override
    @Nullable
    public String sendRawTransaction(@NotNull String data) throws EthereumRPCException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        StringResultResponse stringResultResponse = this.stringCall("eth_sendRawTransaction", '\"' + data + '\"');
        return stringResultResponse != null ? BaseEthereumRPCKt.access$throwOrString(stringResultResponse) : null;
    }

    @Override
    @Nullable
    public BigInteger blockNumber() throws EthereumRPCException {
        StringResultResponse stringResultResponse = BaseEthereumRPC.stringCall$default(this, "eth_blockNumber", null, 2, null);
        return stringResultResponse != null ? BaseEthereumRPCKt.access$getBigIntegerFromStringResult(stringResultResponse) : null;
    }

    @Override
    @Nullable
    public String call-gvVG85o(@NotNull Transaction transaction, @NotNull String block) throws EthereumRPCException {
        String string;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object object = this.stringCall("eth_call", ConverterKt.toJSON(transaction) + ",\"" + block + '\"');
        if (object != null && (object = BaseEthereumRPCKt.access$throwOrString((StringResultResponse)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            string = HexString.constructor-impl((String)it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public BigInteger gasPrice() throws EthereumRPCException {
        StringResultResponse stringResultResponse = BaseEthereumRPC.stringCall$default(this, "eth_gasPrice", null, 2, null);
        return stringResultResponse != null ? BaseEthereumRPCKt.access$getBigIntegerFromStringResult(stringResultResponse) : null;
    }

    @Override
    @Nullable
    public String clientVersion() throws EthereumRPCException {
        StringResultResponse stringResultResponse = BaseEthereumRPC.stringCall$default(this, "web3_clientVersion", null, 2, null);
        return stringResultResponse != null ? BaseEthereumRPCKt.access$throwOrString(stringResultResponse) : null;
    }

    @Override
    @Nullable
    public BigInteger chainId-az3pVX0() throws EthereumRPCException {
        BigInteger bigInteger;
        Object object = BaseEthereumRPC.stringCall$default(this, "eth_chainId", null, 2, null);
        if (object != null && (object = BaseEthereumRPCKt.access$getBigIntegerFromStringResult((StringResultResponse)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            bigInteger = ChainId.constructor-impl((BigInteger)it);
        } else {
            bigInteger = null;
        }
        return bigInteger;
    }

    @Override
    @Nullable
    public String getStorageAt-gvVG85o(@NotNull String address, @NotNull String position, @NotNull String block) throws EthereumRPCException {
        String string;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object object = this.stringCall("eth_getStorageAt", '\"' + address + "\",\"" + position + "\",\"" + block + '\"');
        if (object != null && (object = BaseEthereumRPCKt.access$throwOrString((StringResultResponse)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            string = HexString.constructor-impl((String)it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public BigInteger getTransactionCount(@NotNull String address, @NotNull String block) throws EthereumRPCException {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        StringResultResponse stringResultResponse = this.stringCall("eth_getTransactionCount", '\"' + address + "\",\"" + block + '\"');
        return stringResultResponse != null ? BaseEthereumRPCKt.access$getBigIntegerFromStringResult(stringResultResponse) : null;
    }

    @Override
    @Nullable
    public String getCode-gvVG85o(@NotNull String address, @NotNull String block) throws EthereumRPCException {
        String string;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object object = this.stringCall("eth_getCode", '\"' + address + "\",\"" + block + '\"');
        if (object != null && (object = BaseEthereumRPCKt.access$throwOrString((StringResultResponse)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            string = HexString.constructor-impl((String)it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public BigInteger estimateGas(@NotNull Transaction transaction) throws EthereumRPCException {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        StringResultResponse stringResultResponse = this.stringCall("eth_estimateGas", ConverterKt.toJSON(transaction));
        return stringResultResponse != null ? BaseEthereumRPCKt.access$getBigIntegerFromStringResult(stringResultResponse) : null;
    }

    @Override
    @Nullable
    public BigInteger getBalance(@NotNull Address address, @NotNull String block) throws EthereumRPCException {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        StringResultResponse stringResultResponse = this.stringCall("eth_getBalance", '\"' + address.getHex() + "\",\"" + block + '\"');
        return stringResultResponse != null ? BaseEthereumRPCKt.access$getBigIntegerFromStringResult(stringResultResponse) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public SignedTransaction getTransactionByHash(@NotNull String hash) throws EthereumRPCException {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        String string = this.transport.call("eth_getTransactionByHash", '\"' + hash + '\"');
        Object object = string;
        if (string == null) return null;
        String string2 = object;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = string2;
        boolean bl3 = false;
        TransactionResponse transactionResponse = OKHttpExtensionsKt.fromJsonNoThrow(this.transactionAdapter, string3);
        object = transactionResponse;
        if (transactionResponse == null) return null;
        TransactionRPC transactionRPC = ((TransactionResponse)object).getResult();
        object = transactionRPC;
        if (transactionRPC == null) return null;
        SignedTransaction signedTransaction = ConverterKt.toKethereumTransaction((TransactionRPC)object);
        return signedTransaction;
    }

    public BaseEthereumRPC(@NotNull RPCTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        this.transport = transport;
        this.moshi = new Moshi.Builder().build().newBuilder().add((Object)new BigIntegerAdapter()).build();
        JsonAdapter jsonAdapter = this.moshi.adapter(StringResultResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(StringResultResponse::class.java)");
        this.stringResultAdapter = jsonAdapter;
        JsonAdapter jsonAdapter2 = this.moshi.adapter(BlockInformationResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"moshi.adapter(BlockInfor\u2026tionResponse::class.java)");
        this.blockInfoAdapter = jsonAdapter2;
        JsonAdapter jsonAdapter3 = this.moshi.adapter(TransactionResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"moshi.adapter(TransactionResponse::class.java)");
        this.transactionAdapter = jsonAdapter3;
    }
}

