/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.rlp;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.kethereum.extensions.IntKt;
import org.kethereum.rlp.RLPElement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0006\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0007\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\b\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0002\u00a8\u0006\u000b"}, d2={"toByteFromRLP", "", "Lorg/kethereum/rlp/RLPElement;", "toIntFromRLP", "", "toRLP", "Ljava/math/BigInteger;", "", "", "toStringFromRLP", "toUnsignedBigIntegerFromRLP", "rlp"})
public final class RLPTypeConverterKt {
    @NotNull
    public static final RLPElement toRLP(@NotNull String $this$toRLP) {
        Intrinsics.checkNotNullParameter((Object)$this$toRLP, (String)"$this$toRLP");
        String string = $this$toRLP;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return new RLPElement(byArray);
    }

    @NotNull
    public static final RLPElement toRLP(int $this$toRLP) {
        return new RLPElement(IntKt.toMinimalByteArray((int)$this$toRLP));
    }

    @NotNull
    public static final RLPElement toRLP(@NotNull BigInteger $this$toRLP) {
        Intrinsics.checkNotNullParameter((Object)$this$toRLP, (String)"$this$toRLP");
        byte[] byArray = $this$toRLP.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray()");
        return new RLPElement(IntKt.removeLeadingZero((byte[])byArray));
    }

    @NotNull
    public static final RLPElement toRLP(@NotNull byte[] $this$toRLP) {
        Intrinsics.checkNotNullParameter((Object)$this$toRLP, (String)"$this$toRLP");
        return new RLPElement($this$toRLP);
    }

    @NotNull
    public static final RLPElement toRLP(byte $this$toRLP) {
        byte[] byArray;
        int n = 1;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byte by;
            int n3 = n2;
            int n4 = n2++;
            byArray = byArray2;
            boolean bl = false;
            byArray[n4] = by = $this$toRLP;
        }
        byte[] byArray3 = byArray = byArray2;
        return new RLPElement(byArray3);
    }

    /*
     * WARNING - void declaration
     */
    public static final int toIntFromRLP(@NotNull RLPElement $this$toIntFromRLP) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toIntFromRLP, (String)"$this$toIntFromRLP");
        byte[] byArray = $this$toIntFromRLP.getBytes();
        boolean bl = false;
        if (byArray.length == 0) {
            n = 0;
        } else {
            void $this$mapIndexedTo$iv$iv;
            byte[] $this$mapIndexed$iv = $this$toIntFromRLP.getBytes();
            boolean $i$f$mapIndexed = false;
            byte[] byArray2 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            int $i$f$mapIndexedTo = 0;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void byteVal;
                int n2 = index$iv$iv++;
                void var11_12 = item$iv$iv;
                int n3 = n2;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Integer n4 = (byteVal & 0xFF) << ($this$toIntFromRLP.getBytes().length - 1 - index) * 8;
                collection.add(n4);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void i;
                $i$f$mapIndexedTo = ((Number)iterator$iv.next()).intValue();
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl3 = false;
                accumulator$iv = acc + i;
            }
            n = ((Number)accumulator$iv).intValue();
        }
        return n;
    }

    @NotNull
    public static final BigInteger toUnsignedBigIntegerFromRLP(@NotNull RLPElement $this$toUnsignedBigIntegerFromRLP) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$toUnsignedBigIntegerFromRLP, (String)"$this$toUnsignedBigIntegerFromRLP");
        byte[] byArray = $this$toUnsignedBigIntegerFromRLP.getBytes();
        boolean bl = false;
        if (byArray.length == 0) {
            BigInteger bigInteger2 = BigInteger.ZERO;
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ZERO");
        } else {
            bigInteger = new BigInteger(1, $this$toUnsignedBigIntegerFromRLP.getBytes());
        }
        return bigInteger;
    }

    public static final byte toByteFromRLP(@NotNull RLPElement $this$toByteFromRLP) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteFromRLP, (String)"$this$toByteFromRLP");
        boolean bl = $this$toByteFromRLP.getBytes().length == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "trying to convert RLP with != 1 byte to Byte";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return ArraysKt.first((byte[])$this$toByteFromRLP.getBytes());
    }

    @NotNull
    public static final String toStringFromRLP(@NotNull RLPElement $this$toStringFromRLP) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringFromRLP, (String)"$this$toStringFromRLP");
        byte[] byArray = $this$toStringFromRLP.getBytes();
        boolean bl = false;
        return new String(byArray, Charsets.UTF_8);
    }
}

