/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.erc1577;

import io.ipfs.multiformats.multihash.Multihash;
import java.net.URI;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.kethereum.erc1577.model.ContentHash;
import org.kethereum.erc1577.model.InvalidSchemeToURIError;
import org.kethereum.erc1577.model.InvalidSwarmURL;
import org.kethereum.erc1577.model.SuccessfulToContentHashResult;
import org.kethereum.erc1577.model.ToContentHashResult;
import org.komputing.khex.extensions.HexStringExtensionsKt;
import org.komputing.khex.model.HexString;
import org.komputing.kvarint.WriteVarUIntKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"getResult", "Lorg/kethereum/erc1577/model/SuccessfulToContentHashResult;", "byteArray", "", "toContentHash", "Lorg/kethereum/erc1577/model/ToContentHashResult;", "Ljava/net/URI;", "erc1577"})
public final class URIToContentHashKt {
    @NotNull
    public static final SuccessfulToContentHashResult getResult(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        return new SuccessfulToContentHashResult(ContentHash.constructor-impl(byteArray), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final ToContentHashResult toContentHash(@NotNull URI $this$toContentHash) {
        ToContentHashResult toContentHashResult;
        Intrinsics.checkNotNullParameter((Object)$this$toContentHash, (String)"$this$toContentHash");
        String string = $this$toContentHash.getScheme();
        if (string != null) {
            switch (string) {
                case "ipfs": {
                    Buffer buffer = new Buffer();
                    String string2 = $this$toContentHash.getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"host");
                    byte[] hash = Multihash.Companion.decode(Multihash.Companion.fromBase58String(string2).getRaw()).getDigest();
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)227);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)1);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)112);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)18);
                    int n = hash.length;
                    boolean bl = false;
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)UInt.constructor-impl((int)n));
                    buffer.write(hash);
                    toContentHashResult = URIToContentHashKt.getResult(buffer.readByteArray());
                    return toContentHashResult;
                }
                case "ipns": {
                    Buffer buffer = new Buffer();
                    String string3 = $this$toContentHash.getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"host");
                    String string4 = string3;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string5.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] hash = byArray;
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)229);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)1);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)112);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)0);
                    int n = hash.length;
                    boolean bl2 = false;
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)UInt.constructor-impl((int)n));
                    buffer.write(hash);
                    toContentHashResult = URIToContentHashKt.getResult(buffer.readByteArray());
                    return toContentHashResult;
                }
                case "bzz": {
                    byte[] hash;
                    try {
                        String string6 = $this$toContentHash.getHost();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"host");
                        hash = HexStringExtensionsKt.hexToByteArray-jorw2Fc((String)HexString.constructor-impl((String)string6));
                    }
                    catch (IllegalArgumentException iae) {
                        hash = null;
                    }
                    byte[] hash2 = hash;
                    if (hash2 == null) {
                        String string7 = $this$toContentHash.getHost();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"host");
                        toContentHashResult = new InvalidSwarmURL(string7);
                        return toContentHashResult;
                    }
                    Buffer buffer = new Buffer();
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)228);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)1);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)250);
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)27);
                    int n = hash2.length;
                    boolean bl = false;
                    WriteVarUIntKt.writeVarUInt-jg35MFQ((BufferedSink)((BufferedSink)buffer), (int)UInt.constructor-impl((int)n));
                    buffer.write(hash2);
                    toContentHashResult = URIToContentHashKt.getResult(buffer.readByteArray());
                    return toContentHashResult;
                }
            }
        }
        String string8 = $this$toContentHash.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"scheme");
        toContentHashResult = new InvalidSchemeToURIError(string8);
        return toContentHashResult;
    }
}

