/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.bip32;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kethereum.bip32.model.ConstantsKt;
import org.kethereum.bip32.model.ExtendedKey;
import org.kethereum.crypto.ConvertersKt;
import org.kethereum.crypto.CryptoAPI;
import org.kethereum.crypto.KeysKt;
import org.kethereum.crypto.SignKt;
import org.kethereum.crypto.api.mac.Hmac;
import org.kethereum.model.ECKeyPair;
import org.kethereum.model.PrivateKey;
import org.kethereum.model.PublicKey;
import org.komputing.kbase58.Base58Kt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"toExtendedKey", "Lorg/kethereum/bip32/model/ExtendedKey;", "Lorg/kethereum/bip32/model/Seed;", "publicKeyOnly", "", "testnet", "toExtendedKey-NOiSe6A", "([BZZ)Lorg/kethereum/bip32/model/ExtendedKey;", "Lorg/kethereum/bip32/model/XPriv;", "toExtendedKey-W_-bHRw", "(Ljava/lang/String;)Lorg/kethereum/bip32/model/ExtendedKey;", "bip32"})
public final class ConverterKt {
    @NotNull
    public static final ExtendedKey toExtendedKey-NOiSe6A(@NotNull byte[] $this$toExtendedKey, boolean publicKeyOnly, boolean testnet) {
        Intrinsics.checkNotNullParameter((Object)$this$toExtendedKey, (String)"$this$toExtendedKey");
        try {
            ExtendedKey extendedKey;
            byte[] lr;
            byte[] byArray = lr = Hmac.DefaultImpls.init$default((Hmac)CryptoAPI.INSTANCE.getHmac(), (byte[])ConstantsKt.getBITCOIN_SEED(), null, (int)2, null).generate($this$toExtendedKey);
            int n = 0;
            int n2 = 32;
            int n3 = 0;
            byte[] l = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            byte[] byArray2 = lr;
            n2 = 32;
            n3 = 64;
            boolean bl = false;
            byte[] r = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
            BigInteger m = new BigInteger(1, l);
            if (m.compareTo(SignKt.getCURVE().getN()) >= 0) {
                throw (Throwable)new KeyException("Master key creation resulted in a key with higher modulus. Suggest deriving the next increment.");
            }
            ECKeyPair keyPair = ConvertersKt.toECKeyPair-UWICACY((BigInteger)PrivateKey.constructor-impl((byte[])l));
            if (publicKeyOnly) {
                BigInteger bigInteger = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.ZERO");
                ECKeyPair pubKeyPair = new ECKeyPair(PrivateKey.constructor-impl((BigInteger)bigInteger), keyPair.getPublicKey-ERNsaTg(), null);
                extendedKey = new ExtendedKey(pubKeyPair, r, 0, 0, 0, testnet ? ConstantsKt.getTpub() : ConstantsKt.getXpub());
            } else {
                extendedKey = new ExtendedKey(keyPair, r, 0, 0, 0, testnet ? ConstantsKt.getTprv() : ConstantsKt.getXprv());
            }
            return extendedKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new KeyException(e);
        }
        catch (NoSuchProviderException e) {
            throw (Throwable)new KeyException(e);
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new KeyException(e);
        }
    }

    public static /* synthetic */ ExtendedKey toExtendedKey-NOiSe6A$default(byte[] byArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return ConverterKt.toExtendedKey-NOiSe6A(byArray, bl, bl2);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final ExtendedKey toExtendedKey-W_-bHRw(@NotNull String $this$toExtendedKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toExtendedKey, (String)"$this$toExtendedKey");
        data = Base58Kt.decodeBase58WithChecksum((String)$this$toExtendedKey);
        if (data.length != 78) {
            throw (Throwable)new KeyException("invalid extended key");
        }
        buff = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        versionBytes = new byte[4];
        buff.get(versionBytes);
        var5_4 = versionBytes;
        var6_6 = ConstantsKt.getXprv();
        var7_8 = false;
        if (Arrays.equals(var5_4, var6_6)) ** GOTO lbl-1000
        var5_4 = versionBytes;
        var6_6 = ConstantsKt.getTprv();
        var7_8 = false;
        if (Arrays.equals(var5_4, var6_6)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            var5_4 = versionBytes;
            var6_6 = ConstantsKt.getXpub();
            var7_8 = false;
            if (!Arrays.equals(var5_4, var6_6)) {
                var5_4 = versionBytes;
                var6_6 = ConstantsKt.getTpub();
                var7_8 = false;
                if (!Arrays.equals(var5_4, var6_6)) {
                    throw (Throwable)new KeyException("invalid version bytes for an extended key");
                }
            }
            v0 = false;
        }
        hasPrivate = v0;
        depth = buff.get();
        v1 = buff;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"buff");
        parent = v1.getInt();
        sequence = buff.getInt();
        chainCode = new byte[32];
        buff.get(chainCode);
        if (hasPrivate) {
            buff.get();
            privateBytes = new byte[32];
            buff.get(privateBytes);
            v2 = ConvertersKt.toECKeyPair-UWICACY((BigInteger)PrivateKey.constructor-impl((byte[])privateBytes));
        } else {
            compressedPublicBytes = new byte[33];
            buff.get(compressedPublicBytes);
            uncompressedPublicBytes = KeysKt.decompressKey((byte[])compressedPublicBytes);
            v3 = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"BigInteger.ZERO");
            v2 = new ECKeyPair(PrivateKey.constructor-impl((BigInteger)v3), PublicKey.constructor-impl((BigInteger)new BigInteger(1, uncompressedPublicBytes)), null);
        }
        keyPair = v2;
        return new ExtendedKey(keyPair, chainCode, depth, parent, sequence, versionBytes);
    }
}

