/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.abi_codegen;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.kethereum.abi.EthereumABI;
import org.kethereum.abi.EthereumABIFilterKt;
import org.kethereum.abi_codegen.CreateModelKt;
import org.kethereum.abi_codegen.EthereumABIToKotlinCodeKt;
import org.kethereum.abi_codegen.UtilKt;
import org.kethereum.abi_codegen.model.Function;
import org.kethereum.abi_codegen.model.GeneratorSpec;
import org.kethereum.abi_codegen.model.Output;
import org.kethereum.abi_codegen.model.Params;
import org.kethereum.contract.abi.types.PaginatedByteArray;
import org.kethereum.contract.abi.types.StringToTypeConverterKt;
import org.kethereum.contract.abi.types.model.ContractABITypeDefinition;
import org.kethereum.contract.abi.types.model.ETHType;
import org.kethereum.model.Address;
import org.kethereum.model.Transaction;
import org.kethereum.rpc.EthereumRPC;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"toKotlinCode", "Lcom/squareup/kotlinpoet/FileSpec;", "Lorg/kethereum/abi/EthereumABI;", "spec", "Lorg/kethereum/abi_codegen/model/GeneratorSpec;", "abi_codegen"})
public final class EthereumABIToKotlinCodeKt {
    @NotNull
    public static final FileSpec toKotlinCode(@NotNull EthereumABI $this$toKotlinCode, @NotNull GeneratorSpec spec) {
        Function it;
        TypeSpec.Builder builder;
        TypeSpec.Builder builder2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinCode, (String)"$this$toKotlinCode");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        FileSpec.Builder fileSpec = FileSpec.Companion.builder(spec.getPackageName(), spec.getClassPrefix());
        String string = spec.getTxDecoderName();
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string2;
            bl = false;
            builder2 = UtilKt.defaultConstructor(TypeSpec.Companion.classBuilder(it2), CollectionsKt.emptyList());
        } else {
            builder2 = null;
        }
        TypeSpec.Builder transactionDetector = builder2;
        TypeSpec.Builder transactionsClassBuilder = UtilKt.defaultConstructor(TypeSpec.Companion.classBuilder(spec.getClassPrefix() + "TransactionGenerator"), CollectionsKt.listOf((Object)ParameterSpec.Companion.builder("address", Reflection.getOrCreateKotlinClass(Address.class), new KModifier[0]).build()));
        String string3 = spec.getRpcConnectorName();
        if (string3 != null) {
            String string4 = string3;
            boolean it2 = false;
            bl = false;
            String it3 = string4;
            boolean bl4 = false;
            builder = UtilKt.defaultConstructor(TypeSpec.Companion.classBuilder(it3), CollectionsKt.listOf((Object[])new ParameterSpec[]{ParameterSpec.Companion.builder("address", Reflection.getOrCreateKotlinClass(Address.class), new KModifier[0]).build(), ParameterSpec.Companion.builder("rpc", Reflection.getOrCreateKotlinClass(EthereumRPC.class), new KModifier[0]).build()}));
        } else {
            builder = null;
        }
        TypeSpec.Builder rpcClassBuilder = builder;
        List allClasses = CollectionsKt.listOf((Object[])new TypeSpec.Builder[]{transactionsClassBuilder, rpcClassBuilder, transactionDetector});
        if (spec.getInternal()) {
            Iterable $this$forEach$iv = allClasses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeSpec.Builder it4 = (TypeSpec.Builder)element$iv;
                boolean bl5 = false;
                Object object = it4;
                Boolean bl6 = object != null && (object = object.getModifiers()) != null ? Boolean.valueOf(object.add(KModifier.INTERNAL)) : null;
            }
        }
        TypeSpec.Builder builder3 = rpcClassBuilder;
        TypeSpec.Builder builder4 = builder3 != null ? builder3.addProperty(PropertySpec.Companion.builder("rpc", Reflection.getOrCreateKotlinClass(EthereumRPC.class), new KModifier[0]).addModifiers(new KModifier[]{KModifier.PRIVATE}).initializer("rpc", new Object[0]).build()) : null;
        TypeSpec.Builder builder5 = rpcClassBuilder;
        TypeSpec.Builder builder6 = builder5 != null ? builder5.addProperty(PropertySpec.Companion.builder("address", Reflection.getOrCreateKotlinClass(Address.class), new KModifier[0]).addModifiers(new KModifier[]{KModifier.PRIVATE}).initializer("address", new Object[0]).build()) : null;
        MemberName createEmptyTX = new MemberName("org.kethereum.model", "createEmptyTransaction");
        MemberName encodeTypes = new MemberName("org.kethereum.contract.abi.types", "encodeTypes");
        PropertySpec tx = PropertySpec.Companion.builder("tx", Reflection.getOrCreateKotlinClass(Transaction.class), new KModifier[0]).addModifiers(new KModifier[]{KModifier.PRIVATE}).initializer("%M().apply { to = address }", new Object[]{createEmptyTX}).build();
        transactionsClassBuilder.addProperty(tx);
        ClassName generatorType = new ClassName(spec.getPackageName(), new String[]{spec.getClassPrefix() + "TransactionGenerator"});
        PropertySpec txGenerator = PropertySpec.Companion.builder("txGenerator", (TypeName)generatorType, new KModifier[0]).addModifiers(new KModifier[]{KModifier.PRIVATE}).initializer("%T(address)", new Object[]{generatorType}).build();
        TypeSpec.Builder builder7 = rpcClassBuilder;
        Object object = builder7 != null ? builder7.addProperty(txGenerator) : null;
        Iterable $this$forEach$iv = CreateModelKt.createModel(EthereumABIFilterKt.getAllFunctions((Iterable)$this$toKotlinCode.getMethodList()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv22;
            it = (Function)element$iv;
            boolean bl7 = false;
            FunSpec.Builder kotlinTypesFunBuilder = FunSpec.Companion.builder(it.getFunctionName());
            FunSpec.Builder ethTypeFunBuilder = FunSpec.Companion.builder(it.getEthTypesFunctionName()).addModifiers(new KModifier[]{KModifier.PRIVATE});
            FunSpec.Builder kotlinTxTypesFunBuilder = FunSpec.Companion.builder(it.getFunctionName());
            FunSpec.Builder ethTypeTxFunBuilder = FunSpec.Companion.builder(it.getEthTypesFunctionName()).addModifiers(new KModifier[]{KModifier.INTERNAL});
            kotlinTypesFunBuilder.addKdoc(it.getKDoc(), new Object[0]);
            kotlinTxTypesFunBuilder.addKdoc(it.getKDoc(), new Object[0]);
            Iterable $this$forEach$iv2 = it.getParams();
            boolean $i$f$forEach2 = false;
            for (Object element$iv22 : $this$forEach$iv2) {
                Params param = (Params)element$iv22;
                boolean bl8 = false;
                if (param.getTypeDefinition() != null) {
                    ethTypeFunBuilder.addParameter(param.getParameterName(), param.getTypeDefinition().getEthTypeKClass(), new KModifier[0]);
                    ethTypeTxFunBuilder.addParameter(param.getParameterName(), param.getTypeDefinition().getEthTypeKClass(), new KModifier[0]);
                    kotlinTypesFunBuilder.addParameter(param.getParameterName(), param.getTypeDefinition().getKotlinTypeKClass(), new KModifier[0]);
                    kotlinTxTypesFunBuilder.addParameter(param.getParameterName(), param.getTypeDefinition().getKotlinTypeKClass(), new KModifier[0]);
                    continue;
                }
                it.setSkipReason(it.getTextMethodSignature().getSignature() + " contains unsupported parameter type " + param.getType() + " for " + it.getFunctionName());
            }
            kotlinTypesFunBuilder.addParameter(ParameterSpec.Companion.builder("blockSpec", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).defaultValue("\"latest\"", new Object[0]).build());
            ethTypeFunBuilder.addParameter(ParameterSpec.Companion.builder("blockSpec", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).defaultValue("\"latest\"", new Object[0]).build());
            fileSpec.addProperty(PropertySpec.Companion.builder(it.getFourByteName(), Reflection.getOrCreateKotlinClass(byte[].class), new KModifier[0]).initializer(it.getSignatureCode(), new Object[0]).build());
            TypeSpec.Builder builder8 = transactionDetector;
            TypeSpec.Builder builder9 = builder8 != null ? builder8.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("is" + it.getMaybeExtendedFunctionName()).addParameter("tx", Reflection.getOrCreateKotlinClass(Transaction.class), new KModifier[0]).addStatement("return tx.input.sliceArray(0..3).contentEquals(" + it.getFourByteName() + ')', new Object[0]), (KClass)Reflection.getOrCreateKotlinClass(Boolean.TYPE), null, (int)2, null).build()) : null;
            ethTypeTxFunBuilder.addCode("return " + tx.getName() + ".copy(input = " + it.getFourByteName() + " + %M(" + CollectionsKt.joinToString$default((Iterable)it.getParams(), null, null, null, (int)0, null, (Function1)toKotlinCode.2.2.INSTANCE, (int)31, null) + "))", new Object[]{encodeTypes});
            ethTypeFunBuilder.addCode("val tx = " + txGenerator.getName() + '.' + it.getEthTypesFunctionName() + '(' + CollectionsKt.joinToString$default((Iterable)it.getParams(), null, null, null, (int)0, null, (Function1)toKotlinCode.2.3.INSTANCE, (int)31, null) + ")\n", new Object[0]);
            String rpcCall = "rpc.call(tx, blockSpec)";
            String ethTypeCallProto2 = it.getEthTypesFunctionName() + '(' + CollectionsKt.joinToString$default((Iterable)it.getParams(), null, null, null, (int)0, null, (Function1)toKotlinCode.2.ethTypeCallProto.1.INSTANCE, (int)31, null);
            element$iv22 = it.getParams();
            boolean param = false;
            String callTypeProtoWithBlockSpec = ethTypeCallProto2 + (!element$iv22.isEmpty() ? "," : "") + "blockSpec";
            FunSpec.Builder.returns$default((FunSpec.Builder)kotlinTxTypesFunBuilder, (KClass)Reflection.getOrCreateKotlinClass(Transaction.class), null, (int)2, null);
            KClass<? extends ETHType<?>>[] kClassArray = it.getEthTypeArray();
            kotlinTxTypesFunBuilder.addCode("return " + ethTypeCallProto2 + ")\n", (Object[])Arrays.copyOf(kClassArray, kClassArray.length));
            if (it.getOutputs().size() > 1) {
                it.setSkipReason(it.getTextMethodSignature().getSignature() + " has more than one output - which is currently not supported");
            } else if (it.getOutputs().size() == 1) {
                String type = ((Output)CollectionsKt.first(it.getOutputs())).getType();
                ContractABITypeDefinition typeDefinition = StringToTypeConverterKt.convertStringToABITypeOrNull((String)type);
                if (typeDefinition != null) {
                    FunSpec.Builder.returns$default((FunSpec.Builder)ethTypeFunBuilder, (TypeName)TypeName.copy$default((TypeName)((TypeName)TypeNames.get((KClass)typeDefinition.getEthTypeKClass())), (boolean)true, null, (int)2, null), null, (int)2, null);
                    FunSpec.Builder.returns$default((FunSpec.Builder)kotlinTypesFunBuilder, (TypeName)TypeName.copy$default((TypeName)((TypeName)TypeNames.get((KClass)typeDefinition.getKotlinTypeKClass())), (boolean)true, null, (int)2, null), null, (int)2, null);
                    ethTypeFunBuilder.addStatement("return %T.ofPaginatedByteArray(%T(" + rpcCall + ')' + UtilKt.toParamIfExist(typeDefinition.getParams()) + ')', new Object[]{typeDefinition.getEthTypeKClass(), Reflection.getOrCreateKotlinClass(PaginatedByteArray.class)});
                    KClass<? extends ETHType<?>>[] kClassArray2 = it.getEthTypeArray();
                    kotlinTypesFunBuilder.addCode("return " + callTypeProtoWithBlockSpec + ")?.toKotlinType()\n", (Object[])Arrays.copyOf(kClassArray2, kClassArray2.length));
                } else {
                    it.setSkipReason(it.getTextMethodSignature().getSignature() + " has unsupported returntype: " + type);
                }
            } else {
                ethTypeFunBuilder.addStatement(rpcCall, new Object[0]);
                KClass<? extends ETHType<?>>[] kClassArray3 = it.getEthTypeArray();
                kotlinTypesFunBuilder.addCode(callTypeProtoWithBlockSpec + ')', (Object[])Arrays.copyOf(kClassArray3, kClassArray3.length));
            }
            transactionsClassBuilder.addFunction(ethTypeTxFunBuilder.build());
            transactionsClassBuilder.addFunction(kotlinTxTypesFunBuilder.build());
            if (it.getSkipReason() != null) {
                TypeSpec.Builder builder10 = rpcClassBuilder;
                TypeSpec.Builder builder11 = builder10 != null ? builder10.addFunction(ethTypeFunBuilder.build()) : null;
                TypeSpec.Builder builder12 = rpcClassBuilder;
                TypeSpec.Builder builder13 = builder12 != null ? builder12.addFunction(kotlinTypesFunBuilder.build()) : null;
                continue;
            }
            TypeSpec.Builder builder14 = rpcClassBuilder;
            TypeSpec.Builder builder15 = builder14 != null ? builder14.addKdoc("\nskipped function " + it + ' ' + it.getSkipReason(), new Object[0]) : null;
        }
        fileSpec.addImport("org.kethereum.contract.abi.types.model.type_params", new String[]{"BytesTypeParams", "BitsTypeParams"});
        $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)allClasses);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TypeSpec.Builder)element$iv;
            boolean bl9 = false;
            fileSpec.addType(it.build());
        }
        return fileSpec.build();
    }
}

