/*
 * Decompiled with CFR 0.152.
 */
package org.komputing.khash.keccak;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.komputing.khash.keccak.KeccakParameter;
import org.komputing.khash.keccak.extensions.IntArrayExtensionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J!\u0010\u0015\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00170\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/komputing/khash/keccak/Keccak;", "", "()V", "BIT_65", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "MAX_64_BITS", "convertFrom64ToLittleEndian", "", "uLong", "convertFromLittleEndianTo64", "data", "convertToUInt", "", "digest", "value", "parameter", "Lorg/komputing/khash/keccak/KeccakParameter;", "doF", "", "uState", "roundB", "state", "", "([[Ljava/math/BigInteger;)V", "leftRotate64", "rotate", "", "leftRotate64Safely", "keccak"})
public final class Keccak {
    private static final BigInteger BIT_65;
    private static final BigInteger MAX_64_BITS;
    public static final Keccak INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] digest(@NotNull byte[] value, @NotNull KeccakParameter parameter) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)((Object)parameter), (String)"parameter");
        int[] uState = new int[200];
        int[] uMessage = this.convertToUInt(value);
        int blockSize = 0;
        for (int inputOffset = 0; inputOffset < uMessage.length; inputOffset += blockSize) {
            int n3 = uMessage.length - inputOffset;
            n2 = parameter.getRateInBytes();
            n = 0;
            blockSize = Math.min(n3, n2);
            n3 = 0;
            n2 = blockSize;
            while (n3 < n2) {
                void i;
                uState[i] = uState[i] ^ uMessage[i + inputOffset];
                ++i;
            }
            if (blockSize != parameter.getRateInBytes()) continue;
            this.doF(uState);
            blockSize = 0;
        }
        uState[blockSize] = uState[blockSize] ^ parameter.getD();
        if ((parameter.getD() & 0x80) != 0 && blockSize == parameter.getRateInBytes() - 1) {
            this.doF(uState);
        }
        uState[parameter.getRateInBytes() - 1] = uState[parameter.getRateInBytes() - 1] ^ 0x80;
        this.doF(uState);
        n2 = 0;
        List byteResults = new ArrayList();
        int tOutputLen = parameter.getOutputLengthInBytes();
        while (tOutputLen > 0) {
            n = parameter.getRateInBytes();
            int n4 = 0;
            blockSize = Math.min(tOutputLen, n);
            n = 0;
            n4 = blockSize;
            while (n < n4) {
                void i;
                byteResults.add((byte)uState[i]);
                ++i;
            }
            if ((tOutputLen -= blockSize) <= 0) continue;
            this.doF(uState);
        }
        return CollectionsKt.toByteArray((Collection)byteResults);
    }

    private final void doF(int[] uState) {
        int j;
        int i;
        int n;
        int n2;
        int n3 = 5;
        BigInteger[][] bigIntegerArrayArray = new BigInteger[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            n = n2;
            int n4 = n2;
            BigInteger[][] bigIntegerArrayArray2 = bigIntegerArrayArray;
            boolean bl = false;
            int n5 = 5;
            BigInteger[] bigIntegerArray = new BigInteger[n5];
            int n6 = 0;
            while (n6 < n5) {
                BigInteger bigInteger;
                int n7 = n6;
                int n8 = n6++;
                BigInteger[] bigIntegerArray2 = bigIntegerArray;
                boolean bl2 = false;
                bigIntegerArray2[n8] = bigInteger = BigInteger.ZERO;
            }
            BigInteger[] bigIntegerArray3 = bigIntegerArray;
            bigIntegerArrayArray2[n4] = bigIntegerArray3;
        }
        BigInteger[][] lState = bigIntegerArrayArray;
        n3 = 0;
        int n9 = 4;
        while (n3 <= n9) {
            n2 = 0;
            n = 4;
            while (n2 <= n) {
                int[] data = new int[8];
                int index = 8 * (i + 5 * j);
                ArraysKt.copyInto((int[])uState, (int[])data, (int)0, (int)index, (int)(index + data.length));
                lState[i][j] = this.convertFromLittleEndianTo64(data);
                ++j;
            }
            ++i;
        }
        this.roundB(lState);
        IntArrayExtensionsKt.fillWith$default(uState, 0, 0, 0, 6, null);
        n9 = 4;
        for (i = 0; i <= n9; ++i) {
            n = 4;
            for (j = 0; j <= n; ++j) {
                BigInteger bigInteger = lState[i][j];
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"lState[i][j]");
                int[] data = this.convertFrom64ToLittleEndian(bigInteger);
                ArraysKt.copyInto$default((int[])data, (int[])uState, (int)(8 * (i + 5 * j)), (int)0, (int)0, (int)12, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void roundB(BigInteger[][] state) {
        int lfsrState = 1;
        int n = 0;
        int n2 = 23;
        while (n <= n2) {
            void round;
            int j;
            int i;
            int n3;
            int i2;
            BigInteger[] c = new BigInteger[5];
            BigInteger[] d = new BigInteger[5];
            int n4 = 0;
            int n5 = 4;
            while (n4 <= n5) {
                c[i2] = state[i2][0].xor(state[i2][1]).xor(state[i2][2]).xor(state[i2][3]).xor(state[i2][4]);
                ++i2;
            }
            n5 = 4;
            for (i2 = 0; i2 <= n5; ++i2) {
                BigInteger bigInteger = c[(i2 + 4) % 5];
                if (bigInteger == null) {
                    Intrinsics.throwNpe();
                }
                BigInteger bigInteger2 = c[(i2 + 1) % 5];
                if (bigInteger2 == null) {
                    Intrinsics.throwNpe();
                }
                d[i2] = bigInteger.xor(this.leftRotate64(bigInteger2, 1));
            }
            n5 = 4;
            for (i2 = 0; i2 <= n5; ++i2) {
                int n6 = 0;
                n3 = 4;
                while (n6 <= n3) {
                    void j2;
                    BigInteger[] bigIntegerArray = state[i2];
                    BigInteger bigInteger = state[i2][j2];
                    BigInteger bigInteger3 = d[i2];
                    if (bigInteger3 == null) {
                        Intrinsics.throwNpe();
                    }
                    BigInteger bigInteger4 = bigInteger.xor(bigInteger3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger4, (String)"state[i][j].xor(d[i]!!)");
                    bigIntegerArray[j2] = bigInteger4;
                    ++j2;
                }
            }
            int x = 1;
            int y = 0;
            BigInteger current = state[x][y];
            n3 = 0;
            int n7 = 23;
            while (n3 <= n7) {
                int tX = x;
                x = y;
                y = (2 * tX + 3 * y) % 5;
                BigInteger shiftValue = current;
                current = state[x][y];
                BigInteger[] bigIntegerArray = state[x];
                BigInteger bigInteger = this.leftRotate64Safely(shiftValue, (i + 1) * (i + 2) / 2);
                Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"shiftValue.leftRotate64S\u2026ly((i + 1) * (i + 2) / 2)");
                bigIntegerArray[y] = bigInteger;
                ++i;
            }
            i = 0;
            n7 = 4;
            while (i <= n7) {
                int i3;
                BigInteger[] t = new BigInteger[5];
                int shiftValue = 0;
                int n8 = 4;
                while (shiftValue <= n8) {
                    t[i3] = state[i3][j];
                    ++i3;
                }
                n8 = 4;
                for (i3 = 0; i3 <= n8; ++i3) {
                    BigInteger bigInteger = t[(i3 + 1) % 5];
                    if (bigInteger == null) {
                        Intrinsics.throwNpe();
                    }
                    BigInteger invertVal = bigInteger.xor(MAX_64_BITS);
                    BigInteger[] bigIntegerArray = state[i3];
                    BigInteger bigInteger5 = t[i3];
                    if (bigInteger5 == null) {
                        Intrinsics.throwNpe();
                    }
                    BigInteger bigInteger6 = t[(i3 + 2) % 5];
                    if (bigInteger6 == null) {
                        Intrinsics.throwNpe();
                    }
                    BigInteger bigInteger7 = bigInteger5.xor(invertVal.and(bigInteger6));
                    Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger7, (String)"t[i]!!.xor(invertVal.and(t[(i + 2) % 5]!!))");
                    bigIntegerArray[j] = bigInteger7;
                }
                ++j;
            }
            j = 0;
            n7 = 6;
            while (j <= n7) {
                lfsrState = (lfsrState << 1 ^ (lfsrState >> 7) * 113) % 256;
                int bitPosition = (1 << i) - 1;
                if ((lfsrState & 2) != 0) {
                    BigInteger[] bigIntegerArray = state[0];
                    BigInteger bigInteger = state[0][0].xor(BigInteger.ONE.shiftLeft(bitPosition));
                    Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"state[0][0].xor(BigInteg\u2026E.shiftLeft(bitPosition))");
                    bigIntegerArray[0] = bigInteger;
                }
                ++i;
            }
            ++round;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int[] convertToUInt(byte[] data) {
        int n = data.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            nArray2[n5] = n3 = data[it] & 0xFF;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private final BigInteger convertFromLittleEndianTo64(int[] data) {
        String string;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = data;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_13 = item$iv$iv = iterator[i];
            collection = destination$iv$iv;
            boolean bl = false;
            void var14_15 = it;
            int n2 = 16;
            boolean bl2 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)Integer.toString((int)var14_15, CharsKt.checkRadix((int)n2)), (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it.length() == 2 ? it : '0' + (String)it;
            collection.add(string);
        }
        String value = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)((List)destination$iv$iv)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        return new BigInteger(value, 16);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] convertFrom64ToLittleEndian(BigInteger uLong) {
        String asHex = uLong.toString(16);
        String asHexPadded = StringsKt.repeat((CharSequence)"0", (int)(16 - asHex.length())) + asHex;
        int n = 8;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            void it;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            int n6 = (7 - it) * 2;
            boolean bl2 = false;
            boolean bl3 = false;
            int pos = n6;
            boolean bl4 = false;
            String string = asHexPadded;
            int n7 = pos + 2;
            boolean bl5 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(pos, n7);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n7 = 16;
            bl5 = false;
            nArray2[n5] = n3 = Integer.parseInt(string, CharsKt.checkRadix((int)n7));
        }
        return nArray;
    }

    private final BigInteger leftRotate64Safely(@NotNull BigInteger $this$leftRotate64Safely, int rotate) {
        return this.leftRotate64($this$leftRotate64Safely, rotate % 64);
    }

    private final BigInteger leftRotate64(@NotNull BigInteger $this$leftRotate64, int rotate) {
        return $this$leftRotate64.shiftRight(64 - rotate).add($this$leftRotate64.shiftLeft(rotate)).mod(BIT_65);
    }

    private Keccak() {
    }

    static {
        Keccak keccak;
        INSTANCE = keccak = new Keccak();
        BIT_65 = BigInteger.ONE.shiftLeft(64);
        MAX_64_BITS = BIT_65.subtract(BigInteger.ONE);
    }
}

