/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader;

import android.content.Context;
import android.os.AsyncTask;
import com.krishna.fileloader.listener.MultiFileDownloadListener;
import com.krishna.fileloader.network.FileDownloader;

public class FileDownloadTask
extends AsyncTask<String, Integer, Void> {
    private MultiFileDownloadListener listener;
    private String dirName;
    private int dirType;
    private Context context;
    private int totalTasks = 0;
    private int progress = 0;

    public FileDownloadTask(Context context, String dirName, int dirType, MultiFileDownloadListener listener) {
        this.dirName = dirName;
        this.dirType = dirType;
        this.context = context;
        this.listener = listener;
    }

    protected Void doInBackground(String ... urls) {
        this.totalTasks = urls.length;
        for (String url : urls) {
            try {
                FileDownloader downloader = new FileDownloader(this.context, url, this.dirName, this.dirType);
                downloader.download();
                this.publishProgress(new Integer[]{++this.progress});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.listener != null) {
            this.listener.onProgress(values[0], this.totalTasks);
        }
    }
}

