/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.builder;

import android.content.Context;
import android.support.annotation.NonNull;
import com.krishna.fileloader.FileLoader;
import com.krishna.fileloader.request.FileDeleteRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileDeleteBuilder {
    private ArrayList<String> fileUriList;
    private String directoryName = "file_loader";
    private int directoryType = 2;
    private Context context;
    private FileLoader fileLoader;

    public FileDeleteBuilder(Context context) {
        this.context = context.getApplicationContext();
    }

    public FileDeleteBuilder fromDirectory(String directoryName, @FileLoader.DirectoryType int directoryType) {
        this.directoryName = directoryName;
        this.directoryType = directoryType;
        return this;
    }

    public int deleteFiles(String ... fileUris) throws Exception {
        this.fileUriList = new ArrayList();
        this.fileUriList.addAll(Arrays.asList(fileUris));
        this.fileLoader = this.buildFileLoader();
        return this.fileLoader.deleteFiles();
    }

    @NonNull
    private FileLoader buildFileLoader() {
        FileDeleteRequest deleteRequest = new FileDeleteRequest(this.fileUriList, this.directoryName, this.directoryType);
        FileLoader fileLoader = new FileLoader(this.context);
        fileLoader.setFileDeleteRequest(deleteRequest);
        return fileLoader;
    }

    public int deleteFiles(ArrayList<String> fileUriList) throws Exception {
        return this.deleteFiles((String[])fileUriList.toArray());
    }

    public int deleteAllFiles() throws Exception {
        this.fileLoader = this.buildFileLoader();
        return this.fileLoader.deleteAllFiles();
    }

    public int deleteAllFilesExcept(String ... fileUris) throws Exception {
        this.fileUriList = new ArrayList();
        for (String fileUri : fileUris) {
            this.fileUriList.add(fileUri);
        }
        this.fileLoader = this.buildFileLoader();
        return this.fileLoader.deleteAllFilesExcept();
    }

    public int deleteAllFilesExcept(List<String> fileUriList) throws Exception {
        return this.deleteAllFilesExcept((String[])fileUriList.toArray());
    }
}

