/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader;

import android.content.Context;
import android.os.AsyncTask;
import com.krishna.fileloader.listener.MultiFileDownloadListener;
import com.krishna.fileloader.network.FileDownloader;
import com.krishna.fileloader.request.MultiFileLoadRequest;
import com.krishna.fileloader.utility.AndroidFileManager;
import java.io.File;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;

public class MultiFileDownloadTask
extends AsyncTask<MultiFileLoadRequest, Integer, Void> {
    private MultiFileDownloadListener listener;
    private Context context;
    private int totalTasks = 0;
    private int progress = 0;
    private List<File> downloadedFiles;

    public MultiFileDownloadTask(Context context, MultiFileDownloadListener listener) {
        this.context = context.getApplicationContext();
        this.listener = listener;
        this.downloadedFiles = new ArrayList<File>();
    }

    protected Void doInBackground(MultiFileLoadRequest ... requests) {
        this.totalTasks = requests.length;
        for (MultiFileLoadRequest loadRequest : requests) {
            try {
                File tempFile;
                File downloadedFile = AndroidFileManager.searchAndGetLocalFile(this.context, loadRequest.getUri(), loadRequest.getFileNamePrefix(), loadRequest.getDirectoryName(), loadRequest.getDirectoryType());
                FileDownloader downloader = new FileDownloader(this.context, loadRequest.getUri(), loadRequest.getFileNamePrefix(), loadRequest.getDirectoryName(), loadRequest.getDirectoryType());
                if (loadRequest.isForceLoadFromNetwork() || downloadedFile == null || !downloadedFile.exists()) {
                    downloadedFile = downloader.download(false, loadRequest.isCheckIntegrity());
                } else if (loadRequest.isAutoRefresh() && (tempFile = downloader.download(true, loadRequest.isCheckIntegrity())) != null) {
                    downloadedFile = tempFile;
                }
                this.downloadedFiles.add(downloadedFile);
                this.publishProgress(new Integer[]{++this.progress});
            }
            catch (InterruptedIOException e) {
                this.sendErrorToListener(e, ++this.progress);
            }
            catch (Exception e) {
                this.sendErrorToListener(e, ++this.progress);
            }
        }
        return null;
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.listener != null) {
            try {
                this.listener.onProgress(this.downloadedFiles.get(values[0] - 1), values[0], this.totalTasks);
            }
            catch (Exception e) {
                this.sendErrorToListener(e, values[0]);
            }
        }
    }

    private void sendErrorToListener(Exception e, int progress) {
        try {
            this.listener.onError(e, progress);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

