/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.builder;

import android.content.Context;
import com.krishna.fileloader.FileLoader;
import com.krishna.fileloader.MultiFileDownloadTask;
import com.krishna.fileloader.listener.MultiFileDownloadListener;
import com.krishna.fileloader.utility.Utils;

public class MultiFileDownloader {
    private Context context;
    private String directoryName = "file_loader";
    private int directoryType = 1;
    private MultiFileDownloadListener listener;
    private boolean forceLoadFromNetwork;

    public MultiFileDownloader(Context context) {
        this.context = context;
    }

    public MultiFileDownloader fromDirectory(String directoryName, @FileLoader.DirectoryType int directoryType) {
        this.directoryName = directoryName;
        this.directoryType = directoryType;
        return this;
    }

    public MultiFileDownloader progressListener(MultiFileDownloadListener listener) {
        this.listener = listener;
        return this;
    }

    public void loadMultiple(String ... uris) {
        new MultiFileDownloadTask(this.context, this.directoryName, this.directoryType, this.listener, this.forceLoadFromNetwork).executeOnExecutor(Utils.getThreadPoolExecutor(), uris);
    }

    public void loadMultiple(boolean forceLoadFromNetwork, String ... uris) {
        this.forceLoadFromNetwork = forceLoadFromNetwork;
        this.loadMultiple(uris);
    }
}

