/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendarview.ui;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.core.view.MarginLayoutParamsCompat;
import com.kizitonwose.calendarview.model.CalendarDay;
import com.kizitonwose.calendarview.ui.DayBinder;
import com.kizitonwose.calendarview.ui.DayConfig;
import com.kizitonwose.calendarview.ui.ViewContainer;
import com.kizitonwose.calendarview.utils.ExtensionsKt;
import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/kizitonwose/calendarview/ui/DayHolder;", "", "config", "Lcom/kizitonwose/calendarview/ui/DayConfig;", "(Lcom/kizitonwose/calendarview/ui/DayConfig;)V", "dateView", "Landroid/view/View;", "day", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "viewContainer", "Lcom/kizitonwose/calendarview/ui/ViewContainer;", "bindDayView", "", "currentDay", "inflateDayView", "parent", "Landroid/widget/LinearLayout;", "reloadViewIfNecessary", "", "com.github.kizitonwose.CalendarView"})
public final class DayHolder {
    @NotNull
    private final DayConfig config;
    private View dateView;
    private ViewContainer viewContainer;
    @Nullable
    private CalendarDay day;

    public DayHolder(@NotNull DayConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final View inflateDayView(@NotNull LinearLayout parent) {
        void $this$inflateDayView_u24lambda_u2d1;
        View view;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view2 = view = ExtensionsKt.inflate$default((ViewGroup)parent, this.config.getDayViewRes(), false, 2, null);
        DayHolder dayHolder = this;
        boolean bl = false;
        void $this$updateLayoutParams$iv = $this$inflateDayView_u24lambda_u2d1;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((LinearLayout.LayoutParams)layoutParams);
        LinearLayout.LayoutParams $this$inflateDayView_u24lambda_u2d1_u24lambda_u2d0 = (LinearLayout.LayoutParams)params$iv;
        boolean bl2 = false;
        $this$inflateDayView_u24lambda_u2d1_u24lambda_u2d0.width = this.config.getSize().getWidth() - MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)$this$inflateDayView_u24lambda_u2d1_u24lambda_u2d0)) - MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)((ViewGroup.MarginLayoutParams)$this$inflateDayView_u24lambda_u2d1_u24lambda_u2d0));
        void $this$marginTop$iv = $this$inflateDayView_u24lambda_u2d1;
        boolean $i$f$getMarginTop = false;
        ViewGroup.LayoutParams layoutParams2 = $this$marginTop$iv.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = layoutParams2 instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams2 : null;
        void $this$marginBottom$iv = $this$inflateDayView_u24lambda_u2d1;
        boolean $i$f$getMarginBottom = false;
        layoutParams2 = $this$marginBottom$iv.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams2 = layoutParams2 instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)layoutParams2 : null;
        $this$inflateDayView_u24lambda_u2d1_u24lambda_u2d0.height = this.config.getSize().getHeight() - (marginLayoutParams != null ? marginLayoutParams.topMargin : 0) - (marginLayoutParams2 != null ? marginLayoutParams2.bottomMargin : 0);
        $this$inflateDayView_u24lambda_u2d1_u24lambda_u2d0.weight = 1.0f;
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        dayHolder.dateView = view;
        View view3 = this.dateView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateView");
            view3 = null;
        }
        return view3;
    }

    public final void bindDayView(@Nullable CalendarDay currentDay) {
        this.day = currentDay;
        if (this.viewContainer == null) {
            DayBinder<ViewContainer> dayBinder = this.config.getViewBinder();
            View view = this.dateView;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dateView");
                view = null;
            }
            this.viewContainer = dayBinder.create(view);
        }
        CalendarDay calendarDay = currentDay;
        LocalDate localDate = calendarDay != null ? calendarDay.getDate() : null;
        int dayHash = localDate != null ? ((Object)localDate).hashCode() : 0;
        ViewContainer viewContainer = this.viewContainer;
        if (viewContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewContainer");
            viewContainer = null;
        }
        if (!Intrinsics.areEqual((Object)viewContainer.getView().getTag(), (Object)dayHash)) {
            ViewContainer viewContainer2 = this.viewContainer;
            if (viewContainer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewContainer");
                viewContainer2 = null;
            }
            viewContainer2.getView().setTag((Object)dayHash);
        }
        if (currentDay != null) {
            ViewContainer viewContainer3 = this.viewContainer;
            if (viewContainer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewContainer");
                viewContainer3 = null;
            }
            View $this$isVisible$iv = viewContainer3.getView();
            boolean $i$f$isVisible = false;
            if (!($this$isVisible$iv.getVisibility() == 0)) {
                ViewContainer viewContainer4 = this.viewContainer;
                if (viewContainer4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewContainer");
                    viewContainer4 = null;
                }
                $this$isVisible$iv = viewContainer4.getView();
                boolean value$iv = true;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
            }
            DayBinder<ViewContainer> dayBinder = this.config.getViewBinder();
            ViewContainer viewContainer5 = this.viewContainer;
            if (viewContainer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewContainer");
                viewContainer5 = null;
            }
            dayBinder.bind(viewContainer5, currentDay);
        } else {
            ViewContainer viewContainer6 = this.viewContainer;
            if (viewContainer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewContainer");
                viewContainer6 = null;
            }
            View $this$isGone$iv = viewContainer6.getView();
            boolean $i$f$isGone = false;
            if (!($this$isGone$iv.getVisibility() == 8)) {
                ViewContainer viewContainer7 = this.viewContainer;
                if (viewContainer7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewContainer");
                    viewContainer7 = null;
                }
                $this$isGone$iv = viewContainer7.getView();
                boolean value$iv = true;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(8);
            }
        }
    }

    public final boolean reloadViewIfNecessary(@NotNull CalendarDay day) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        if (Intrinsics.areEqual((Object)day, (Object)this.day)) {
            this.bindDayView(this.day);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

