/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendarview.ui;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendarview.CalendarView;
import com.kizitonwose.calendarview.model.CalendarDay;
import com.kizitonwose.calendarview.model.ScrollMode;
import com.kizitonwose.calendarview.ui.CalendarAdapter;
import com.kizitonwose.calendarview.ui.MonthViewHolder;
import java.time.YearMonth;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "Landroidx/recyclerview/widget/LinearLayoutManager;", "calView", "Lcom/kizitonwose/calendarview/CalendarView;", "orientation", "", "(Lcom/kizitonwose/calendarview/CalendarView;I)V", "adapter", "Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "getAdapter", "()Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "calculateDayViewOffsetInParent", "day", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "itemView", "Landroid/view/View;", "scrollToDay", "", "scrollToMonth", "month", "Ljava/time/YearMonth;", "smoothScrollToDay", "smoothScrollToMonth", "CalendarSmoothScroller", "com.github.kizitonwose.CalendarView"})
public final class CalendarLayoutManager
extends LinearLayoutManager {
    @NotNull
    private final CalendarView calView;

    public CalendarLayoutManager(@NotNull CalendarView calView, int orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)calView), (String)"calView");
        super(calView.getContext(), orientation, false);
        this.calView = calView;
    }

    private final CalendarAdapter getAdapter() {
        RecyclerView.Adapter adapter = this.calView.getAdapter();
        Intrinsics.checkNotNull((Object)adapter, (String)"null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarAdapter");
        return (CalendarAdapter)adapter;
    }

    private final Context getContext() {
        Context context = this.calView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"calView.context");
        return context;
    }

    public final void scrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        int position = this.getAdapter().getAdapterPosition$com_github_kizitonwose_CalendarView(month);
        if (position == -1) {
            return;
        }
        this.scrollToPositionWithOffset(position, 0);
        this.calView.post(() -> CalendarLayoutManager.scrollToMonth$lambda-0(this));
    }

    public final void smoothScrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        int position = this.getAdapter().getAdapterPosition$com_github_kizitonwose_CalendarView(month);
        if (position == -1) {
            return;
        }
        this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(position, null));
    }

    public final void smoothScrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        int monthPosition = this.getAdapter().getAdapterPosition$com_github_kizitonwose_CalendarView(day);
        if (monthPosition == -1) {
            return;
        }
        boolean isPaged = this.calView.getScrollMode() == ScrollMode.PAGED;
        this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(monthPosition, isPaged ? null : day));
    }

    public final void scrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        int monthPosition = this.getAdapter().getAdapterPosition$com_github_kizitonwose_CalendarView(day);
        if (monthPosition == -1) {
            return;
        }
        this.scrollToPositionWithOffset(monthPosition, 0);
        if (this.calView.getScrollMode() == ScrollMode.PAGED) {
            this.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda-1(this));
        } else {
            this.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda-3(this, monthPosition, day));
        }
    }

    private final int calculateDayViewOffsetInParent(CalendarDay day, View itemView) {
        View view = itemView.findViewWithTag((Object)day.getDate().hashCode());
        if (view == null) {
            return 0;
        }
        View dayView = view;
        Rect rect = new Rect();
        dayView.getDrawingRect(rect);
        Intrinsics.checkNotNull((Object)itemView, (String)"null cannot be cast to non-null type android.view.ViewGroup");
        ((ViewGroup)itemView).offsetDescendantRectToMyCoords(dayView, rect);
        return this.calView.isVertical$com_github_kizitonwose_CalendarView() ? rect.top + this.calView.getMonthMarginTop() : rect.left + this.calView.getMonthMarginStart();
    }

    private static final void scrollToMonth$lambda-0(CalendarLayoutManager this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getAdapter().notifyMonthScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda-1(CalendarLayoutManager this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getAdapter().notifyMonthScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda-3$lambda-2(CalendarLayoutManager this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getAdapter().notifyMonthScrollListenerIfNeeded();
    }

    private static final void scrollToDay$lambda-3(CalendarLayoutManager this$0, int $monthPosition, CalendarDay $day) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$day, (String)"$day");
        RecyclerView.ViewHolder viewHolder = this$0.calView.findViewHolderForAdapterPosition($monthPosition);
        MonthViewHolder monthViewHolder = viewHolder instanceof MonthViewHolder ? (MonthViewHolder)viewHolder : null;
        if (monthViewHolder == null) {
            return;
        }
        MonthViewHolder viewHolder2 = monthViewHolder;
        View view = viewHolder2.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewHolder.itemView");
        int offset = this$0.calculateDayViewOffsetInParent($day, view);
        this$0.scrollToPositionWithOffset($monthPosition, -offset);
        this$0.calView.post(() -> CalendarLayoutManager.scrollToDay$lambda-3$lambda-2(this$0));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0014J\b\u0010\u000f\u001a\u00020\u0003H\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager$CalendarSmoothScroller;", "Landroidx/recyclerview/widget/LinearSmoothScroller;", "position", "", "day", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "(Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;ILcom/kizitonwose/calendarview/model/CalendarDay;)V", "getDay", "()Lcom/kizitonwose/calendarview/model/CalendarDay;", "calculateDxToMakeVisible", "view", "Landroid/view/View;", "snapPreference", "calculateDyToMakeVisible", "getHorizontalSnapPreference", "getVerticalSnapPreference", "com.github.kizitonwose.CalendarView"})
    private final class CalendarSmoothScroller
    extends LinearSmoothScroller {
        @Nullable
        private final CalendarDay day;

        public CalendarSmoothScroller(@Nullable int position, CalendarDay day) {
            super(CalendarLayoutManager.this.getContext());
            this.day = day;
            this.setTargetPosition(position);
        }

        @Nullable
        public final CalendarDay getDay() {
            return this.day;
        }

        protected int getVerticalSnapPreference() {
            return -1;
        }

        protected int getHorizontalSnapPreference() {
            return -1;
        }

        public int calculateDyToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dy = super.calculateDyToMakeVisible(view, snapPreference);
            if (this.day == null) {
                return dy;
            }
            int offset = CalendarLayoutManager.this.calculateDayViewOffsetInParent(this.day, view);
            return dy - offset;
        }

        public int calculateDxToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int dx = super.calculateDxToMakeVisible(view, snapPreference);
            if (this.day == null) {
                return dx;
            }
            int offset = CalendarLayoutManager.this.calculateDayViewOffsetInParent(this.day, view);
            return dx - offset;
        }
    }
}

