/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendarview.ui;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendarview.CalendarView;
import com.kizitonwose.calendarview.model.CalendarDay;
import com.kizitonwose.calendarview.model.CalendarMonth;
import com.kizitonwose.calendarview.model.DayOwner;
import com.kizitonwose.calendarview.model.MonthConfig;
import com.kizitonwose.calendarview.model.ScrollMode;
import com.kizitonwose.calendarview.ui.CalendarLayoutManager;
import com.kizitonwose.calendarview.ui.DayBinder;
import com.kizitonwose.calendarview.ui.DayConfig;
import com.kizitonwose.calendarview.ui.DayHolder;
import com.kizitonwose.calendarview.ui.MonthViewHolder;
import com.kizitonwose.calendarview.ui.ViewConfig;
import com.kizitonwose.calendarview.ui.ViewContainer;
import com.kizitonwose.calendarview.ui.WeekHolder;
import com.kizitonwose.calendarview.utils.ExtensionsKt;
import com.kizitonwose.calendarview.utils.Size;
import java.lang.reflect.Constructor;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\"2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u0004\u0018\u000100J\b\u00101\u001a\u0004\u0018\u00010#J\b\u00102\u001a\u00020\u000eH\u0002J\b\u00103\u001a\u0004\u0018\u000100J\b\u00104\u001a\u0004\u0018\u00010#J\b\u00105\u001a\u00020\u000eH\u0002J\u0012\u00106\u001a\u0004\u0018\u0001002\u0006\u00107\u001a\u00020\u000bH\u0002J\u0010\u00108\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000bH\u0002J\u0015\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u000200H\u0000\u00a2\u0006\u0002\b;J\u0015\u00109\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b;J\u0015\u00109\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b;J\u0010\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u00020\u000eH\u0002J\b\u0010B\u001a\u00020\u000eH\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010A\u001a\u00020\u000eH\u0016J\u0006\u0010E\u001a\u00020FJ\u0010\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020IH\u0016J\u0018\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020\u00022\u0006\u0010A\u001a\u00020\u000eH\u0016J&\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020\u00022\u0006\u0010A\u001a\u00020\u000e2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\"H\u0016J\u0018\u0010N\u001a\u00020\u00022\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u000eH\u0016J\u0006\u0010R\u001a\u00020FJ\u000e\u0010S\u001a\u00020F2\u0006\u0010:\u001a\u000200J\u000e\u0010T\u001a\u00020F2\u0006\u0010>\u001a\u00020?R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/kizitonwose/calendarview/ui/MonthViewHolder;", "calView", "Lcom/kizitonwose/calendarview/CalendarView;", "viewConfig", "Lcom/kizitonwose/calendarview/ui/ViewConfig;", "monthConfig", "Lcom/kizitonwose/calendarview/model/MonthConfig;", "(Lcom/kizitonwose/calendarview/CalendarView;Lcom/kizitonwose/calendarview/ui/ViewConfig;Lcom/kizitonwose/calendarview/model/MonthConfig;)V", "calWrapsHeight", "", "Ljava/lang/Boolean;", "footerViewId", "", "getFooterViewId", "()I", "setFooterViewId", "(I)V", "headerViewId", "getHeaderViewId", "setHeaderViewId", "initialLayout", "isAttached", "()Z", "layoutManager", "Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "getLayoutManager", "()Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "getMonthConfig$com_github_kizitonwose_CalendarView", "()Lcom/kizitonwose/calendarview/model/MonthConfig;", "setMonthConfig$com_github_kizitonwose_CalendarView", "(Lcom/kizitonwose/calendarview/model/MonthConfig;)V", "months", "", "Lcom/kizitonwose/calendarview/model/CalendarMonth;", "getMonths", "()Ljava/util/List;", "getViewConfig$com_github_kizitonwose_CalendarView", "()Lcom/kizitonwose/calendarview/ui/ViewConfig;", "setViewConfig$com_github_kizitonwose_CalendarView", "(Lcom/kizitonwose/calendarview/ui/ViewConfig;)V", "visibleMonth", "createDayHolders", "Lcom/kizitonwose/calendarview/ui/DayHolder;", "dayConfig", "Lcom/kizitonwose/calendarview/ui/DayConfig;", "findFirstVisibleDay", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "findFirstVisibleMonth", "findFirstVisibleMonthPosition", "findLastVisibleDay", "findLastVisibleMonth", "findLastVisibleMonthPosition", "findVisibleDay", "isFirst", "findVisibleMonthPosition", "getAdapterPosition", "day", "getAdapterPosition$com_github_kizitonwose_CalendarView", "date", "Ljava/time/LocalDate;", "month", "Ljava/time/YearMonth;", "getItem", "position", "getItemCount", "getItemId", "", "notifyMonthScrollListenerIfNeeded", "", "onAttachedToRecyclerView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onBindViewHolder", "holder", "payloads", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "reloadCalendar", "reloadDay", "reloadMonth", "com.github.kizitonwose.CalendarView"})
public final class CalendarAdapter
extends RecyclerView.Adapter<MonthViewHolder> {
    @NotNull
    private final CalendarView calView;
    @NotNull
    private ViewConfig viewConfig;
    @NotNull
    private MonthConfig monthConfig;
    private int headerViewId;
    private int footerViewId;
    @Nullable
    private CalendarMonth visibleMonth;
    @Nullable
    private Boolean calWrapsHeight;
    private boolean initialLayout;

    public CalendarAdapter(@NotNull CalendarView calView, @NotNull ViewConfig viewConfig, @NotNull MonthConfig monthConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)calView), (String)"calView");
        Intrinsics.checkNotNullParameter((Object)viewConfig, (String)"viewConfig");
        Intrinsics.checkNotNullParameter((Object)monthConfig, (String)"monthConfig");
        this.calView = calView;
        this.viewConfig = viewConfig;
        this.monthConfig = monthConfig;
        this.headerViewId = ViewCompat.generateViewId();
        this.footerViewId = ViewCompat.generateViewId();
        this.setHasStableIds(true);
        this.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                initialLayout = true;
            }
        });
        this.initialLayout = true;
    }

    @NotNull
    public final ViewConfig getViewConfig$com_github_kizitonwose_CalendarView() {
        return this.viewConfig;
    }

    public final void setViewConfig$com_github_kizitonwose_CalendarView(@NotNull ViewConfig viewConfig) {
        Intrinsics.checkNotNullParameter((Object)viewConfig, (String)"<set-?>");
        this.viewConfig = viewConfig;
    }

    @NotNull
    public final MonthConfig getMonthConfig$com_github_kizitonwose_CalendarView() {
        return this.monthConfig;
    }

    public final void setMonthConfig$com_github_kizitonwose_CalendarView(@NotNull MonthConfig monthConfig) {
        Intrinsics.checkNotNullParameter((Object)monthConfig, (String)"<set-?>");
        this.monthConfig = monthConfig;
    }

    private final List<CalendarMonth> getMonths() {
        return this.monthConfig.getMonths$com_github_kizitonwose_CalendarView();
    }

    public final int getHeaderViewId() {
        return this.headerViewId;
    }

    public final void setHeaderViewId(int n) {
        this.headerViewId = n;
    }

    public final int getFooterViewId() {
        return this.footerViewId;
    }

    public final void setFooterViewId(int n) {
        this.footerViewId = n;
    }

    private final boolean isAttached() {
        return this.calView.getAdapter() == this;
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.calView.post(() -> CalendarAdapter.onAttachedToRecyclerView$lambda-0(this));
    }

    private final CalendarMonth getItem(int position) {
        return this.getMonths().get(position);
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public int getItemCount() {
        return this.getMonths().size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MonthViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Object object;
        void $this$onEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        LinearLayout linearLayout;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Context context = parent.getContext();
        LinearLayout $this$onCreateViewHolder_u24lambda_u2d1 = linearLayout = new LinearLayout(context);
        boolean $i$a$-apply-CalendarAdapter$onCreateViewHolder$rootLayout$22 = false;
        $this$onCreateViewHolder_u24lambda_u2d1.setOrientation(1);
        LinearLayout rootLayout = linearLayout;
        if (this.viewConfig.getMonthHeaderRes() != 0) {
            View monthHeaderView = ExtensionsKt.inflate$default((ViewGroup)rootLayout, this.viewConfig.getMonthHeaderRes(), false, 2, null);
            if (monthHeaderView.getId() == -1) {
                monthHeaderView.setId(this.headerViewId);
            } else {
                this.headerViewId = monthHeaderView.getId();
            }
            rootLayout.addView(monthHeaderView);
        }
        Size size = this.calView.getDaySize();
        int n = this.viewConfig.getDayViewRes();
        DayBinder<ViewContainer> dayBinder = this.calView.getDayBinder();
        Intrinsics.checkNotNull(dayBinder, (String)"null cannot be cast to non-null type com.kizitonwose.calendarview.ui.DayBinder<com.kizitonwose.calendarview.ui.ViewContainer>");
        DayConfig dayConfig = new DayConfig(size, n, dayBinder);
        Iterable $i$a$-apply-CalendarAdapter$onCreateViewHolder$rootLayout$22 = (Iterable)new IntRange(1, 6);
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WeekHolder(this.createDayHolders(dayConfig)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2d16$iv = var9_10 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            WeekHolder weekHolder = (WeekHolder)element$iv;
            boolean bl2 = false;
            rootLayout.addView(weekHolder.inflateWeekView(rootLayout));
        }
        List weekHolders = (List)var9_10;
        if (this.viewConfig.getMonthFooterRes() != 0) {
            View monthFooterView = ExtensionsKt.inflate$default((ViewGroup)rootLayout, this.viewConfig.getMonthFooterRes(), false, 2, null);
            if (monthFooterView.getId() == -1) {
                monthFooterView.setId(this.footerViewId);
            } else {
                this.footerViewId = monthFooterView.getId();
            }
            rootLayout.addView(monthFooterView);
        }
        String string = this.viewConfig.getMonthViewClass();
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            Object[] element$iv = new Class[]{Context.class};
            Constructor<?> constructor = Class.forName(it).getDeclaredConstructor((Class<?>[])element$iv);
            element$iv = new Object[]{context};
            Object object2 = constructor.newInstance(element$iv);
            Intrinsics.checkNotNull(object2, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            ViewGroup customLayout = (ViewGroup)object2;
            Object $this$onCreateViewHolder_u24lambda_u2d6_u24lambda_u2d5 = object2 = customLayout;
            boolean bl4 = false;
            CalendarAdapter.onCreateViewHolder$setupRoot(this, $this$onCreateViewHolder_u24lambda_u2d6_u24lambda_u2d5);
            $this$onCreateViewHolder_u24lambda_u2d6_u24lambda_u2d5.addView((View)rootLayout);
            object = object2;
        } else {
            LinearLayout linearLayout2;
            LinearLayout $this$onCreateViewHolder_u24lambda_u2d7 = linearLayout2 = rootLayout;
            boolean bl5 = false;
            CalendarAdapter.onCreateViewHolder$setupRoot(this, (ViewGroup)$this$onCreateViewHolder_u24lambda_u2d7);
            object = (ViewGroup)linearLayout2;
        }
        ViewGroup userRoot = object;
        return new MonthViewHolder(this, userRoot, weekHolders, this.calView.getMonthHeaderBinder(), this.calView.getMonthFooterBinder());
    }

    /*
     * WARNING - void declaration
     */
    private final List<DayHolder> createDayHolders(DayConfig dayConfig) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(1, 7);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DayHolder(dayConfig));
        }
        return (List)destination$iv$iv;
    }

    public void onBindViewHolder(@NotNull MonthViewHolder holder, int position, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        } else {
            Iterable $this$forEach$iv = payloads;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type com.kizitonwose.calendarview.model.CalendarDay");
                holder.reloadDay((CalendarDay)it);
            }
        }
    }

    public void onBindViewHolder(@NotNull MonthViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bindMonth(this.getItem(position));
    }

    public final void reloadDay(@NotNull CalendarDay day) {
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        int position = this.getAdapterPosition$com_github_kizitonwose_CalendarView(day);
        if (position != -1) {
            this.notifyItemChanged(position, day);
        }
    }

    public final void reloadMonth(@NotNull YearMonth month) {
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        this.notifyItemChanged(this.getAdapterPosition$com_github_kizitonwose_CalendarView(month));
    }

    public final void reloadCalendar() {
        this.notifyItemRangeChanged(0, this.getItemCount());
    }

    public final void notifyMonthScrollListenerIfNeeded() {
        CalendarMonth visibleMonth;
        if (!this.isAttached()) {
            return;
        }
        if (this.calView.isAnimating()) {
            RecyclerView.ItemAnimator itemAnimator = this.calView.getItemAnimator();
            if (itemAnimator != null) {
                itemAnimator.isRunning(() -> CalendarAdapter.notifyMonthScrollListenerIfNeeded$lambda-10(this));
            }
            return;
        }
        int visibleItemPos = this.findFirstVisibleMonthPosition();
        if (visibleItemPos != -1 && !Intrinsics.areEqual((Object)(visibleMonth = this.getMonths().get(visibleItemPos)), (Object)this.visibleMonth)) {
            this.visibleMonth = visibleMonth;
            Function1<CalendarMonth, Unit> function1 = this.calView.getMonthScrollListener();
            if (function1 != null) {
                function1.invoke((Object)visibleMonth);
            }
            if (this.calView.getScrollMode() == ScrollMode.PAGED) {
                boolean calWrapsHeight;
                boolean bl;
                Boolean bl2 = this.calWrapsHeight;
                if (bl2 != null) {
                    bl = bl2;
                } else {
                    boolean bl3;
                    boolean it = bl3 = this.calView.getLayoutParams().height == -2;
                    boolean bl4 = false;
                    this.calWrapsHeight = it;
                    bl = calWrapsHeight = bl3;
                }
                if (!calWrapsHeight) {
                    return;
                }
                RecyclerView.ViewHolder it = this.calView.findViewHolderForAdapterPosition(visibleItemPos);
                MonthViewHolder monthViewHolder = it instanceof MonthViewHolder ? (MonthViewHolder)it : null;
                if (monthViewHolder == null) {
                    return;
                }
                MonthViewHolder visibleVH = monthViewHolder;
                View view = visibleVH.getHeaderView();
                Integer $this$orZero$iv = view != null ? Integer.valueOf(view.getHeight()) : null;
                boolean $i$f$orZero = false;
                Integer n = $this$orZero$iv;
                View view2 = visibleVH.getHeaderView();
                $this$orZero$iv = view2 != null ? Integer.valueOf(ExtensionsKt.getVerticalMargins(view2)) : null;
                $i$f$orZero = false;
                Integer n2 = $this$orZero$iv;
                View view3 = visibleVH.getFooterView();
                $this$orZero$iv = view3 != null ? Integer.valueOf(view3.getHeight()) : null;
                $i$f$orZero = false;
                Integer n3 = $this$orZero$iv;
                View view4 = visibleVH.getFooterView();
                $this$orZero$iv = view4 != null ? Integer.valueOf(ExtensionsKt.getVerticalMargins(view4)) : null;
                $i$f$orZero = false;
                Integer n4 = $this$orZero$iv;
                int newHeight = (n != null ? n : 0) + (n2 != null ? n2 : 0) + visibleMonth.getWeekDays().size() * this.calView.getDaySize().getHeight() + (n3 != null ? n3 : 0) + (n4 != null ? n4 : 0);
                if (this.calView.getHeight() != newHeight) {
                    Object object = new int[]{this.calView.getHeight(), newHeight};
                    Object $this$notifyMonthScrollListenerIfNeeded_u24lambda_u2d14 = object = (Object)ValueAnimator.ofInt((int[])object);
                    boolean bl5 = false;
                    $this$notifyMonthScrollListenerIfNeeded_u24lambda_u2d14.setDuration(this.initialLayout ? 0L : (long)this.calView.getWrappedPageHeightAnimationDuration());
                    $this$notifyMonthScrollListenerIfNeeded_u24lambda_u2d14.addUpdateListener(arg_0 -> CalendarAdapter.notifyMonthScrollListenerIfNeeded$lambda-14$lambda-13(this, visibleVH, arg_0));
                    $this$notifyMonthScrollListenerIfNeeded_u24lambda_u2d14.start();
                } else {
                    visibleVH.itemView.requestLayout();
                }
                if (this.initialLayout) {
                    this.initialLayout = false;
                }
            }
        }
    }

    public final int getAdapterPosition$com_github_kizitonwose_CalendarView(@NotNull YearMonth month) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter((Object)month, (String)"month");
            List<CalendarMonth> $this$indexOfFirst$iv = this.getMonths();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<CalendarMonth> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                CalendarMonth item$iv;
                CalendarMonth it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getYearMonth(), (Object)month)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public final int getAdapterPosition$com_github_kizitonwose_CalendarView(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getAdapterPosition$com_github_kizitonwose_CalendarView(new CalendarDay(date, DayOwner.THIS_MONTH));
    }

    public final int getAdapterPosition$com_github_kizitonwose_CalendarView(@NotNull CalendarDay day) {
        int n;
        block24: {
            Intrinsics.checkNotNullParameter((Object)day, (String)"day");
            if (this.monthConfig.getHasBoundaries$com_github_kizitonwose_CalendarView()) {
                int indexWithDateInSameMonth;
                int firstMonthIndex;
                block21: {
                    int n2;
                    List sameMonths;
                    firstMonthIndex = this.getAdapterPosition$com_github_kizitonwose_CalendarView(day.getPositionYearMonth$com_github_kizitonwose_CalendarView());
                    if (firstMonthIndex == -1) {
                        return -1;
                    }
                    CalendarMonth firstCalMonth = this.getMonths().get(firstMonthIndex);
                    List $this$indexOfFirst$iv = sameMonths = CollectionsKt.slice(this.getMonths(), (IntRange)RangesKt.until((int)firstMonthIndex, (int)(firstMonthIndex + firstCalMonth.getNumberOfSameMonth$com_github_kizitonwose_CalendarView())));
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        boolean bl;
                        block20: {
                            CalendarMonth months = (CalendarMonth)item$iv;
                            boolean bl2 = false;
                            Iterable $this$any$iv = months.getWeekDays();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    boolean bl3;
                                    block19: {
                                        List weeks = (List)element$iv;
                                        boolean bl4 = false;
                                        Iterable $this$any$iv2 = weeks;
                                        boolean $i$f$any2 = false;
                                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                            bl3 = false;
                                        } else {
                                            for (Object element$iv2 : $this$any$iv2) {
                                                CalendarDay it = (CalendarDay)element$iv2;
                                                boolean bl5 = false;
                                                if (!Intrinsics.areEqual((Object)it, (Object)day)) continue;
                                                bl3 = true;
                                                break block19;
                                            }
                                            bl3 = false;
                                        }
                                    }
                                    if (!bl3) continue;
                                    bl = true;
                                    break block20;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            n2 = index$iv;
                            break block21;
                        }
                        ++index$iv;
                    }
                    n2 = indexWithDateInSameMonth = -1;
                }
                n = indexWithDateInSameMonth == -1 ? -1 : firstMonthIndex + indexWithDateInSameMonth;
            } else {
                List<CalendarMonth> $this$indexOfFirst$iv = this.getMonths();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<CalendarMonth> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    block23: {
                        CalendarMonth item$iv;
                        CalendarMonth months = item$iv = iterator.next();
                        boolean bl6 = false;
                        Iterable $this$any$iv = months.getWeekDays();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                boolean bl7;
                                block22: {
                                    List weeks = (List)element$iv;
                                    boolean bl8 = false;
                                    Iterable $this$any$iv3 = weeks;
                                    boolean $i$f$any3 = false;
                                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                        bl7 = false;
                                    } else {
                                        for (Object element$iv3 : $this$any$iv3) {
                                            CalendarDay it = (CalendarDay)element$iv3;
                                            boolean bl9 = false;
                                            if (!Intrinsics.areEqual((Object)it, (Object)day)) continue;
                                            bl7 = true;
                                            break block22;
                                        }
                                        bl7 = false;
                                    }
                                }
                                if (!bl7) continue;
                                bl = true;
                                break block23;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        n = index$iv;
                        break block24;
                    }
                    ++index$iv;
                }
                n = -1;
            }
        }
        return n;
    }

    private final CalendarLayoutManager getLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.calView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarLayoutManager");
        return (CalendarLayoutManager)layoutManager;
    }

    @Nullable
    public final CalendarMonth findFirstVisibleMonth() {
        return (CalendarMonth)CollectionsKt.getOrNull(this.getMonths(), (int)this.findFirstVisibleMonthPosition());
    }

    @Nullable
    public final CalendarMonth findLastVisibleMonth() {
        return (CalendarMonth)CollectionsKt.getOrNull(this.getMonths(), (int)this.findLastVisibleMonthPosition());
    }

    @Nullable
    public final CalendarDay findFirstVisibleDay() {
        return this.findVisibleDay(true);
    }

    @Nullable
    public final CalendarDay findLastVisibleDay() {
        return this.findVisibleDay(false);
    }

    private final int findFirstVisibleMonthPosition() {
        return this.findVisibleMonthPosition(true);
    }

    private final int findLastVisibleMonthPosition() {
        return this.findVisibleMonthPosition(false);
    }

    private final int findVisibleMonthPosition(boolean isFirst) {
        int visibleItemPos;
        int n = visibleItemPos = isFirst ? this.getLayoutManager().findFirstVisibleItemPosition() : this.getLayoutManager().findLastVisibleItemPosition();
        if (visibleItemPos != -1) {
            Rect rect = new Rect();
            boolean bl = false;
            View view = this.getLayoutManager().findViewByPosition(visibleItemPos);
            if (view == null) {
                return -1;
            }
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"layoutManager.findViewBy\u2026emPos) ?: return NO_INDEX");
            View visibleItemView = view;
            visibleItemView.getGlobalVisibleRect(rect);
            int visibleItemPx = this.calView.isVertical$com_github_kizitonwose_CalendarView() ? rect.bottom - rect.top : rect.right - rect.left;
            if (visibleItemPx <= 7) {
                int nextItemPosition = isFirst ? visibleItemPos + 1 : visibleItemPos - 1;
                return CollectionsKt.getIndices((Collection)this.getMonths()).contains(nextItemPosition) ? nextItemPosition : visibleItemPos;
            }
        }
        return visibleItemPos;
    }

    /*
     * WARNING - void declaration
     */
    private final CalendarDay findVisibleDay(boolean isFirst) {
        Object v4;
        block5: {
            void $this$firstOrNull$iv;
            int visibleIndex;
            int n = visibleIndex = isFirst ? this.findFirstVisibleMonthPosition() : this.findLastVisibleMonthPosition();
            if (visibleIndex == -1) {
                return null;
            }
            View view = this.getLayoutManager().findViewByPosition(visibleIndex);
            if (view == null) {
                return null;
            }
            View visibleItemView = view;
            Rect monthRect = new Rect();
            visibleItemView.getGlobalVisibleRect(monthRect);
            Rect dayRect = new Rect();
            List $this$findVisibleDay_u24lambda_u2d23 = CollectionsKt.flatten((Iterable)this.getMonths().get(visibleIndex).getWeekDays());
            boolean bl = false;
            Iterable iterable = isFirst ? $this$findVisibleDay_u24lambda_u2d23 : CollectionsKt.reversed((Iterable)$this$findVisibleDay_u24lambda_u2d23);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl2;
                View view2;
                CalendarDay it = (CalendarDay)element$iv;
                boolean bl3 = false;
                View view3 = view2 = visibleItemView.findViewWithTag((Object)it.getDate().hashCode());
                if (view3 == null) {
                    bl2 = false;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"visibleItemView.findView\u2026 return@firstOrNull false");
                    View dayView = view2;
                    dayView.getGlobalVisibleRect(dayRect);
                    bl2 = dayRect.intersect(monthRect);
                }
                if (!bl2) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        return v4;
    }

    private static final void onAttachedToRecyclerView$lambda-0(CalendarAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyMonthScrollListenerIfNeeded();
    }

    /*
     * WARNING - void declaration
     */
    private static final void onCreateViewHolder$setupRoot(CalendarAdapter this$0, ViewGroup root) {
        ViewGroup.MarginLayoutParams marginLayoutParams;
        ViewCompat.setPaddingRelative((View)((View)root), (int)this$0.calView.getMonthPaddingStart(), (int)this$0.calView.getMonthPaddingTop(), (int)this$0.calView.getMonthPaddingEnd(), (int)this$0.calView.getMonthPaddingBottom());
        ViewGroup.MarginLayoutParams marginLayoutParams2 = marginLayoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        ViewGroup viewGroup = root;
        boolean bl = false;
        $this$onCreateViewHolder_u24setupRoot_u24lambda_u2d4.bottomMargin = this$0.calView.getMonthMarginBottom();
        $this$onCreateViewHolder_u24setupRoot_u24lambda_u2d4.topMargin = this$0.calView.getMonthMarginTop();
        if (Build.VERSION.SDK_INT >= 17) {
            void $this$onCreateViewHolder_u24setupRoot_u24lambda_u2d4;
            $this$onCreateViewHolder_u24setupRoot_u24lambda_u2d4.setMarginStart(this$0.calView.getMonthMarginStart());
            $this$onCreateViewHolder_u24setupRoot_u24lambda_u2d4.setMarginEnd(this$0.calView.getMonthMarginEnd());
        } else {
            $this$onCreateViewHolder_u24setupRoot_u24lambda_u2d4.leftMargin = this$0.calView.getMonthMarginStart();
            $this$onCreateViewHolder_u24setupRoot_u24lambda_u2d4.rightMargin = this$0.calView.getMonthMarginEnd();
        }
        viewGroup.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams);
    }

    private static final void notifyMonthScrollListenerIfNeeded$lambda-10(CalendarAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.notifyMonthScrollListenerIfNeeded();
    }

    private static final void notifyMonthScrollListenerIfNeeded$lambda-14$lambda-13(CalendarAdapter this$0, MonthViewHolder $visibleVH, ValueAnimator it) {
        ViewGroup.LayoutParams params$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$visibleVH), (String)"$visibleVH");
        View $this$updateLayoutParams$iv = (View)this$0.calView;
        boolean $i$f$updateLayoutParams = false;
        View $this$updateLayoutParams$iv$iv = $this$updateLayoutParams$iv;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.LayoutParams");
        }
        ViewGroup.LayoutParams $this$notifyMonthScrollListenerIfNeeded_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12 = params$iv$iv = layoutParams;
        boolean bl = false;
        Object object = it.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        $this$notifyMonthScrollListenerIfNeeded_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12.height = (Integer)object;
        $this$updateLayoutParams$iv$iv.setLayoutParams(params$iv$iv);
        $visibleVH.itemView.requestLayout();
    }
}

