/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendarview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Px;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendarview.CalendarView;
import com.kizitonwose.calendarview.R;
import com.kizitonwose.calendarview.model.CalendarDay;
import com.kizitonwose.calendarview.model.CalendarMonth;
import com.kizitonwose.calendarview.model.DayOwner;
import com.kizitonwose.calendarview.model.InDateStyle;
import com.kizitonwose.calendarview.model.MonthConfig;
import com.kizitonwose.calendarview.model.OutDateStyle;
import com.kizitonwose.calendarview.model.ScrollMode;
import com.kizitonwose.calendarview.ui.CalendarAdapter;
import com.kizitonwose.calendarview.ui.CalendarLayoutManager;
import com.kizitonwose.calendarview.ui.DayBinder;
import com.kizitonwose.calendarview.ui.MonthHeaderFooterBinder;
import com.kizitonwose.calendarview.ui.ViewConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDate;
import org.threeten.bp.YearMonth;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016*\u0002\u0081\u0001\b\u0016\u0018\u0000 \u00ad\u00012\u00020\u0001:\u0004\u00ad\u0001\u00ae\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001J\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010fJ\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008c\u0001J\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010fJ#\u0010\u0090\u0001\u001a\u00020g2\u0007\u0010\u0091\u0001\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0007\u0010\u0092\u0001\u001a\u00020\tH\u0002J\t\u0010\u0093\u0001\u001a\u00020gH\u0002J\u0007\u0010\u0094\u0001\u001a\u00020gJ\u001f\u0010\u0095\u0001\u001a\u00020g2\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\n\b\u0002\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0007J\u0011\u0010\u009a\u0001\u001a\u00020g2\b\u0010\u009b\u0001\u001a\u00030\u008c\u0001J\u0010\u0010\u009c\u0001\u001a\u00020g2\u0007\u0010\u009d\u0001\u001a\u00020(J\u001b\u0010\u009e\u0001\u001a\u00020g2\u0007\u0010\u009f\u0001\u001a\u00020\t2\u0007\u0010\u00a0\u0001\u001a\u00020\tH\u0014J\u001f\u0010\u00a1\u0001\u001a\u00020g2\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\n\b\u0002\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0007J\u0011\u0010\u00a2\u0001\u001a\u00020g2\b\u0010\u009b\u0001\u001a\u00030\u008c\u0001J\u0010\u0010\u00a3\u0001\u001a\u00020g2\u0007\u0010\u009d\u0001\u001a\u00020(J \u0010\u00a4\u0001\u001a\u00020g2\u0007\u0010\u008a\u0001\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u001f\u0010\u00a5\u0001\u001a\u00020g2\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\n\b\u0002\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0007J\u0011\u0010\u00a6\u0001\u001a\u00020g2\b\u0010\u009b\u0001\u001a\u00030\u008c\u0001J\u0010\u0010\u00a7\u0001\u001a\u00020g2\u0007\u0010\u009d\u0001\u001a\u00020(J\t\u0010\u00a8\u0001\u001a\u00020gH\u0002J\t\u0010\u00a9\u0001\u001a\u00020gH\u0002J\u000f\u0010\u00aa\u0001\u001a\u00020g2\u0006\u0010'\u001a\u00020(J\u0018\u0010\u00ab\u0001\u001a\u00020g2\u0007\u0010\u008a\u0001\u001a\u00020(2\u0006\u0010'\u001a\u00020(J\u0010\u0010\u00ac\u0001\u001a\u00020g2\u0007\u0010\u008a\u0001\u001a\u00020(R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R0\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00162\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R&\u0010$\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00101\u001a\u0002002\u0006\u0010\u0015\u001a\u000200@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010-R\u0014\u00108\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010-R$\u0010:\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u001e\"\u0004\b<\u0010 R0\u0010>\u001a\b\u0012\u0002\b\u0003\u0018\u00010=2\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010=@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR$\u0010C\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u001e\"\u0004\bE\u0010 R0\u0010F\u001a\b\u0012\u0002\b\u0003\u0018\u00010=2\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010=@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010@\"\u0004\bH\u0010BR$\u0010I\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u001e\"\u0004\bK\u0010 R&\u0010L\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u001e\"\u0004\bN\u0010 R&\u0010O\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u001e\"\u0004\bQ\u0010 R&\u0010R\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u001e\"\u0004\bT\u0010 R&\u0010U\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u001e\"\u0004\bW\u0010 R&\u0010X\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u001e\"\u0004\bZ\u0010 R&\u0010[\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u001e\"\u0004\b]\u0010 R&\u0010^\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\u001e\"\u0004\b`\u0010 R&\u0010a\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\u001e\"\u0004\bc\u0010 R.\u0010d\u001a\u0016\u0012\u0004\u0012\u00020f\u0012\u0004\u0012\u00020g\u0018\u00010ej\u0004\u0018\u0001`hX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR(\u0010n\u001a\u0004\u0018\u00010m2\b\u0010\u0015\u001a\u0004\u0018\u00010m@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010p\"\u0004\bq\u0010rR*\u0010s\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bt\u0010u\u001a\u0004\bv\u0010\u001e\"\u0004\bw\u0010 R$\u0010y\u001a\u00020x2\u0006\u0010\u0015\u001a\u00020x@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010{\"\u0004\b|\u0010}R\u000e\u0010~\u001a\u00020\u007fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0080\u0001\u001a\u00030\u0081\u0001X\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u0082\u0001R+\u0010\u0084\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0015\u001a\u00030\u0083\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R\u000f\u0010\u0089\u0001\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u008a\u0001\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00af\u0001"}, d2={"Lcom/kizitonwose/calendarview/CalendarView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoSize", "", "calendarAdapter", "Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "getCalendarAdapter", "()Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "calendarLayoutManager", "Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "getCalendarLayoutManager", "()Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "value", "Lcom/kizitonwose/calendarview/ui/DayBinder;", "dayBinder", "getDayBinder", "()Lcom/kizitonwose/calendarview/ui/DayBinder;", "setDayBinder", "(Lcom/kizitonwose/calendarview/ui/DayBinder;)V", "dayHeight", "getDayHeight", "()I", "setDayHeight", "(I)V", "dayViewResource", "getDayViewResource", "setDayViewResource", "dayWidth", "getDayWidth", "setDayWidth", "endMonth", "Lorg/threeten/bp/YearMonth;", "firstDayOfWeek", "Lorg/threeten/bp/DayOfWeek;", "hasBoundaries", "getHasBoundaries", "()Z", "setHasBoundaries", "(Z)V", "Lcom/kizitonwose/calendarview/model/InDateStyle;", "inDateStyle", "getInDateStyle", "()Lcom/kizitonwose/calendarview/model/InDateStyle;", "setInDateStyle", "(Lcom/kizitonwose/calendarview/model/InDateStyle;)V", "isHorizontal", "isHorizontal$com_github_kizitonwose_CalendarView", "isVertical", "isVertical$com_github_kizitonwose_CalendarView", "maxRowCount", "getMaxRowCount", "setMaxRowCount", "Lcom/kizitonwose/calendarview/ui/MonthHeaderFooterBinder;", "monthFooterBinder", "getMonthFooterBinder", "()Lcom/kizitonwose/calendarview/ui/MonthHeaderFooterBinder;", "setMonthFooterBinder", "(Lcom/kizitonwose/calendarview/ui/MonthHeaderFooterBinder;)V", "monthFooterResource", "getMonthFooterResource", "setMonthFooterResource", "monthHeaderBinder", "getMonthHeaderBinder", "setMonthHeaderBinder", "monthHeaderResource", "getMonthHeaderResource", "setMonthHeaderResource", "monthMarginBottom", "getMonthMarginBottom", "setMonthMarginBottom", "monthMarginEnd", "getMonthMarginEnd", "setMonthMarginEnd", "monthMarginStart", "getMonthMarginStart", "setMonthMarginStart", "monthMarginTop", "getMonthMarginTop", "setMonthMarginTop", "monthPaddingBottom", "getMonthPaddingBottom", "setMonthPaddingBottom", "monthPaddingEnd", "getMonthPaddingEnd", "setMonthPaddingEnd", "monthPaddingStart", "getMonthPaddingStart", "setMonthPaddingStart", "monthPaddingTop", "getMonthPaddingTop", "setMonthPaddingTop", "monthScrollListener", "Lkotlin/Function1;", "Lcom/kizitonwose/calendarview/model/CalendarMonth;", "", "Lcom/kizitonwose/calendarview/ui/MonthScrollListener;", "getMonthScrollListener", "()Lkotlin/jvm/functions/Function1;", "setMonthScrollListener", "(Lkotlin/jvm/functions/Function1;)V", "", "monthViewClass", "getMonthViewClass", "()Ljava/lang/String;", "setMonthViewClass", "(Ljava/lang/String;)V", "orientation", "orientation$annotations", "()V", "getOrientation", "setOrientation", "Lcom/kizitonwose/calendarview/model/OutDateStyle;", "outDateStyle", "getOutDateStyle", "()Lcom/kizitonwose/calendarview/model/OutDateStyle;", "setOutDateStyle", "(Lcom/kizitonwose/calendarview/model/OutDateStyle;)V", "pagerSnapHelper", "Landroidx/recyclerview/widget/PagerSnapHelper;", "scrollListenerInternal", "com/kizitonwose/calendarview/CalendarView$scrollListenerInternal$1", "Lcom/kizitonwose/calendarview/CalendarView$scrollListenerInternal$1;", "Lcom/kizitonwose/calendarview/model/ScrollMode;", "scrollMode", "getScrollMode", "()Lcom/kizitonwose/calendarview/model/ScrollMode;", "setScrollMode", "(Lcom/kizitonwose/calendarview/model/ScrollMode;)V", "sizedInternally", "startMonth", "findFirstVisibleDay", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "findFirstVisibleMonth", "findLastVisibleDay", "findLastVisibleMonth", "init", "attributeSet", "defStyleRes", "invalidateViewHolders", "notifyCalendarChanged", "notifyDateChanged", "date", "Lorg/threeten/bp/LocalDate;", "owner", "Lcom/kizitonwose/calendarview/model/DayOwner;", "notifyDayChanged", "day", "notifyMonthChanged", "month", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "scrollToDate", "scrollToDay", "scrollToMonth", "setup", "smoothScrollToDate", "smoothScrollToDay", "smoothScrollToMonth", "updateAdapterMonthConfig", "updateAdapterViewConfig", "updateEndMonth", "updateMonthRange", "updateStartMonth", "Companion", "MonthRangeDiffCallback", "com.github.kizitonwose.CalendarView"})
public class CalendarView
extends RecyclerView {
    @Nullable
    private DayBinder<?> dayBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthHeaderBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthFooterBinder;
    @Nullable
    private Function1<? super CalendarMonth, Unit> monthScrollListener;
    private int dayViewResource;
    private int monthHeaderResource;
    private int monthFooterResource;
    @Nullable
    private String monthViewClass;
    private int orientation;
    @NotNull
    private ScrollMode scrollMode;
    @NotNull
    private InDateStyle inDateStyle;
    @NotNull
    private OutDateStyle outDateStyle;
    private int maxRowCount;
    private boolean hasBoundaries;
    private YearMonth startMonth;
    private YearMonth endMonth;
    private DayOfWeek firstDayOfWeek;
    private boolean autoSize;
    private boolean sizedInternally;
    @Px
    private int dayWidth;
    @Px
    private int dayHeight;
    @Px
    private int monthPaddingStart;
    @Px
    private int monthPaddingEnd;
    @Px
    private int monthPaddingTop;
    @Px
    private int monthPaddingBottom;
    @Px
    private int monthMarginStart;
    @Px
    private int monthMarginEnd;
    @Px
    private int monthMarginTop;
    @Px
    private int monthMarginBottom;
    private final scrollListenerInternal.1 scrollListenerInternal;
    private final PagerSnapHelper pagerSnapHelper;
    public static final int DAY_SIZE_SQUARE = Integer.MIN_VALUE;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final DayBinder<?> getDayBinder() {
        return this.dayBinder;
    }

    public final void setDayBinder(@Nullable DayBinder<?> value) {
        this.dayBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthHeaderBinder() {
        return this.monthHeaderBinder;
    }

    public final void setMonthHeaderBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        this.monthHeaderBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthFooterBinder() {
        return this.monthFooterBinder;
    }

    public final void setMonthFooterBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        this.monthFooterBinder = value;
        this.invalidateViewHolders();
    }

    @Nullable
    public final Function1<CalendarMonth, Unit> getMonthScrollListener() {
        return this.monthScrollListener;
    }

    public final void setMonthScrollListener(@Nullable Function1<? super CalendarMonth, Unit> function1) {
        this.monthScrollListener = function1;
    }

    public final int getDayViewResource() {
        return this.dayViewResource;
    }

    public final void setDayViewResource(int value) {
        if (this.dayViewResource != value) {
            if (value == 0) {
                throw (Throwable)new IllegalArgumentException("'dayViewResource' attribute not provided.");
            }
            this.dayViewResource = value;
            this.updateAdapterViewConfig();
        }
    }

    public final int getMonthHeaderResource() {
        return this.monthHeaderResource;
    }

    public final void setMonthHeaderResource(int value) {
        if (this.monthHeaderResource != value) {
            this.monthHeaderResource = value;
            this.updateAdapterViewConfig();
        }
    }

    public final int getMonthFooterResource() {
        return this.monthFooterResource;
    }

    public final void setMonthFooterResource(int value) {
        if (this.monthFooterResource != value) {
            this.monthFooterResource = value;
            this.updateAdapterViewConfig();
        }
    }

    @Nullable
    public final String getMonthViewClass() {
        return this.monthViewClass;
    }

    public final void setMonthViewClass(@Nullable String value) {
        if (Intrinsics.areEqual((Object)this.monthViewClass, (Object)value) ^ true) {
            this.monthViewClass = value;
            this.updateAdapterViewConfig();
        }
    }

    public static /* synthetic */ void orientation$annotations() {
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int value) {
        if (this.orientation != value) {
            this.orientation = value;
            YearMonth yearMonth = this.startMonth;
            if (yearMonth == null) {
                return;
            }
            YearMonth yearMonth2 = this.endMonth;
            if (yearMonth2 == null) {
                return;
            }
            DayOfWeek dayOfWeek = this.firstDayOfWeek;
            if (dayOfWeek == null) {
                return;
            }
            this.setup(yearMonth, yearMonth2, dayOfWeek);
        }
    }

    @NotNull
    public final ScrollMode getScrollMode() {
        return this.scrollMode;
    }

    public final void setScrollMode(@NotNull ScrollMode value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (this.scrollMode != value) {
            this.scrollMode = value;
            this.pagerSnapHelper.attachToRecyclerView((RecyclerView)(value == ScrollMode.PAGED ? this : null));
        }
    }

    @NotNull
    public final InDateStyle getInDateStyle() {
        return this.inDateStyle;
    }

    public final void setInDateStyle(@NotNull InDateStyle value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (this.inDateStyle != value) {
            this.inDateStyle = value;
            this.updateAdapterMonthConfig();
        }
    }

    @NotNull
    public final OutDateStyle getOutDateStyle() {
        return this.outDateStyle;
    }

    public final void setOutDateStyle(@NotNull OutDateStyle value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        if (this.outDateStyle != value) {
            this.outDateStyle = value;
            this.updateAdapterMonthConfig();
        }
    }

    public final int getMaxRowCount() {
        return this.maxRowCount;
    }

    public final void setMaxRowCount(int value) {
        int n = 1;
        if (!new IntRange(n, 6).contains(value)) {
            throw (Throwable)new IllegalArgumentException("'maxRowCount' should be between 1 to 6");
        }
        if (this.maxRowCount != value) {
            this.maxRowCount = value;
            this.updateAdapterMonthConfig();
        }
    }

    public final boolean getHasBoundaries() {
        return this.hasBoundaries;
    }

    public final void setHasBoundaries(boolean value) {
        if (this.hasBoundaries != value) {
            this.hasBoundaries = value;
            this.updateAdapterMonthConfig();
        }
    }

    public final boolean isVertical$com_github_kizitonwose_CalendarView() {
        return this.orientation == 1;
    }

    public final boolean isHorizontal$com_github_kizitonwose_CalendarView() {
        return !this.isVertical$com_github_kizitonwose_CalendarView();
    }

    private final void init(AttributeSet attributeSet, int defStyleAttr, int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        this.setDayViewResource(a.getResourceId(R.styleable.CalendarView_cv_dayViewResource, this.dayViewResource));
        this.setMonthHeaderResource(a.getResourceId(R.styleable.CalendarView_cv_monthHeaderResource, this.monthHeaderResource));
        this.setMonthFooterResource(a.getResourceId(R.styleable.CalendarView_cv_monthFooterResource, this.monthFooterResource));
        this.setOrientation(a.getInt(R.styleable.CalendarView_cv_orientation, this.orientation));
        this.setScrollMode(ScrollMode.values()[a.getInt(R.styleable.CalendarView_cv_scrollMode, this.scrollMode.ordinal())]);
        this.setOutDateStyle(OutDateStyle.values()[a.getInt(R.styleable.CalendarView_cv_outDateStyle, this.outDateStyle.ordinal())]);
        this.setInDateStyle(InDateStyle.values()[a.getInt(R.styleable.CalendarView_cv_inDateStyle, this.inDateStyle.ordinal())]);
        this.setMaxRowCount(a.getInt(R.styleable.CalendarView_cv_maxRowCount, this.maxRowCount));
        this.setMonthViewClass(a.getString(R.styleable.CalendarView_cv_monthViewClass));
        this.setHasBoundaries(a.getBoolean(R.styleable.CalendarView_cv_hasBoundaries, this.hasBoundaries));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.autoSize && !this.isInEditMode()) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (widthMode == 0 && heightMode == 0) {
                throw (Throwable)new UnsupportedOperationException("Cannot calculate the values for day Width/Height with the current configuration.");
            }
            int squareSize = (int)((double)((float)(widthSize - (this.monthPaddingStart + this.monthPaddingEnd)) / 7.0f) + 0.5);
            if (this.dayWidth != squareSize || this.dayHeight != squareSize) {
                this.sizedInternally = true;
                this.setDayWidth(squareSize);
                this.setDayHeight(squareSize);
                this.sizedInternally = false;
                this.invalidateViewHolders();
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public final int getDayWidth() {
        return this.dayWidth;
    }

    public final void setDayWidth(int value) {
        this.dayWidth = value;
        if (!this.sizedInternally) {
            this.autoSize = value == Integer.MIN_VALUE;
            this.invalidateViewHolders();
        }
    }

    public final int getDayHeight() {
        return this.dayHeight;
    }

    public final void setDayHeight(int value) {
        this.dayHeight = value;
        if (!this.sizedInternally) {
            this.autoSize = value == Integer.MIN_VALUE;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthPaddingStart() {
        return this.monthPaddingStart;
    }

    public final void setMonthPaddingStart(int value) {
        this.monthPaddingStart = value;
        this.invalidateViewHolders();
    }

    public final int getMonthPaddingEnd() {
        return this.monthPaddingEnd;
    }

    public final void setMonthPaddingEnd(int value) {
        this.monthPaddingEnd = value;
        this.invalidateViewHolders();
    }

    public final int getMonthPaddingTop() {
        return this.monthPaddingTop;
    }

    public final void setMonthPaddingTop(int value) {
        this.monthPaddingTop = value;
        this.invalidateViewHolders();
    }

    public final int getMonthPaddingBottom() {
        return this.monthPaddingBottom;
    }

    public final void setMonthPaddingBottom(int value) {
        this.monthPaddingBottom = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginStart() {
        return this.monthMarginStart;
    }

    public final void setMonthMarginStart(int value) {
        this.monthMarginStart = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginEnd() {
        return this.monthMarginEnd;
    }

    public final void setMonthMarginEnd(int value) {
        this.monthMarginEnd = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginTop() {
        return this.monthMarginTop;
    }

    public final void setMonthMarginTop(int value) {
        this.monthMarginTop = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginBottom() {
        return this.monthMarginBottom;
    }

    public final void setMonthMarginBottom(int value) {
        this.monthMarginBottom = value;
        this.invalidateViewHolders();
    }

    private final CalendarLayoutManager getCalendarLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarLayoutManager");
        }
        return (CalendarLayoutManager)layoutManager;
    }

    private final CalendarAdapter getCalendarAdapter() {
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarAdapter");
        }
        return (CalendarAdapter)adapter;
    }

    private final void invalidateViewHolders() {
        if (this.getAdapter() == null || this.getLayoutManager() == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        Parcelable state = layoutManager != null ? layoutManager.onSaveInstanceState() : null;
        this.setAdapter(this.getAdapter());
        RecyclerView.LayoutManager layoutManager2 = this.getLayoutManager();
        if (layoutManager2 != null) {
            layoutManager2.onRestoreInstanceState(state);
        }
        this.post(new Runnable(this){
            final /* synthetic */ CalendarView this$0;

            public final void run() {
                CalendarView.access$getCalendarAdapter$p(this.this$0).notifyMonthScrollListenerIfNeeded();
            }
            {
                this.this$0 = calendarView;
            }
        });
    }

    private final void updateAdapterMonthConfig() {
        if (this.getAdapter() != null) {
            YearMonth yearMonth = this.startMonth;
            if (yearMonth == null) {
                return;
            }
            YearMonth yearMonth2 = this.endMonth;
            if (yearMonth2 == null) {
                return;
            }
            DayOfWeek dayOfWeek = this.firstDayOfWeek;
            if (dayOfWeek == null) {
                return;
            }
            this.getCalendarAdapter().setMonthConfig$com_github_kizitonwose_CalendarView(new MonthConfig(this.outDateStyle, this.inDateStyle, this.maxRowCount, yearMonth, yearMonth2, dayOfWeek, this.hasBoundaries));
            this.getCalendarAdapter().notifyDataSetChanged();
            this.post(new Runnable(this){
                final /* synthetic */ CalendarView this$0;

                public final void run() {
                    CalendarView.access$getCalendarAdapter$p(this.this$0).notifyMonthScrollListenerIfNeeded();
                }
                {
                    this.this$0 = calendarView;
                }
            });
        }
    }

    private final void updateAdapterViewConfig() {
        if (this.getAdapter() != null) {
            this.getCalendarAdapter().setViewConfig$com_github_kizitonwose_CalendarView(new ViewConfig(this.dayViewResource, this.monthHeaderResource, this.monthFooterResource, this.monthViewClass));
            this.invalidateViewHolders();
        }
    }

    public final void scrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.getCalendarLayoutManager().scrollToMonth(month);
    }

    public final void smoothScrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.getCalendarLayoutManager().smoothScrollToMonth(month);
    }

    public final void scrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
        this.getCalendarLayoutManager().scrollToDay(day);
    }

    @JvmOverloads
    public final void scrollToDate(@NotNull LocalDate date, @NotNull DayOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)((Object)owner), (String)"owner");
        this.scrollToDay(new CalendarDay(date, owner));
    }

    public static /* synthetic */ void scrollToDate$default(CalendarView calendarView, LocalDate localDate, DayOwner dayOwner, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollToDate");
        }
        if ((n & 2) != 0) {
            dayOwner = DayOwner.THIS_MONTH;
        }
        calendarView.scrollToDate(localDate, dayOwner);
    }

    @JvmOverloads
    public final void scrollToDate(@NotNull LocalDate date) {
        CalendarView.scrollToDate$default(this, date, null, 2, null);
    }

    public final void smoothScrollToDay(@NotNull CalendarDay day) {
        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
        this.getCalendarLayoutManager().smoothScrollToDay(day);
    }

    @JvmOverloads
    public final void smoothScrollToDate(@NotNull LocalDate date, @NotNull DayOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)((Object)owner), (String)"owner");
        this.smoothScrollToDay(new CalendarDay(date, owner));
    }

    public static /* synthetic */ void smoothScrollToDate$default(CalendarView calendarView, LocalDate localDate, DayOwner dayOwner, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: smoothScrollToDate");
        }
        if ((n & 2) != 0) {
            dayOwner = DayOwner.THIS_MONTH;
        }
        calendarView.smoothScrollToDate(localDate, dayOwner);
    }

    @JvmOverloads
    public final void smoothScrollToDate(@NotNull LocalDate date) {
        CalendarView.smoothScrollToDate$default(this, date, null, 2, null);
    }

    public final void notifyDayChanged(@NotNull CalendarDay day) {
        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
        this.getCalendarAdapter().reloadDay(day);
    }

    @JvmOverloads
    public final void notifyDateChanged(@NotNull LocalDate date, @NotNull DayOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)((Object)owner), (String)"owner");
        this.notifyDayChanged(new CalendarDay(date, owner));
    }

    public static /* synthetic */ void notifyDateChanged$default(CalendarView calendarView, LocalDate localDate, DayOwner dayOwner, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyDateChanged");
        }
        if ((n & 2) != 0) {
            dayOwner = DayOwner.THIS_MONTH;
        }
        calendarView.notifyDateChanged(localDate, dayOwner);
    }

    @JvmOverloads
    public final void notifyDateChanged(@NotNull LocalDate date) {
        CalendarView.notifyDateChanged$default(this, date, null, 2, null);
    }

    public final void notifyMonthChanged(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.getCalendarAdapter().reloadMonth(month);
    }

    public final void notifyCalendarChanged() {
        this.getCalendarAdapter().notifyDataSetChanged();
    }

    @Nullable
    public final CalendarMonth findFirstVisibleMonth() {
        return this.getCalendarAdapter().findFirstVisibleMonth();
    }

    @Nullable
    public final CalendarMonth findLastVisibleMonth() {
        return this.getCalendarAdapter().findLastVisibleMonth();
    }

    @Nullable
    public final CalendarDay findFirstVisibleDay() {
        return this.getCalendarAdapter().findFirstVisibleDay();
    }

    @Nullable
    public final CalendarDay findLastVisibleDay() {
        return this.getCalendarAdapter().findLastVisibleDay();
    }

    public final void setup(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkParameterIsNotNull((Object)startMonth, (String)"startMonth");
        Intrinsics.checkParameterIsNotNull((Object)endMonth, (String)"endMonth");
        Intrinsics.checkParameterIsNotNull((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        if (this.startMonth != null && this.endMonth != null && this.firstDayOfWeek != null) {
            this.firstDayOfWeek = firstDayOfWeek;
            this.updateMonthRange(startMonth, endMonth);
        } else {
            this.startMonth = startMonth;
            this.endMonth = endMonth;
            this.firstDayOfWeek = firstDayOfWeek;
            this.setClipToPadding(false);
            this.setClipChildren(false);
            this.removeOnScrollListener(this.scrollListenerInternal);
            this.addOnScrollListener(this.scrollListenerInternal);
            this.setLayoutManager((RecyclerView.LayoutManager)new CalendarLayoutManager(this, this.orientation));
            this.setAdapter(new CalendarAdapter(this, new ViewConfig(this.dayViewResource, this.monthHeaderResource, this.monthFooterResource, this.monthViewClass), new MonthConfig(this.outDateStyle, this.inDateStyle, this.maxRowCount, startMonth, endMonth, firstDayOfWeek, this.hasBoundaries)));
        }
    }

    public final void updateStartMonth(@NotNull YearMonth startMonth) {
        Intrinsics.checkParameterIsNotNull((Object)startMonth, (String)"startMonth");
        YearMonth yearMonth = this.endMonth;
        if (yearMonth == null) {
            throw (Throwable)new IllegalStateException("`endMonth` is not set. Have you called `setup()`?");
        }
        this.updateMonthRange(startMonth, yearMonth);
    }

    public final void updateEndMonth(@NotNull YearMonth endMonth) {
        Intrinsics.checkParameterIsNotNull((Object)endMonth, (String)"endMonth");
        YearMonth yearMonth = this.startMonth;
        if (yearMonth == null) {
            throw (Throwable)new IllegalStateException("`startMonth` is not set. Have you called `setup()`?");
        }
        this.updateMonthRange(yearMonth, endMonth);
    }

    public final void updateMonthRange(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth) {
        Intrinsics.checkParameterIsNotNull((Object)startMonth, (String)"startMonth");
        Intrinsics.checkParameterIsNotNull((Object)endMonth, (String)"endMonth");
        this.startMonth = startMonth;
        this.endMonth = endMonth;
        MonthConfig oldConfig = this.getCalendarAdapter().getMonthConfig$com_github_kizitonwose_CalendarView();
        DayOfWeek dayOfWeek = this.firstDayOfWeek;
        if (dayOfWeek == null) {
            throw (Throwable)new IllegalStateException("`firstDayOfWeek` is not set. Have you called `setup()`?");
        }
        MonthConfig newConfig = new MonthConfig(this.outDateStyle, this.inDateStyle, this.maxRowCount, startMonth, endMonth, dayOfWeek, this.hasBoundaries);
        this.getCalendarAdapter().setMonthConfig$com_github_kizitonwose_CalendarView(newConfig);
        DiffUtil.calculateDiff((DiffUtil.Callback)new MonthRangeDiffCallback(oldConfig.getMonths$com_github_kizitonwose_CalendarView(), newConfig.getMonths$com_github_kizitonwose_CalendarView()), (boolean)false).dispatchUpdatesTo((RecyclerView.Adapter)this.getCalendarAdapter());
    }

    public CalendarView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.orientation = 1;
        this.scrollMode = ScrollMode.CONTINUOUS;
        this.inDateStyle = InDateStyle.ALL_MONTHS;
        this.outDateStyle = OutDateStyle.END_OF_ROW;
        this.maxRowCount = 6;
        this.hasBoundaries = true;
        this.autoSize = true;
        this.dayWidth = Integer.MIN_VALUE;
        this.dayHeight = Integer.MIN_VALUE;
        this.scrollListenerInternal = new RecyclerView.OnScrollListener(this){
            final /* synthetic */ CalendarView this$0;

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                if (newState == 0) {
                    CalendarView.access$getCalendarAdapter$p(this.this$0).notifyMonthScrollListenerIfNeeded();
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.pagerSnapHelper = new PagerSnapHelper();
    }

    public CalendarView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.orientation = 1;
        this.scrollMode = ScrollMode.CONTINUOUS;
        this.inDateStyle = InDateStyle.ALL_MONTHS;
        this.outDateStyle = OutDateStyle.END_OF_ROW;
        this.maxRowCount = 6;
        this.hasBoundaries = true;
        this.autoSize = true;
        this.dayWidth = Integer.MIN_VALUE;
        this.dayHeight = Integer.MIN_VALUE;
        this.scrollListenerInternal = new /* invalid duplicate definition of identical inner class */;
        this.pagerSnapHelper = new PagerSnapHelper();
        this.init(attrs, 0, 0);
    }

    public CalendarView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.orientation = 1;
        this.scrollMode = ScrollMode.CONTINUOUS;
        this.inDateStyle = InDateStyle.ALL_MONTHS;
        this.outDateStyle = OutDateStyle.END_OF_ROW;
        this.maxRowCount = 6;
        this.hasBoundaries = true;
        this.autoSize = true;
        this.dayWidth = Integer.MIN_VALUE;
        this.dayHeight = Integer.MIN_VALUE;
        this.scrollListenerInternal = new /* invalid duplicate definition of identical inner class */;
        this.pagerSnapHelper = new PagerSnapHelper();
        this.init(attrs, defStyleAttr, 0);
    }

    public static final /* synthetic */ CalendarAdapter access$getCalendarAdapter$p(CalendarView $this) {
        return $this.getCalendarAdapter();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/kizitonwose/calendarview/CalendarView$MonthRangeDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldItems", "", "Lcom/kizitonwose/calendarview/model/CalendarMonth;", "newItems", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "com.github.kizitonwose.CalendarView"})
    private static final class MonthRangeDiffCallback
    extends DiffUtil.Callback {
        private final List<CalendarMonth> oldItems;
        private final List<CalendarMonth> newItems;

        public int getOldListSize() {
            return this.oldItems.size();
        }

        public int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            return Intrinsics.areEqual((Object)this.oldItems.get(oldItemPosition), (Object)this.newItems.get(newItemPosition));
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return this.areItemsTheSame(oldItemPosition, newItemPosition);
        }

        public MonthRangeDiffCallback(@NotNull List<CalendarMonth> oldItems, @NotNull List<CalendarMonth> newItems) {
            Intrinsics.checkParameterIsNotNull(oldItems, (String)"oldItems");
            Intrinsics.checkParameterIsNotNull(newItems, (String)"newItems");
            this.oldItems = oldItems;
            this.newItems = newItems;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kizitonwose/calendarview/CalendarView$Companion;", "", "()V", "DAY_SIZE_SQUARE", "", "com.github.kizitonwose.CalendarView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

