/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendarview.ui;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendarview.CalendarView;
import com.kizitonwose.calendarview.model.CalendarDay;
import com.kizitonwose.calendarview.model.CalendarMonth;
import com.kizitonwose.calendarview.model.ScrollMode;
import com.kizitonwose.calendarview.ui.CalendarAdapter$WhenMappings;
import com.kizitonwose.calendarview.ui.CalendarAdapterKt;
import com.kizitonwose.calendarview.ui.CalendarConfig;
import com.kizitonwose.calendarview.ui.CalendarLayoutManager;
import com.kizitonwose.calendarview.ui.DayBinder;
import com.kizitonwose.calendarview.ui.DayConfig;
import com.kizitonwose.calendarview.ui.MonthViewHolder;
import com.kizitonwose.calendarview.ui.ViewContainer;
import com.kizitonwose.calendarview.utils.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.YearMonth;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BK\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010(\u001a\u0004\u0018\u00010$J\b\u0010)\u001a\u0004\u0018\u00010$J\b\u0010*\u001a\u0004\u0018\u00010$J\b\u0010+\u001a\u0004\u0018\u00010$J\u0006\u0010,\u001a\u00020-J\u0015\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020\u0004H\u0002J\b\u00103\u001a\u00020\u0004H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00102\u001a\u00020\u0004H\u0016J\u0010\u00106\u001a\u00020-2\u0006\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u0004H\u0016J&\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0016J\u0018\u0010>\u001a\u00020\u00022\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0004H\u0016J\u000e\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u00020-2\u0006\u0010/\u001a\u00020\fR\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0013R\u0010\u0010'\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/kizitonwose/calendarview/ui/MonthViewHolder;", "dayViewRes", "", "monthHeaderRes", "monthFooterRes", "config", "Lcom/kizitonwose/calendarview/ui/CalendarConfig;", "calView", "Lcom/kizitonwose/calendarview/CalendarView;", "startMonth", "Lorg/threeten/bp/YearMonth;", "endMonth", "firstDayOfWeek", "Lorg/threeten/bp/DayOfWeek;", "(IIILcom/kizitonwose/calendarview/ui/CalendarConfig;Lcom/kizitonwose/calendarview/CalendarView;Lorg/threeten/bp/YearMonth;Lorg/threeten/bp/YearMonth;Lorg/threeten/bp/DayOfWeek;)V", "bodyViewId", "getBodyViewId", "()I", "calWrapsHeight", "", "Ljava/lang/Boolean;", "footerViewId", "getFooterViewId", "setFooterViewId", "(I)V", "headerViewId", "getHeaderViewId", "setHeaderViewId", "layoutManager", "Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "getLayoutManager", "()Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "months", "", "Lcom/kizitonwose/calendarview/model/CalendarMonth;", "rootViewId", "getRootViewId", "visibleMonth", "findFirstCompletelyVisibleMonth", "findFirstVisibleMonth", "findLastCompletelyVisibleMonth", "findLastVisibleMonth", "findVisibleMonthAndNotify", "", "getAdapterPosition", "month", "getAdapterPosition$library_release", "getItem", "position", "getItemCount", "getItemId", "", "onAttachedToRecyclerView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onBindViewHolder", "holder", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "reloadDay", "day", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "reloadMonth", "library_release"})
public final class CalendarAdapter
extends RecyclerView.Adapter<MonthViewHolder> {
    private final List<CalendarMonth> months;
    private final int bodyViewId;
    private final int rootViewId;
    private int headerViewId;
    private int footerViewId;
    private CalendarMonth visibleMonth;
    private Boolean calWrapsHeight;
    private final int dayViewRes;
    private final int monthHeaderRes;
    private final int monthFooterRes;
    private final CalendarConfig config;
    private final CalendarView calView;

    public final int getBodyViewId() {
        return this.bodyViewId;
    }

    public final int getRootViewId() {
        return this.rootViewId;
    }

    public final int getHeaderViewId() {
        return this.headerViewId;
    }

    public final void setHeaderViewId(int n) {
        this.headerViewId = n;
    }

    public final int getFooterViewId() {
        return this.footerViewId;
    }

    public final void setFooterViewId(int n) {
        this.footerViewId = n;
    }

    public void onAttachedToRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        this.calView.post(new Runnable(this){
            final /* synthetic */ CalendarAdapter this$0;

            public final void run() {
                this.this$0.findVisibleMonthAndNotify();
            }
            {
                this.this$0 = calendarAdapter;
            }
        });
    }

    private final CalendarMonth getItem(int position) {
        return this.months.get(position);
    }

    public long getItemId(int position) {
        return this.getItem(position).getYearMonth().hashCode();
    }

    public int getItemCount() {
        return this.months.size();
    }

    @NotNull
    public MonthViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        ViewGroup viewGroup;
        LinearLayout $this$apply;
        boolean bl;
        boolean bl2;
        LinearLayout linearLayout;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Context context = parent.getContext();
        LinearLayout linearLayout2 = new LinearLayout(context);
        boolean bl3 = false;
        boolean bl4 = false;
        LinearLayout $this$apply2 = linearLayout2;
        boolean bl5 = false;
        $this$apply2.setOrientation(1);
        $this$apply2.setId(this.rootViewId);
        LinearLayout rootLayout = linearLayout2;
        if (this.monthHeaderRes != 0) {
            View monthHeaderView = ExtensionsKt.inflate$default((ViewGroup)rootLayout, this.monthHeaderRes, false, 2, null);
            if (monthHeaderView.getId() == -1) {
                monthHeaderView.setId(this.headerViewId);
            } else {
                this.headerViewId = monthHeaderView.getId();
            }
            rootLayout.addView(monthHeaderView);
        }
        LinearLayout linearLayout3 = new LinearLayout(context);
        bl4 = false;
        boolean bl6 = false;
        LinearLayout $this$apply3 = linearLayout3;
        boolean bl7 = false;
        $this$apply3.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        $this$apply3.setOrientation(1);
        $this$apply3.setId(this.bodyViewId);
        LinearLayout monthBodyLayout = linearLayout3;
        rootLayout.addView((View)monthBodyLayout);
        if (this.monthFooterRes != 0) {
            View monthFooterView = ExtensionsKt.inflate$default((ViewGroup)rootLayout, this.monthFooterRes, false, 2, null);
            if (monthFooterView.getId() == -1) {
                monthFooterView.setId(this.footerViewId);
            } else {
                this.footerViewId = monthFooterView.getId();
            }
            rootLayout.addView(monthFooterView);
        }
        Function1<ViewGroup, Unit> $fun$setupRoot$1 = new Function1<ViewGroup, Unit>(this){
            final /* synthetic */ CalendarAdapter this$0;

            public final void invoke(@NotNull ViewGroup root) {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                root.setPaddingRelative(CalendarAdapter.access$getCalView$p(this.this$0).getMonthPaddingStart(), CalendarAdapter.access$getCalView$p(this.this$0).getMonthPaddingTop(), CalendarAdapter.access$getCalView$p(this.this$0).getMonthPaddingEnd(), CalendarAdapter.access$getCalView$p(this.this$0).getMonthPaddingBottom());
                ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
                ViewGroup viewGroup = root;
                boolean bl = false;
                boolean bl2 = false;
                ViewGroup.MarginLayoutParams $this$apply = marginLayoutParams;
                boolean bl3 = false;
                $this$apply.bottomMargin = CalendarAdapter.access$getCalView$p(this.this$0).getMonthMarginBottom();
                $this$apply.topMargin = CalendarAdapter.access$getCalView$p(this.this$0).getMonthMarginTop();
                $this$apply.setMarginStart(CalendarAdapter.access$getCalView$p(this.this$0).getMonthMarginStart());
                $this$apply.setMarginEnd(CalendarAdapter.access$getCalView$p(this.this$0).getMonthMarginEnd());
                ViewGroup.MarginLayoutParams marginLayoutParams2 = marginLayoutParams;
                viewGroup.setLayoutParams((ViewGroup.LayoutParams)marginLayoutParams2);
            }
            {
                this.this$0 = calendarAdapter;
                super(1);
            }
        };
        if (this.config.getMonthViewClass() != null) {
            Object obj = Class.forName(this.config.getMonthViewClass()).getDeclaredConstructor(Context.class).newInstance(context);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            linearLayout = (ViewGroup)obj;
            bl2 = false;
            bl = false;
            $this$apply = linearLayout;
            boolean bl8 = false;
            $fun$setupRoot$1.invoke((ViewGroup)$this$apply);
            $this$apply.addView((View)rootLayout);
            viewGroup = linearLayout;
        } else {
            linearLayout = rootLayout;
            bl2 = false;
            bl = false;
            $this$apply = linearLayout;
            boolean bl9 = false;
            $fun$setupRoot$1.invoke((ViewGroup)$this$apply);
            viewGroup = (ViewGroup)linearLayout;
        }
        ViewGroup userRoot = viewGroup;
        DayBinder<ViewContainer> dayBinder = this.calView.getDayBinder();
        if (dayBinder == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.DayBinder<com.kizitonwose.calendarview.ui.ViewContainer>");
        }
        return new MonthViewHolder(this, userRoot, new DayConfig(this.calView.getDayWidth(), this.calView.getDayHeight(), this.dayViewRes, dayBinder), this.calView.getMonthHeaderBinder(), this.calView.getMonthFooterBinder());
    }

    public void onBindViewHolder(@NotNull MonthViewHolder holder, int position, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Intrinsics.checkParameterIsNotNull(payloads, (String)"payloads");
        if (payloads.isEmpty()) {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        } else {
            Iterable $this$forEach$iv = payloads;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Object t = it;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.model.CalendarDay");
                }
                holder.reloadDay((CalendarDay)t);
            }
        }
    }

    public void onBindViewHolder(@NotNull MonthViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        holder.bindMonth(this.getItem(position));
    }

    public final void reloadDay(@NotNull CalendarDay day) {
        YearMonth yearMonth;
        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
        switch (CalendarAdapter$WhenMappings.$EnumSwitchMapping$0[day.getOwner().ordinal()]) {
            case 1: {
                yearMonth = ExtensionsKt.getYearMonth(day.getDate());
                break;
            }
            case 2: {
                yearMonth = ExtensionsKt.getNext(ExtensionsKt.getYearMonth(day.getDate()));
                break;
            }
            case 3: {
                yearMonth = ExtensionsKt.getPrevious(ExtensionsKt.getYearMonth(day.getDate()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        YearMonth yearMonth2 = yearMonth;
        int position = this.getAdapterPosition$library_release(yearMonth2);
        if (position != -1) {
            this.notifyItemChanged(position, day);
        }
    }

    public final void reloadMonth(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.notifyItemChanged(this.getAdapterPosition$library_release(month));
    }

    public final void findVisibleMonthAndNotify() {
        int visibleItemPos = this.getLayoutManager().findFirstVisibleItemPosition();
        if (visibleItemPos != -1) {
            boolean firstVisibleMonthHasNoVisibleDateCell;
            View visibleItemView;
            CalendarMonth visibleMonth = this.months.get(visibleItemPos);
            Rect rect = new Rect();
            boolean bl = false;
            boolean bl2 = false;
            Rect rect22 = rect;
            boolean bl3 = false;
            View view = visibleItemView = this.getLayoutManager().findViewByPosition(visibleItemPos);
            if (view == null) {
                Intrinsics.throwNpe();
            }
            view.getGlobalVisibleRect(rect22);
            int visibleItemPx = CalendarAdapterKt.isVertical(this.getLayoutManager()) ? rect22.bottom - rect22.top - visibleItemView.getPaddingBottom() : rect22.right - rect22.left - visibleItemView.getPaddingRight();
            boolean bl4 = firstVisibleMonthHasNoVisibleDateCell = visibleItemPx < (CalendarAdapterKt.isVertical(this.getLayoutManager()) ? this.calView.getDayHeight() : this.calView.getDayWidth());
            if (firstVisibleMonthHasNoVisibleDateCell) {
                int nextPos = visibleItemPos + 1;
                if (CollectionsKt.getIndices((Collection)this.months).contains(nextPos)) {
                    visibleMonth = visibleMonth.getNext();
                } else {
                    return;
                }
            }
            if (Intrinsics.areEqual((Object)visibleMonth, (Object)this.visibleMonth) ^ true) {
                this.visibleMonth = visibleMonth;
                Function1<CalendarMonth, Unit> function1 = this.calView.getMonthScrollListener();
                if (function1 != null) {
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)visibleMonth);
                }
                if (this.config.getOrientation() == 0 && this.config.getScrollMode() == ScrollMode.PAGED) {
                    Integer $this$takeWhile$iv;
                    boolean calWrapsHeight;
                    boolean bl5;
                    Boolean bl6 = this.calWrapsHeight;
                    if (bl6 != null) {
                        bl5 = bl6;
                    } else {
                        bl2 = this.calView.getLayoutParams().height == -2;
                        boolean rect22 = false;
                        bl3 = false;
                        boolean it = bl2;
                        boolean bl7 = false;
                        this.calWrapsHeight = it;
                        bl5 = calWrapsHeight = bl2;
                    }
                    if (!calWrapsHeight) {
                        return;
                    }
                    RecyclerView.ViewHolder viewHolder = this.calView.findViewHolderForAdapterPosition(visibleItemPos);
                    if (viewHolder == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.MonthViewHolder");
                    }
                    MonthViewHolder visibleVH = (MonthViewHolder)viewHolder;
                    View view2 = visibleVH.getHeaderView();
                    Object $this$orZero$iv = view2 != null ? Integer.valueOf(view2.getHeight()) : null;
                    boolean $i$f$orZero = false;
                    Integer n = $this$orZero$iv;
                    $this$orZero$iv = visibleMonth.getWeekDays$library_release();
                    int n2 = n != null ? n : 0;
                    boolean $i$f$takeWhile = false;
                    ArrayList list$iv = new ArrayList();
                    Iterator iterator = $this$takeWhile$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv = iterator.next();
                        List it = (List)item$iv;
                        boolean bl8 = false;
                        Collection collection = it;
                        boolean bl9 = false;
                        if (!(!collection.isEmpty())) break;
                        list$iv.add(item$iv);
                    }
                    List list = list$iv;
                    View view3 = visibleVH.getFooterView();
                    $this$takeWhile$iv = view3 != null ? Integer.valueOf(view3.getHeight()) : null;
                    n2 = n2 + list.size() * this.calView.getDayHeight();
                    $i$f$orZero = false;
                    Object object = $this$orZero$iv;
                    int n3 = object != null ? (Integer)object : 0;
                    int newHeight = n2 + n3;
                    if (this.calView.getLayoutParams().height != newHeight) {
                        ViewGroup.LayoutParams layoutParams = this.calView.getLayoutParams();
                        CalendarView calendarView = this.calView;
                        boolean bl10 = false;
                        boolean bl11 = false;
                        ViewGroup.LayoutParams $this$apply = layoutParams;
                        boolean bl12 = false;
                        $this$apply.height = newHeight;
                        ViewGroup.LayoutParams layoutParams2 = layoutParams;
                        calendarView.setLayoutParams(layoutParams2);
                    }
                }
            }
        }
    }

    public final int getAdapterPosition$library_release(@NotNull YearMonth month) {
        int n;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
            List<CalendarMonth> $this$indexOfFirst$iv = this.months;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<CalendarMonth> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                CalendarMonth item$iv;
                CalendarMonth it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getYearMonth(), (Object)month)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private final CalendarLayoutManager getLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.calView.getLayoutManager();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarLayoutManager");
        }
        return (CalendarLayoutManager)layoutManager;
    }

    @Nullable
    public final CalendarMonth findFirstVisibleMonth() {
        return (CalendarMonth)CollectionsKt.getOrNull(this.months, (int)this.getLayoutManager().findFirstVisibleItemPosition());
    }

    @Nullable
    public final CalendarMonth findLastVisibleMonth() {
        return (CalendarMonth)CollectionsKt.getOrNull(this.months, (int)this.getLayoutManager().findLastVisibleItemPosition());
    }

    @Nullable
    public final CalendarMonth findFirstCompletelyVisibleMonth() {
        return (CalendarMonth)CollectionsKt.getOrNull(this.months, (int)this.getLayoutManager().findFirstCompletelyVisibleItemPosition());
    }

    @Nullable
    public final CalendarMonth findLastCompletelyVisibleMonth() {
        return (CalendarMonth)CollectionsKt.getOrNull(this.months, (int)this.getLayoutManager().findLastCompletelyVisibleItemPosition());
    }

    public CalendarAdapter(@LayoutRes int dayViewRes, @LayoutRes int monthHeaderRes, @LayoutRes int monthFooterRes, @NotNull CalendarConfig config, @NotNull CalendarView calView, @NotNull YearMonth startMonth, @NotNull YearMonth endMonth, @NotNull DayOfWeek firstDayOfWeek) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)((Object)calView), (String)"calView");
        Intrinsics.checkParameterIsNotNull((Object)startMonth, (String)"startMonth");
        Intrinsics.checkParameterIsNotNull((Object)endMonth, (String)"endMonth");
        Intrinsics.checkParameterIsNotNull((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        this.dayViewRes = dayViewRes;
        this.monthHeaderRes = monthHeaderRes;
        this.monthFooterRes = monthFooterRes;
        this.config = config;
        this.calView = calView;
        CalendarAdapter calendarAdapter = this;
        boolean bl = false;
        calendarAdapter.months = list = (List)new ArrayList();
        this.bodyViewId = View.generateViewId();
        this.rootViewId = View.generateViewId();
        this.headerViewId = View.generateViewId();
        this.footerViewId = View.generateViewId();
        this.setHasStableIds(true);
        CalendarMonth startCalMonth = new CalendarMonth(startMonth, this.config, firstDayOfWeek);
        CalendarMonth endCalMonth = new CalendarMonth(endMonth, this.config, firstDayOfWeek);
        CalendarMonth lastCalMonth = startCalMonth;
        while (lastCalMonth.compareTo(endCalMonth) < 0) {
            this.months.add(lastCalMonth);
            lastCalMonth = lastCalMonth.getNext();
        }
        this.months.add(endCalMonth);
    }

    public static final /* synthetic */ CalendarView access$getCalView$p(CalendarAdapter $this) {
        return $this.calView;
    }
}

