/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendarview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.LayoutRes;
import androidx.annotation.Px;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.jakewharton.threetenabp.AndroidThreeTen;
import com.kizitonwose.calendarview.R;
import com.kizitonwose.calendarview.model.CalendarDay;
import com.kizitonwose.calendarview.model.CalendarMonth;
import com.kizitonwose.calendarview.model.DayOwner;
import com.kizitonwose.calendarview.model.OutDateStyle;
import com.kizitonwose.calendarview.model.ScrollMode;
import com.kizitonwose.calendarview.ui.CalendarAdapter;
import com.kizitonwose.calendarview.ui.CalendarConfig;
import com.kizitonwose.calendarview.ui.CalendarLayoutManager;
import com.kizitonwose.calendarview.ui.DayBinder;
import com.kizitonwose.calendarview.ui.MonthHeaderFooterBinder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.LocalDate;
import org.threeten.bp.YearMonth;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 z2\u00020\u0001:\u0001zBU\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0014J\b\u0010Y\u001a\u0004\u0018\u00010QJ \u0010Z\u001a\u00020R2\u0006\u0010[\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u0005H\u0002J\b\u0010]\u001a\u00020RH\u0002J\u0006\u0010^\u001a\u00020RJ\u000e\u0010_\u001a\u00020R2\u0006\u0010`\u001a\u00020aJ\u001f\u0010b\u001a\u00020R2\u0012\u0010c\u001a\n\u0012\u0006\b\u0001\u0012\u00020a0d\"\u00020a\u00a2\u0006\u0002\u0010eJ\u000e\u0010f\u001a\u00020R2\u0006\u0010g\u001a\u00020hJ\u000e\u0010i\u001a\u00020R2\u0006\u0010j\u001a\u00020kJ\u0018\u0010l\u001a\u00020R2\u0006\u0010m\u001a\u00020\u00052\u0006\u0010n\u001a\u00020\u0005H\u0014J\u0010\u0010o\u001a\u00020\u00052\u0006\u0010p\u001a\u00020\u0005H\u0002J\u000e\u0010q\u001a\u00020R2\u0006\u0010`\u001a\u00020aJ\u000e\u0010r\u001a\u00020R2\u0006\u0010j\u001a\u00020kJ\u001e\u0010s\u001a\u00020R2\u0006\u0010t\u001a\u00020k2\u0006\u0010u\u001a\u00020k2\u0006\u0010v\u001a\u00020wJ\u000e\u0010x\u001a\u00020R2\u0006\u0010`\u001a\u00020aJ\u000e\u0010y\u001a\u00020R2\u0006\u0010j\u001a\u00020kR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR0\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R&\u0010&\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010+\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R0\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010.2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u00010.2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00107\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010(\"\u0004\b9\u0010*R&\u0010:\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010(\"\u0004\b<\u0010*R&\u0010=\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010(\"\u0004\b?\u0010*R&\u0010@\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010(\"\u0004\bB\u0010*R&\u0010C\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010(\"\u0004\bE\u0010*R&\u0010F\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010(\"\u0004\bH\u0010*R&\u0010I\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010(\"\u0004\bK\u0010*R&\u0010L\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010(\"\u0004\bN\u0010*R.\u0010O\u001a\u0016\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020R\u0018\u00010Pj\u0004\u0018\u0001`SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lcom/kizitonwose/calendarview/CalendarView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "dayViewRes", "", "monthHeaderRes", "monthFooterRes", "orientation", "scrollMode", "Lcom/kizitonwose/calendarview/model/ScrollMode;", "outDateStyle", "Lcom/kizitonwose/calendarview/model/OutDateStyle;", "monthViewClass", "", "(Landroid/content/Context;ILjava/lang/Integer;Ljava/lang/Integer;ILcom/kizitonwose/calendarview/model/ScrollMode;Lcom/kizitonwose/calendarview/model/OutDateStyle;Ljava/lang/String;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoSize", "", "calendarAdapter", "Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "getCalendarAdapter", "()Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "calendarLayoutManager", "Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "getCalendarLayoutManager", "()Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "value", "Lcom/kizitonwose/calendarview/ui/DayBinder;", "dayBinder", "getDayBinder", "()Lcom/kizitonwose/calendarview/ui/DayBinder;", "setDayBinder", "(Lcom/kizitonwose/calendarview/ui/DayBinder;)V", "dayHeight", "getDayHeight", "()I", "setDayHeight", "(I)V", "dayWidth", "getDayWidth", "setDayWidth", "Lcom/kizitonwose/calendarview/ui/MonthHeaderFooterBinder;", "monthFooterBinder", "getMonthFooterBinder", "()Lcom/kizitonwose/calendarview/ui/MonthHeaderFooterBinder;", "setMonthFooterBinder", "(Lcom/kizitonwose/calendarview/ui/MonthHeaderFooterBinder;)V", "monthHeaderBinder", "getMonthHeaderBinder", "setMonthHeaderBinder", "monthMarginBottom", "getMonthMarginBottom", "setMonthMarginBottom", "monthMarginEnd", "getMonthMarginEnd", "setMonthMarginEnd", "monthMarginStart", "getMonthMarginStart", "setMonthMarginStart", "monthMarginTop", "getMonthMarginTop", "setMonthMarginTop", "monthPaddingBottom", "getMonthPaddingBottom", "setMonthPaddingBottom", "monthPaddingEnd", "getMonthPaddingEnd", "setMonthPaddingEnd", "monthPaddingStart", "getMonthPaddingStart", "setMonthPaddingStart", "monthPaddingTop", "getMonthPaddingTop", "setMonthPaddingTop", "monthScrollListener", "Lkotlin/Function1;", "Lcom/kizitonwose/calendarview/model/CalendarMonth;", "", "Lcom/kizitonwose/calendarview/ui/MonthScrollListener;", "getMonthScrollListener", "()Lkotlin/jvm/functions/Function1;", "setMonthScrollListener", "(Lkotlin/jvm/functions/Function1;)V", "sizedInternally", "getFirstVisibleMonth", "init", "attributeSet", "defStyleRes", "invalidateViewHolders", "notifyCalendarChanged", "notifyDateChanged", "date", "Lorg/threeten/bp/LocalDate;", "notifyDatesChanged", "dates", "", "([Lorg/threeten/bp/LocalDate;)V", "notifyDayChanged", "day", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "notifyMonthChanged", "month", "Lorg/threeten/bp/YearMonth;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "resNotZero", "resource", "scrollToDate", "scrollToMonth", "setup", "startMonth", "endMonth", "firstDayOfWeek", "Lorg/threeten/bp/DayOfWeek;", "smoothScrollToDate", "smoothScrollToMonth", "Companion", "library_release"})
public final class CalendarView
extends RecyclerView {
    @Nullable
    private DayBinder<?> dayBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthHeaderBinder;
    @Nullable
    private MonthHeaderFooterBinder<?> monthFooterBinder;
    @Nullable
    private Function1<? super CalendarMonth, Unit> monthScrollListener;
    private int dayViewRes;
    private int monthHeaderRes;
    private int monthFooterRes;
    private int orientation;
    private ScrollMode scrollMode;
    private OutDateStyle outDateStyle;
    private String monthViewClass;
    private boolean autoSize;
    private boolean sizedInternally;
    @Px
    private int dayWidth;
    @Px
    private int dayHeight;
    @Px
    private int monthPaddingStart;
    @Px
    private int monthPaddingEnd;
    @Px
    private int monthPaddingTop;
    @Px
    private int monthPaddingBottom;
    @Px
    private int monthMarginStart;
    @Px
    private int monthMarginEnd;
    @Px
    private int monthMarginTop;
    @Px
    private int monthMarginBottom;
    public static final int DAY_SIZE_SQUARE = Integer.MIN_VALUE;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final DayBinder<?> getDayBinder() {
        return this.dayBinder;
    }

    public final void setDayBinder(@Nullable DayBinder<?> value) {
        DayBinder<?> oldValue = this.dayBinder;
        this.dayBinder = value;
        if (oldValue != null) {
            this.invalidateViewHolders();
        }
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthHeaderBinder() {
        return this.monthHeaderBinder;
    }

    public final void setMonthHeaderBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        MonthHeaderFooterBinder<?> oldValue = this.monthHeaderBinder;
        this.monthHeaderBinder = value;
        if (oldValue != null) {
            this.invalidateViewHolders();
        }
    }

    @Nullable
    public final MonthHeaderFooterBinder<?> getMonthFooterBinder() {
        return this.monthFooterBinder;
    }

    public final void setMonthFooterBinder(@Nullable MonthHeaderFooterBinder<?> value) {
        MonthHeaderFooterBinder<?> oldValue = this.monthFooterBinder;
        this.monthFooterBinder = value;
        if (oldValue != null) {
            this.invalidateViewHolders();
        }
    }

    @Nullable
    public final Function1<CalendarMonth, Unit> getMonthScrollListener() {
        return this.monthScrollListener;
    }

    public final void setMonthScrollListener(@Nullable Function1<? super CalendarMonth, Unit> function1) {
        this.monthScrollListener = function1;
    }

    private final void init(AttributeSet attributeSet, int defStyleAttr, int defStyleRes) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        this.dayViewRes = this.resNotZero(a.getResourceId(R.styleable.CalendarView_cv_dayViewResource, this.dayViewRes));
        this.monthHeaderRes = a.getResourceId(R.styleable.CalendarView_cv_monthHeaderResource, this.monthHeaderRes);
        this.monthFooterRes = a.getResourceId(R.styleable.CalendarView_cv_monthFooterResource, this.monthFooterRes);
        this.orientation = a.getInt(R.styleable.CalendarView_cv_orientation, this.orientation);
        this.scrollMode = ScrollMode.values()[a.getInt(R.styleable.CalendarView_cv_scrollMode, this.scrollMode.ordinal())];
        this.outDateStyle = OutDateStyle.values()[a.getInt(R.styleable.CalendarView_cv_outDateStyle, this.outDateStyle.ordinal())];
        this.monthViewClass = a.getString(R.styleable.CalendarView_cv_monthViewClass);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.autoSize && !this.isInEditMode()) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (widthMode == 0 && heightMode == 0) {
                throw (Throwable)new UnsupportedOperationException("Cannot calculate the values for day Width/Height with the current configuration.");
            }
            int squareSize = (int)((double)((float)(widthSize - (this.monthPaddingStart + this.monthPaddingEnd)) / 7.0f) + 0.5);
            if (this.dayWidth != squareSize || this.dayHeight != squareSize) {
                this.sizedInternally = true;
                this.setDayWidth(squareSize);
                this.setDayHeight(squareSize);
                this.sizedInternally = false;
                this.invalidateViewHolders();
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public final int getDayWidth() {
        return this.dayWidth;
    }

    public final void setDayWidth(int value) {
        this.dayWidth = value;
        if (!this.sizedInternally) {
            this.autoSize = value == Integer.MIN_VALUE;
            this.invalidateViewHolders();
        }
    }

    public final int getDayHeight() {
        return this.dayHeight;
    }

    public final void setDayHeight(int value) {
        this.dayHeight = value;
        if (!this.sizedInternally) {
            this.autoSize = value == Integer.MIN_VALUE;
            this.invalidateViewHolders();
        }
    }

    public final int getMonthPaddingStart() {
        return this.monthPaddingStart;
    }

    public final void setMonthPaddingStart(int value) {
        this.monthPaddingStart = value;
        this.invalidateViewHolders();
    }

    public final int getMonthPaddingEnd() {
        return this.monthPaddingEnd;
    }

    public final void setMonthPaddingEnd(int value) {
        this.monthPaddingEnd = value;
        this.invalidateViewHolders();
    }

    public final int getMonthPaddingTop() {
        return this.monthPaddingTop;
    }

    public final void setMonthPaddingTop(int value) {
        this.monthPaddingTop = value;
        this.invalidateViewHolders();
    }

    public final int getMonthPaddingBottom() {
        return this.monthPaddingBottom;
    }

    public final void setMonthPaddingBottom(int value) {
        this.monthPaddingBottom = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginStart() {
        return this.monthMarginStart;
    }

    public final void setMonthMarginStart(int value) {
        this.monthMarginStart = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginEnd() {
        return this.monthMarginEnd;
    }

    public final void setMonthMarginEnd(int value) {
        this.monthMarginEnd = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginTop() {
        return this.monthMarginTop;
    }

    public final void setMonthMarginTop(int value) {
        this.monthMarginTop = value;
        this.invalidateViewHolders();
    }

    public final int getMonthMarginBottom() {
        return this.monthMarginBottom;
    }

    public final void setMonthMarginBottom(int value) {
        this.monthMarginBottom = value;
        this.invalidateViewHolders();
    }

    private final CalendarLayoutManager getCalendarLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarLayoutManager");
        }
        return (CalendarLayoutManager)layoutManager;
    }

    private final CalendarAdapter getCalendarAdapter() {
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarAdapter");
        }
        return (CalendarAdapter)adapter;
    }

    private final void invalidateViewHolders() {
        block1: {
            if (this.getAdapter() == null || this.getLayoutManager() == null) {
                return;
            }
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            Parcelable state = layoutManager != null ? layoutManager.onSaveInstanceState() : null;
            this.setAdapter(this.getAdapter());
            RecyclerView.LayoutManager layoutManager2 = this.getLayoutManager();
            if (layoutManager2 == null) break block1;
            layoutManager2.onRestoreInstanceState(state);
        }
    }

    public final void scrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.getCalendarLayoutManager().scrollToMonth(month);
    }

    public final void smoothScrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.getCalendarLayoutManager().smoothScrollToMonth(month);
    }

    public final void scrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        this.getCalendarLayoutManager().scrollToDate(date);
    }

    public final void smoothScrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        this.getCalendarLayoutManager().smoothScrollToDate(date);
    }

    public final void notifyDayChanged(@NotNull CalendarDay day) {
        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
        this.getCalendarAdapter().reloadDay(day);
    }

    public final void notifyDateChanged(@NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        this.notifyDayChanged(new CalendarDay(date, DayOwner.THIS_MONTH));
    }

    public final void notifyDatesChanged(LocalDate ... dates) {
        Intrinsics.checkParameterIsNotNull((Object)dates, (String)"dates");
        LocalDate[] $this$forEach$iv = dates;
        boolean $i$f$forEach = false;
        LocalDate[] localDateArray = $this$forEach$iv;
        int n = localDateArray.length;
        for (int i = 0; i < n; ++i) {
            LocalDate element$iv;
            LocalDate it = element$iv = localDateArray[i];
            boolean bl = false;
            this.notifyDateChanged(it);
        }
    }

    public final void notifyMonthChanged(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.getCalendarAdapter().reloadMonth(month);
    }

    public final void notifyCalendarChanged() {
        this.getCalendarAdapter().notifyDataSetChanged();
    }

    @Nullable
    public final CalendarMonth getFirstVisibleMonth() {
        return this.getCalendarAdapter().getFirstVisibleMonth();
    }

    public final void setup(@NotNull YearMonth startMonth, @NotNull YearMonth endMonth, @NotNull DayOfWeek firstDayOfWeek) {
        Intrinsics.checkParameterIsNotNull((Object)startMonth, (String)"startMonth");
        Intrinsics.checkParameterIsNotNull((Object)endMonth, (String)"endMonth");
        Intrinsics.checkParameterIsNotNull((Object)firstDayOfWeek, (String)"firstDayOfWeek");
        AndroidThreeTen.init((Context)this.getContext());
        CalendarConfig config = new CalendarConfig(this.outDateStyle, this.scrollMode, this.orientation, this.monthViewClass);
        if (this.getLayoutManager() == null) {
            this.setClipToPadding(false);
            this.setLayoutManager((RecyclerView.LayoutManager)new CalendarLayoutManager(this, config));
            if (this.scrollMode == ScrollMode.PAGED) {
                new PagerSnapHelper().attachToRecyclerView((RecyclerView)this);
            }
            this.addOnScrollListener(new RecyclerView.OnScrollListener(this){
                final /* synthetic */ CalendarView this$0;

                public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                }

                public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                    if (newState == 0) {
                        CalendarView.access$getCalendarAdapter$p(this.this$0).findVisibleMonthAndNotify();
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        this.setAdapter(new CalendarAdapter(this.dayViewRes, this.monthHeaderRes, this.monthFooterRes, config, this, startMonth, endMonth, firstDayOfWeek));
    }

    private final int resNotZero(int resource) {
        if (resource == 0) {
            throw (Throwable)new IllegalArgumentException("'dayViewResource' attribute not provided.");
        }
        return resource;
    }

    public CalendarView(@NotNull Context context, @LayoutRes int dayViewRes, @LayoutRes @Nullable Integer monthHeaderRes, @LayoutRes @Nullable Integer monthFooterRes, int orientation, @NotNull ScrollMode scrollMode, @NotNull OutDateStyle outDateStyle, @Nullable String monthViewClass) {
        int n;
        Integer $this$orZero$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scrollMode), (String)"scrollMode");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outDateStyle), (String)"outDateStyle");
        super(context);
        this.orientation = 1;
        this.scrollMode = ScrollMode.CONTINUOUS;
        this.outDateStyle = OutDateStyle.END_OF_ROW;
        this.autoSize = true;
        this.dayWidth = Integer.MIN_VALUE;
        this.dayHeight = Integer.MIN_VALUE;
        this.dayViewRes = this.resNotZero(dayViewRes);
        Integer n2 = monthHeaderRes;
        CalendarView calendarView = this;
        boolean $i$f$orZero = false;
        void v0 = $this$orZero$iv;
        calendarView.monthHeaderRes = n = v0 != null ? v0.intValue() : 0;
        $this$orZero$iv = monthFooterRes;
        calendarView = this;
        $i$f$orZero = false;
        Integer n3 = $this$orZero$iv;
        calendarView.monthFooterRes = n = n3 != null ? n3 : 0;
        this.orientation = orientation;
        this.scrollMode = scrollMode;
        this.outDateStyle = outDateStyle;
        this.monthViewClass = monthViewClass;
    }

    public /* synthetic */ CalendarView(Context context, int n, Integer n2, Integer n3, int n4, ScrollMode scrollMode, OutDateStyle outDateStyle, String string, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n2 = null;
        }
        if ((n5 & 8) != 0) {
            n3 = null;
        }
        if ((n5 & 0x80) != 0) {
            string = null;
        }
        this(context, n, n2, n3, n4, scrollMode, outDateStyle, string);
    }

    public CalendarView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.orientation = 1;
        this.scrollMode = ScrollMode.CONTINUOUS;
        this.outDateStyle = OutDateStyle.END_OF_ROW;
        this.autoSize = true;
        this.dayWidth = Integer.MIN_VALUE;
        this.dayHeight = Integer.MIN_VALUE;
        this.init(attrs, 0, 0);
    }

    public CalendarView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.orientation = 1;
        this.scrollMode = ScrollMode.CONTINUOUS;
        this.outDateStyle = OutDateStyle.END_OF_ROW;
        this.autoSize = true;
        this.dayWidth = Integer.MIN_VALUE;
        this.dayHeight = Integer.MIN_VALUE;
        this.init(attrs, defStyleAttr, 0);
    }

    public static final /* synthetic */ CalendarAdapter access$getCalendarAdapter$p(CalendarView $this) {
        return $this.getCalendarAdapter();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/kizitonwose/calendarview/CalendarView$Companion;", "", "()V", "DAY_SIZE_SQUARE", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

