/*
 * Decompiled with CFR 0.152.
 */
package com.github.keran213539.commonOkHttp;

import com.github.keran213539.commonOkHttp.CommonOkHttpClient;
import com.github.keran213539.commonOkHttp.utils.HttpsUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;

public class CommonOkHttpClientBuilder {
    private long readTimeoutMilliSeconds;
    private long writeTimeout;
    private long connectTimeout;
    boolean isUnSafe;
    boolean isCheckHostname;
    private List<URL> certificateFilePaths;
    private String pkcsFile;
    private String pkcsFilePwd;

    public CommonOkHttpClientBuilder() {
        this.readTimeoutMilliSeconds = 100000L;
        this.writeTimeout = 10000L;
        this.connectTimeout = 15000L;
        this.isUnSafe = false;
        this.isCheckHostname = true;
        this.certificateFilePaths = null;
        this.pkcsFile = null;
        this.pkcsFilePwd = null;
    }

    public CommonOkHttpClientBuilder(long readTimeoutMilliSeconds, long writeTimeout, long connectTimeout, boolean isUnSafe, boolean isCheckHostname, List<URL> certificateFilePaths, String pkcsFile, String pkcsFilePwd) {
        this.readTimeoutMilliSeconds = readTimeoutMilliSeconds;
        this.writeTimeout = writeTimeout;
        this.connectTimeout = connectTimeout;
        this.isUnSafe = isUnSafe;
        this.isCheckHostname = isCheckHostname;
        this.certificateFilePaths = certificateFilePaths;
        this.pkcsFile = pkcsFile;
        this.pkcsFilePwd = pkcsFilePwd;
    }

    public CommonOkHttpClientBuilder(long readTimeoutMilliSeconds, long writeTimeout, long connectTimeout, boolean isUnSafe, boolean isCheckHostname, Resource[] certificateFilePaths, String pkcsFile, String pkcsFilePwd) {
        this.readTimeoutMilliSeconds = readTimeoutMilliSeconds;
        this.writeTimeout = writeTimeout;
        this.connectTimeout = connectTimeout;
        this.isUnSafe = isUnSafe;
        this.isCheckHostname = isCheckHostname;
        this.certificateFilePaths(certificateFilePaths);
        this.pkcsFile = pkcsFile;
        this.pkcsFilePwd = pkcsFilePwd;
    }

    public CommonOkHttpClientBuilder readTimeoutMilliSeconds(long readTimeoutMilliSeconds) {
        this.readTimeoutMilliSeconds = readTimeoutMilliSeconds;
        return this;
    }

    public CommonOkHttpClientBuilder writeTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public CommonOkHttpClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public CommonOkHttpClientBuilder unSafe(boolean isUnSafe) {
        this.isUnSafe = isUnSafe;
        return this;
    }

    public CommonOkHttpClientBuilder checkHostname(boolean isCheckHostname) {
        this.isCheckHostname = isCheckHostname;
        return this;
    }

    public CommonOkHttpClientBuilder certificateFilePaths(Resource[] certificateFilePathsArr) {
        if (certificateFilePathsArr != null) {
            this.certificateFilePaths = new ArrayList<URL>(certificateFilePathsArr.length);
            for (Resource certificateFilePath : certificateFilePathsArr) {
                try {
                    this.certificateFilePaths.add(certificateFilePath.getURL());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    public CommonOkHttpClientBuilder certificateFilePaths(List<URL> certificateFilePaths) {
        this.certificateFilePaths = certificateFilePaths;
        return this;
    }

    public CommonOkHttpClientBuilder pkcs(String pkcsFile, String pkcsFilePwd) {
        this.pkcsFile = pkcsFile;
        this.pkcsFilePwd = pkcsFilePwd;
        return this;
    }

    public CommonOkHttpClient build() {
        HttpsUtils.SSLParams sslParams = null;
        if (this.isUnSafe) {
            sslParams = HttpsUtils.getSslSocketFactory(this.isUnSafe);
        } else if (this.certificateFilePaths != null && this.certificateFilePaths.size() > 0) {
            ArrayList isList = new ArrayList();
            this.certificateFilePaths.stream().forEach(certificateFilePath -> {
                try {
                    isList.add(new FileInputStream(certificateFilePath.getFile()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            sslParams = HttpsUtils.getSslSocketFactory(this.isCheckHostname, isList.toArray(new InputStream[0]));
        } else {
            sslParams = StringUtils.isNotBlank((String)this.pkcsFile) && StringUtils.isNotBlank((String)this.pkcsFilePwd) ? HttpsUtils.getSslSocketFactory(this.pkcsFile, this.pkcsFilePwd) : HttpsUtils.getSslSocketFactory(this.isUnSafe);
        }
        return new CommonOkHttpClient(this.readTimeoutMilliSeconds, this.writeTimeout, this.connectTimeout, sslParams);
    }
}

