/*
 * Decompiled with CFR 0.152.
 */
package com.github.kalaganov.circular;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import com.github.kalaganov.circular.BackgroundStyle;
import com.github.kalaganov.circular.DefaultProgressFormatter;
import com.github.kalaganov.circular.PercentProgressFormatter;
import com.github.kalaganov.circular.ProgressFormatter;
import com.github.kalaganov.circular.ProgressStyle;
import com.github.kalaganov.circular.ProgressView;
import com.github.kalaganov.circular.R;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0002J.\u0010\u0083\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\n2\u0007\u0010\u0087\u0001\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J7\u0010\u0088\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020\n2\u0007\u0010\u0087\u0001\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0007\u0010\u0089\u0001\u001a\u000207H\u0002J\u0012\u0010\u008a\u0001\u001a\u0002072\u0007\u0010\u008b\u0001\u001a\u00020>H\u0002J\u001a\u0010\u008c\u0001\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0007\u0010\u008d\u0001\u001a\u00020\u0007H\u0002J\u0014\u0010\u008e\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0014J\u001c\u0010\u008f\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u00072\u0007\u0010\u0091\u0001\u001a\u00020\u0007H\u0014J\u0013\u0010\u0092\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0093\u0001\u001a\u00020\u0007H\u0016J\u0013\u0010\u0094\u0001\u001a\u00030\u0080\u00012\u0007\u0010\u0095\u0001\u001a\u00020.H\u0016J\u0013\u0010\u0096\u0001\u001a\u00030\u0080\u00012\t\u0010\u0097\u0001\u001a\u0004\u0018\u000105J\u0013\u0010\u0098\u0001\u001a\u00030\u0080\u00012\t\u0010\u0097\u0001\u001a\u0004\u0018\u000105R\u0016\u0010\t\u001a\u00020\n8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u0017R$\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u0017R$\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\f\"\u0004\b$\u0010\u0017R$\u0010&\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010+\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010!R$\u0010/\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00108\u001a\u0002098BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b:\u0010;R(\u0010?\u001a\u0004\u0018\u00010>2\b\u0010\u0013\u001a\u0004\u0018\u00010>@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001b\u0010D\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010=\u001a\u0004\bE\u0010FR$\u0010H\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010\u0012\"\u0004\bJ\u0010!R\u000e\u0010K\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010L\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bN\u0010=\u001a\u0004\bM\u0010FR*\u0010P\u001a\u0004\u0018\u00010O2\b\u0010\u0013\u001a\u0004\u0018\u00010O8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR$\u0010U\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bV\u0010\u0012\"\u0004\bW\u0010!R$\u0010X\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010\f\"\u0004\bZ\u0010\u0017R\u000e\u0010[\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\\\u001a\u00020]8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R\u0016\u0010`\u001a\u00020\n8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\fR\u000e\u0010b\u001a\u00020cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010d\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\f\"\u0004\bf\u0010\u0017R$\u0010g\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u00101\"\u0004\bi\u00103R$\u0010j\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bk\u0010\f\"\u0004\bl\u0010\u0017R$\u0010n\u001a\u00020m2\u0006\u0010\u0013\u001a\u00020m@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010p\"\u0004\bq\u0010rR\u0016\u0010s\u001a\u00020\n8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010\fR$\u0010u\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bv\u00101\"\u0004\bw\u00103R$\u0010x\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u00101\"\u0004\bz\u00103R$\u0010{\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u00101\"\u0004\b}\u00103R\u000e\u0010~\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0099\u0001"}, d2={"Lcom/github/kalaganov/circular/ProgressView;", "Landroid/support/v7/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "angle", "", "getAngle", "()F", "backgroundPaint", "Landroid/graphics/Paint;", "defaultSize", "maxPadding", "getMaxPadding", "()I", "value", "maxProgressValue", "getMaxProgressValue", "setMaxProgressValue", "(F)V", "minProgressValue", "getMinProgressValue", "setMinProgressValue", "progress", "getProgress", "setProgress", "progressBackgroundColor", "getProgressBackgroundColor", "setProgressBackgroundColor", "(I)V", "progressBackgroundStrokeWidth", "getProgressBackgroundStrokeWidth", "setProgressBackgroundStrokeWidth", "Lcom/github/kalaganov/circular/BackgroundStyle;", "progressBackgroundStyle", "getProgressBackgroundStyle", "()Lcom/github/kalaganov/circular/BackgroundStyle;", "setProgressBackgroundStyle", "(Lcom/github/kalaganov/circular/BackgroundStyle;)V", "progressColor", "getProgressColor", "setProgressColor", "", "progressCounterClockwise", "getProgressCounterClockwise", "()Z", "setProgressCounterClockwise", "(Z)V", "progressFormatter", "Lcom/github/kalaganov/circular/ProgressFormatter;", "progressOnTipBitmap", "Landroid/graphics/Bitmap;", "progressOnTipBounds", "Landroid/graphics/Rect;", "getProgressOnTipBounds", "()Landroid/graphics/Rect;", "progressOnTipBounds$delegate", "Lkotlin/Lazy;", "Landroid/graphics/drawable/Drawable;", "progressOnTipDrawable", "getProgressOnTipDrawable", "()Landroid/graphics/drawable/Drawable;", "setProgressOnTipDrawable", "(Landroid/graphics/drawable/Drawable;)V", "progressOnTipDrawablePaint", "getProgressOnTipDrawablePaint", "()Landroid/graphics/Paint;", "progressOnTipDrawablePaint$delegate", "progressOnTipDrawableRes", "getProgressOnTipDrawableRes", "setProgressOnTipDrawableRes", "progressOnTipFormatter", "progressOnTipPaint", "getProgressOnTipPaint", "progressOnTipPaint$delegate", "", "progressOnTipText", "getProgressOnTipText", "()Ljava/lang/String;", "setProgressOnTipText", "(Ljava/lang/String;)V", "progressOnTipTextColor", "getProgressOnTipTextColor", "setProgressOnTipTextColor", "progressOnTipTextSize", "getProgressOnTipTextSize", "setProgressOnTipTextSize", "progressPaint", "progressPaintCapStyle", "Landroid/graphics/Paint$Cap;", "getProgressPaintCapStyle", "()Landroid/graphics/Paint$Cap;", "progressPercent", "getProgressPercent", "progressRectF", "Landroid/graphics/RectF;", "progressStartAngle", "getProgressStartAngle", "setProgressStartAngle", "progressStrokeCapRound", "getProgressStrokeCapRound", "setProgressStrokeCapRound", "progressStrokeWidth", "getProgressStrokeWidth", "setProgressStrokeWidth", "Lcom/github/kalaganov/circular/ProgressStyle;", "progressStyle", "getProgressStyle", "()Lcom/github/kalaganov/circular/ProgressStyle;", "setProgressStyle", "(Lcom/github/kalaganov/circular/ProgressStyle;)V", "radius", "getRadius", "showProgressAsPercentage", "getShowProgressAsPercentage", "setShowProgressAsPercentage", "showProgressOnTip", "getShowProgressOnTip", "setShowProgressOnTip", "showProgressOnTipAsPercentage", "getShowProgressOnTipAsPercentage", "setShowProgressOnTipAsPercentage", "showTextInsteadProgress", "applyAttrs", "", "typedArray", "Landroid/content/res/TypedArray;", "applyProgressOnTip", "canvas", "Landroid/graphics/Canvas;", "center", "r", "applyProgressOnTipBitmap", "bitmap", "drawableToBitmap", "drawable", "measureDimension", "mode", "onDraw", "onMeasure", "w", "h", "setGravity", "gravity", "setIncludeFontPadding", "b", "setProgressFormatter", "formatter", "setProgressOnTipFormatter", "circularprogressview_release"})
public final class ProgressView
extends AppCompatTextView {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final int defaultSize;
    private final Paint backgroundPaint;
    private final Paint progressPaint;
    private final Lazy progressOnTipDrawablePaint$delegate;
    private final Lazy progressOnTipPaint$delegate;
    private final Lazy progressOnTipBounds$delegate;
    private final RectF progressRectF;
    private Bitmap progressOnTipBitmap;
    private ProgressFormatter progressFormatter;
    private ProgressFormatter progressOnTipFormatter;
    private boolean showTextInsteadProgress;
    @NotNull
    private BackgroundStyle progressBackgroundStyle;
    @NotNull
    private ProgressStyle progressStyle;
    private float progressStartAngle;
    private float minProgressValue;
    private float maxProgressValue;
    private float progress;
    private boolean progressCounterClockwise;
    private boolean progressStrokeCapRound;
    private boolean showProgressOnTip;
    @Nullable
    private String progressOnTipText;
    @Nullable
    private Drawable progressOnTipDrawable;
    private int progressOnTipDrawableRes;
    private boolean showProgressAsPercentage;
    private boolean showProgressOnTipAsPercentage;
    private Paint.Cap progressPaintCapStyle;
    private float radius;
    private float angle;
    private float progressPercent;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ProgressView.class), "progressOnTipDrawablePaint", "getProgressOnTipDrawablePaint()Landroid/graphics/Paint;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ProgressView.class), "progressOnTipPaint", "getProgressOnTipPaint()Landroid/graphics/Paint;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ProgressView.class), "progressOnTipBounds", "getProgressOnTipBounds()Landroid/graphics/Rect;"))};
    }

    private final Paint getProgressOnTipDrawablePaint() {
        Lazy lazy = this.progressOnTipDrawablePaint$delegate;
        ProgressView progressView = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Paint)lazy.getValue();
    }

    private final Paint getProgressOnTipPaint() {
        Lazy lazy = this.progressOnTipPaint$delegate;
        ProgressView progressView = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (Paint)lazy.getValue();
    }

    private final Rect getProgressOnTipBounds() {
        Lazy lazy = this.progressOnTipBounds$delegate;
        ProgressView progressView = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (Rect)lazy.getValue();
    }

    @NotNull
    public final BackgroundStyle getProgressBackgroundStyle() {
        return this.progressBackgroundStyle;
    }

    public final void setProgressBackgroundStyle(@NotNull BackgroundStyle value) {
        Paint.Style style;
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.progressBackgroundStyle = value;
        switch (value.ordinal()) {
            case 1: {
                style = Paint.Style.FILL;
                break;
            }
            case 2: {
                style = Paint.Style.FILL_AND_STROKE;
                break;
            }
            default: {
                style = Paint.Style.STROKE;
            }
        }
        this.backgroundPaint.setStyle(style);
        this.invalidate();
    }

    @NotNull
    public final ProgressStyle getProgressStyle() {
        return this.progressStyle;
    }

    public final void setProgressStyle(@NotNull ProgressStyle value) {
        Paint.Style style;
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.progressStyle = value;
        switch (value.ordinal()) {
            case 1: {
                style = Paint.Style.FILL;
                break;
            }
            case 2: {
                style = Paint.Style.FILL_AND_STROKE;
                break;
            }
            default: {
                style = Paint.Style.STROKE;
            }
        }
        this.progressPaint.setStyle(style);
        this.invalidate();
    }

    public final int getProgressBackgroundColor() {
        return this.backgroundPaint.getColor();
    }

    public final void setProgressBackgroundColor(int value) {
        this.backgroundPaint.setColor(value);
        this.invalidate();
    }

    public final float getProgressBackgroundStrokeWidth() {
        return this.backgroundPaint.getStrokeWidth();
    }

    public final void setProgressBackgroundStrokeWidth(float value) {
        this.backgroundPaint.setStrokeWidth(value);
        this.invalidate();
    }

    public final int getProgressColor() {
        return this.progressPaint.getColor();
    }

    public final void setProgressColor(int value) {
        this.progressPaint.setColor(value);
        this.invalidate();
    }

    public final float getProgressStrokeWidth() {
        return this.progressPaint.getStrokeWidth();
    }

    public final void setProgressStrokeWidth(float value) {
        this.progressPaint.setStrokeWidth(value);
        this.invalidate();
    }

    public final float getProgressStartAngle() {
        return this.progressStartAngle;
    }

    public final void setProgressStartAngle(float value) {
        this.progressStartAngle = value - (float)90;
        this.invalidate();
    }

    public final float getMinProgressValue() {
        return this.minProgressValue;
    }

    public final void setMinProgressValue(float value) {
        this.minProgressValue = value;
        this.invalidate();
    }

    public final float getMaxProgressValue() {
        return this.maxProgressValue;
    }

    public final void setMaxProgressValue(float value) {
        this.maxProgressValue = value;
        this.invalidate();
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        this.progress = value;
        if (!this.showTextInsteadProgress) {
            this.setText(this.progressFormatter.format(this.progress, this.minProgressValue, this.maxProgressValue));
        }
        this.invalidate();
    }

    public final boolean getProgressCounterClockwise() {
        return this.progressCounterClockwise;
    }

    public final void setProgressCounterClockwise(boolean value) {
        this.progressCounterClockwise = value;
        this.invalidate();
    }

    public final boolean getProgressStrokeCapRound() {
        return this.progressStrokeCapRound;
    }

    public final void setProgressStrokeCapRound(boolean value) {
        this.progressStrokeCapRound = value;
        this.invalidate();
    }

    public final boolean getShowProgressOnTip() {
        return this.showProgressOnTip;
    }

    public final void setShowProgressOnTip(boolean value) {
        this.showProgressOnTip = value;
        this.invalidate();
    }

    public final int getProgressOnTipTextColor() {
        return this.getProgressOnTipPaint().getColor();
    }

    public final void setProgressOnTipTextColor(int value) {
        this.getProgressOnTipPaint().setColor(value);
        this.invalidate();
    }

    public final float getProgressOnTipTextSize() {
        return this.getProgressOnTipPaint().getTextSize();
    }

    public final void setProgressOnTipTextSize(float value) {
        this.getProgressOnTipPaint().setTextSize(value);
        this.invalidate();
    }

    @Nullable
    public final String getProgressOnTipText() {
        CharSequence charSequence = this.progressOnTipText;
        return charSequence == null || charSequence.length() == 0 ? this.progressOnTipFormatter.format(this.progress, this.minProgressValue, this.maxProgressValue) : this.progressOnTipText;
    }

    public final void setProgressOnTipText(@Nullable String value) {
        this.progressOnTipText = value;
        this.invalidate();
    }

    @Nullable
    public final Drawable getProgressOnTipDrawable() {
        return this.progressOnTipDrawable;
    }

    public final void setProgressOnTipDrawable(@Nullable Drawable value) {
        this.progressOnTipDrawable = value;
        this.progressOnTipBitmap = value == null ? null : this.drawableToBitmap(value);
        this.invalidate();
    }

    public final int getProgressOnTipDrawableRes() {
        return this.progressOnTipDrawableRes;
    }

    public final void setProgressOnTipDrawableRes(int value) {
        this.progressOnTipDrawableRes = value;
        this.setProgressOnTipDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)value));
    }

    public final void setProgressFormatter(@Nullable ProgressFormatter formatter) {
        ProgressFormatter progressFormatter = formatter;
        if (progressFormatter == null) {
            progressFormatter = DefaultProgressFormatter.INSTANCE;
        }
        this.progressFormatter = progressFormatter;
        this.invalidate();
    }

    public final void setProgressOnTipFormatter(@Nullable ProgressFormatter formatter) {
        ProgressFormatter progressFormatter = formatter;
        if (progressFormatter == null) {
            progressFormatter = DefaultProgressFormatter.INSTANCE;
        }
        this.progressOnTipFormatter = progressFormatter;
        this.invalidate();
    }

    public final boolean getShowProgressAsPercentage() {
        return this.showProgressAsPercentage;
    }

    public final void setShowProgressAsPercentage(boolean value) {
        this.setProgressFormatter(value ? (ProgressFormatter)PercentProgressFormatter.INSTANCE : (ProgressFormatter)DefaultProgressFormatter.INSTANCE);
    }

    public final boolean getShowProgressOnTipAsPercentage() {
        return this.showProgressOnTipAsPercentage;
    }

    public final void setShowProgressOnTipAsPercentage(boolean value) {
        this.setProgressOnTipFormatter(value ? (ProgressFormatter)PercentProgressFormatter.INSTANCE : (ProgressFormatter)DefaultProgressFormatter.INSTANCE);
    }

    private final void applyAttrs(TypedArray typedArray) {
        this.showTextInsteadProgress = typedArray.getBoolean(R.styleable.ProgressView_showTextInsteadOfProgress, false);
        this.setMinProgressValue(typedArray.getFloat(R.styleable.ProgressView_minProgressValue, 0.0f));
        this.setMaxProgressValue(typedArray.getFloat(R.styleable.ProgressView_maxProgressValue, 0.0f));
        this.setProgress(typedArray.getFloat(R.styleable.ProgressView_progress, 0.0f));
        int backProgressStyle = typedArray.getInt(R.styleable.ProgressView_progressBackgroundStyle, 0);
        this.setProgressBackgroundStyle(BackgroundStyle.values()[backProgressStyle]);
        this.backgroundPaint.setStrokeWidth(typedArray.getDimension(R.styleable.ProgressView_progressBackgroundStrokeWidth, 0.0f));
        this.backgroundPaint.setColor(typedArray.getColor(R.styleable.ProgressView_progressBackgroundColor, -16777216));
        int style = typedArray.getInt(R.styleable.ProgressView_progressStyle, 0);
        this.setProgressStyle(ProgressStyle.values()[style]);
        this.progressPaint.setStrokeWidth(typedArray.getDimension(R.styleable.ProgressView_progressStrokeWidth, 0.0f));
        this.progressPaint.setColor(typedArray.getColor(R.styleable.ProgressView_progressColor, -16777216));
        this.setProgressStartAngle(typedArray.getFloat(R.styleable.ProgressView_progressStartAngle, 0.0f));
        this.setProgressStrokeCapRound(typedArray.getBoolean(R.styleable.ProgressView_progressStrokeCapRound, false));
        this.setProgressCounterClockwise(typedArray.getBoolean(R.styleable.ProgressView_progressCounterClockwise, false));
        this.setShowProgressOnTip(typedArray.getBoolean(R.styleable.ProgressView_showProgressOnTip, false));
        this.setProgressOnTipText(typedArray.getString(R.styleable.ProgressView_progressOnTipText));
        this.setProgressOnTipTextColor(typedArray.getColor(R.styleable.ProgressView_progressOnTipTextColor, -1));
        this.setProgressOnTipTextSize(typedArray.getDimension(R.styleable.ProgressView_progressOnTipTextSize, 0.0f));
        this.setProgressOnTipDrawable(typedArray.getDrawable(R.styleable.ProgressView_progressOnTipDrawable));
        this.setShowProgressAsPercentage(typedArray.getBoolean(R.styleable.ProgressView_showProgressAsPercentage, false));
        this.setShowProgressOnTipAsPercentage(typedArray.getBoolean(R.styleable.ProgressView_showProgressOnTipAsPercentage, false));
        typedArray.recycle();
    }

    public void setIncludeFontPadding(boolean b) {
        super.setIncludeFontPadding(false);
    }

    public void setGravity(int gravity) {
        super.setGravity(17);
    }

    protected void onMeasure(int w, int h) {
        int widthMode = View.MeasureSpec.getMode((int)w);
        int widthSize = View.MeasureSpec.getSize((int)w);
        int heightMode = View.MeasureSpec.getMode((int)h);
        int heightSize = View.MeasureSpec.getSize((int)h);
        widthSize = this.measureDimension(widthSize, widthMode);
        heightSize = this.measureDimension(heightSize, heightMode);
        int size = Math.min(widthSize, heightSize);
        this.setMeasuredDimension(size, size);
    }

    private final int measureDimension(int value, int mode) {
        int n;
        switch (mode) {
            case -2147483648: {
                n = Math.min(value, this.defaultSize);
                break;
            }
            case 0: {
                n = value;
                break;
            }
            case 0x40000000: {
                n = value;
                break;
            }
            default: {
                n = value;
            }
        }
        return n;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        float size = this.getWidth();
        float center = size / (float)2;
        float r = this.getRadius();
        float arcFrom = center - this.getRadius();
        float arcTo = size - arcFrom;
        float angle = this.getAngle();
        if (this.progressBackgroundStyle != BackgroundStyle.NONE) {
            canvas.drawCircle(center, center, r, this.backgroundPaint);
        }
        this.progressRectF.set(arcFrom, arcFrom, arcTo, arcTo);
        this.progressPaint.setStrokeCap(this.getProgressPaintCapStyle());
        boolean useCenter = this.progressPaint.getStyle() != Paint.Style.STROKE;
        canvas.drawArc(this.progressRectF, this.progressStartAngle, angle, useCenter, this.progressPaint);
        Bitmap bitmap = this.progressOnTipBitmap;
        if (bitmap != null) {
            Bitmap bitmap2;
            Bitmap it = bitmap2 = bitmap;
            this.applyProgressOnTipBitmap(canvas, center, r, angle, it);
        }
        if (this.showProgressOnTip) {
            this.applyProgressOnTip(canvas, center, r, angle);
        }
        super.onDraw(canvas);
    }

    private final Bitmap drawableToBitmap(Drawable drawable) {
        int width = drawable.getIntrinsicWidth() > 0 ? drawable.getIntrinsicWidth() : 1;
        int height = drawable.getIntrinsicHeight() > 0 ? drawable.getIntrinsicHeight() : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    private final void applyProgressOnTipBitmap(Canvas canvas, float center, float r, float angle, Bitmap bitmap) {
        double radAngle = Math.toRadians((double)this.progressStartAngle + (double)angle);
        float x = center + r * (float)Math.cos(radAngle) - (float)(bitmap.getWidth() / 2);
        float y = center + r * (float)Math.sin(radAngle) - (float)(bitmap.getHeight() / 2);
        canvas.drawBitmap(bitmap, x, y, this.getProgressOnTipDrawablePaint());
    }

    private final void applyProgressOnTip(Canvas canvas, float center, float r, float angle) {
        this.getProgressOnTipPaint().setColor(this.getProgressOnTipTextColor());
        String string = this.getProgressOnTipText();
        if (string == null) {
            string = "";
        }
        String text = string;
        float textW = this.progressPaint.getStrokeWidth() / (float)2;
        if (this.getProgressOnTipTextSize() == 0.0f) {
            this.getProgressOnTipPaint().setTextSize(textW);
            this.getProgressOnTipPaint().getTextBounds(text, 0, text.length(), this.getProgressOnTipBounds());
            int textWidth = this.getProgressOnTipBounds().width();
            if ((float)textWidth > textW) {
                Paint paint = this.getProgressOnTipPaint();
                paint.setTextSize(paint.getTextSize() * (textW / (float)textWidth));
            }
        } else {
            this.getProgressOnTipPaint().setTextSize(this.getProgressOnTipTextSize());
        }
        this.getProgressOnTipPaint().getTextBounds(text, 0, text.length(), this.getProgressOnTipBounds());
        float height = (this.getProgressOnTipPaint().getFontMetrics().descent - this.getProgressOnTipPaint().getFontMetrics().ascent) / (float)4;
        double radAngle = Math.toRadians((double)this.progressStartAngle + (double)angle);
        float x = center + r * (float)Math.cos(radAngle);
        float y = center + r * (float)Math.sin(radAngle) + height;
        canvas.drawText(this.getProgressOnTipText(), x, y, this.getProgressOnTipPaint());
    }

    private final Paint.Cap getProgressPaintCapStyle() {
        return this.progressStrokeCapRound || this.showProgressOnTip || this.progressOnTipBitmap != null ? Paint.Cap.ROUND : Paint.Cap.BUTT;
    }

    private final float getRadius() {
        return ((float)this.getWidth() - (float)this.getMaxPadding() - Math.max(this.backgroundPaint.getStrokeWidth(), this.progressPaint.getStrokeWidth())) / (float)2;
    }

    private final int getMaxPadding() {
        return Math.max(Math.max(this.getPaddingStart(), this.getPaddingEnd()), Math.max(this.getPaddingTop(), this.getPaddingBottom())) * 2;
    }

    private final float getAngle() {
        if (this.progress < this.minProgressValue || this.progress > this.maxProgressValue) {
            return 0.0f;
        }
        int direction = this.progressCounterClockwise ? -1 : 1;
        return (float)360 * this.getProgressPercent() / (float)100 * (float)direction;
    }

    private final float getProgressPercent() {
        return (this.progress - this.minProgressValue) * (float)100 / (this.maxProgressValue - this.minProgressValue);
    }

    @JvmOverloads
    public ProgressView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray;
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.defaultSize = this.getResources().getDimensionPixelSize(R.dimen.progress_view_default_size);
        Paint paint2 = new Paint(1);
        ProgressView progressView = this;
        Paint $receiver = paint2;
        $receiver.setStyle(Paint.Style.STROKE);
        progressView.backgroundPaint = paint = paint2;
        paint2 = new Paint(1);
        progressView = this;
        $receiver = paint2;
        $receiver.setStyle(Paint.Style.STROKE);
        progressView.progressPaint = paint = paint2;
        this.progressOnTipDrawablePaint$delegate = LazyKt.lazy((Function0)progressOnTipDrawablePaint.2.INSTANCE);
        this.progressOnTipPaint$delegate = LazyKt.lazy((Function0)progressOnTipPaint.2.INSTANCE);
        this.progressOnTipBounds$delegate = LazyKt.lazy((Function0)progressOnTipBounds.2.INSTANCE);
        this.progressRectF = new RectF();
        this.progressFormatter = DefaultProgressFormatter.INSTANCE;
        this.progressOnTipFormatter = DefaultProgressFormatter.INSTANCE;
        this.progressBackgroundStyle = BackgroundStyle.STROKE;
        this.progressStyle = ProgressStyle.STROKE;
        this.progressOnTipText = "";
        TypedArray typedArray2 = typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressView, 0, R.style.ProgressViewDefaultStyle);
        if (typedArray2 != null) {
            TypedArray typedArray3;
            TypedArray arr = typedArray3 = typedArray2;
            this.applyAttrs(arr);
        }
        this.setIncludeFontPadding(false);
        this.setGravity(17);
        this.progressPaintCapStyle = Paint.Cap.BUTT;
    }

    @JvmOverloads
    public /* synthetic */ ProgressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ProgressView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ProgressView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

