/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot;

import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.examples.boot.config.BasicExamplesConfiguration;
import com.github.kagkarlsson.examples.boot.config.JobChainingConfiguration;
import com.github.kagkarlsson.examples.boot.config.LongRunningJobConfiguration;
import com.github.kagkarlsson.examples.boot.config.MultiInstanceRecurringConfiguration;
import com.github.kagkarlsson.examples.boot.config.ParallellJobConfiguration;
import com.github.kagkarlsson.examples.boot.config.RecurringStateTrackingConfiguration;
import com.github.kagkarlsson.examples.boot.config.TransactionallyStagedJobConfiguration;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin"})
public class AdminController {
    private static final Logger LOG = LoggerFactory.getLogger(AdminController.class);
    public static final String LIST_SCHEDULED = "/tasks";
    public static final String START = "/start";
    public static final String STOP = "/stop";
    private static final Map<String, Consumer<ExampleContext>> TASK_STARTERS = new HashMap<String, Consumer<ExampleContext>>();
    private final SchedulerClient schedulerClient;
    private final ExampleContext exampleContext;

    public AdminController(SchedulerClient schedulerClient, TransactionTemplate tx) {
        this.schedulerClient = schedulerClient;
        this.exampleContext = new ExampleContext(schedulerClient, tx, LOG);
    }

    @GetMapping(path={"/tasks"})
    public List<Scheduled> list() {
        return this.schedulerClient.getScheduledExecutions().stream().map(e -> new Scheduled(e.getTaskInstance().getTaskName(), e.getTaskInstance().getId(), e.getExecutionTime(), e.getData())).collect(Collectors.toList());
    }

    @PostMapping(path={"/start"}, headers={"Content-type=application/json"})
    public void start(@RequestBody StartRequest request) {
        TASK_STARTERS.get(request.taskName).accept(this.exampleContext);
    }

    @PostMapping(path={"/stop"}, headers={"Content-type=application/json"})
    public void stop(@RequestBody StartRequest request) {
        this.schedulerClient.getScheduledExecutions().stream().filter(s -> s.getTaskInstance().getTaskName().equals(request.taskName)).findAny().ifPresent(s -> this.schedulerClient.cancel(s.getTaskInstance()));
    }

    static {
        TASK_STARTERS.put(BasicExamplesConfiguration.BASIC_ONE_TIME_TASK.getTaskName(), BasicExamplesConfiguration::triggerOneTime);
        TASK_STARTERS.put(TransactionallyStagedJobConfiguration.TRANSACTIONALLY_STAGED_TASK.getTaskName(), TransactionallyStagedJobConfiguration::start);
        TASK_STARTERS.put(JobChainingConfiguration.CHAINED_STEP_1_TASK.getTaskName(), JobChainingConfiguration::start);
        TASK_STARTERS.put(ParallellJobConfiguration.PARALLEL_JOB_SPAWNER.getTaskName(), ParallellJobConfiguration::start);
        TASK_STARTERS.put(LongRunningJobConfiguration.LONG_RUNNING_TASK.getTaskName(), LongRunningJobConfiguration::start);
        TASK_STARTERS.put(MultiInstanceRecurringConfiguration.MULTI_INSTANCE_RECURRING_TASK.getTaskName(), MultiInstanceRecurringConfiguration::start);
        TASK_STARTERS.put(RecurringStateTrackingConfiguration.STATE_TRACKING_RECURRING_TASK.getTaskName(), RecurringStateTrackingConfiguration::start);
    }

    public static class Scheduled {
        public final String taskName;
        public final String id;
        public final Instant executionTime;
        public final Object data;

        public Scheduled() {
            this(null, null, null, null);
        }

        public Scheduled(String taskName, String id, Instant executionTime, Object data) {
            this.taskName = taskName;
            this.id = id;
            this.executionTime = executionTime;
            this.data = data;
        }
    }

    public static class StartRequest {
        public final String taskName;

        public StartRequest() {
            this("");
        }

        public StartRequest(String taskName) {
            this.taskName = taskName;
        }
    }
}

