/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.boot.config.DbSchedulerCustomizer;
import com.github.kagkarlsson.scheduler.event.AbstractSchedulerListener;
import com.github.kagkarlsson.scheduler.event.ExecutionInterceptor;
import com.github.kagkarlsson.scheduler.event.SchedulerListener;
import com.github.kagkarlsson.scheduler.serializer.JacksonSerializer;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SchedulerConfiguration {
    public static final String MDC_TASKNAME = "task-name";
    public static final String MDC_TASKINSTANCEID = "task-instance-id";
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerConfiguration.class);

    @Bean
    DbSchedulerCustomizer customizer() {
        return new DbSchedulerCustomizer(){

            public Optional<SchedulerName> schedulerName() {
                return Optional.of(new SchedulerName.Fixed("spring-boot-scheduler-1"));
            }

            public Optional<Serializer> serializer() {
                return Optional.of(new JacksonSerializer());
            }
        };
    }

    @Bean
    SchedulerListener schedulerListener() {
        return new AbstractSchedulerListener(){

            public void onExecutionComplete(ExecutionComplete executionComplete) {
                LOG.info("SchedulerListener.onExecutionComplete. Result={}, took={}ms ", (Object)executionComplete.getResult(), (Object)executionComplete.getDuration().toMillis());
            }
        };
    }

    @Bean
    ExecutionInterceptor mdcExecutionInterceptor() {
        return (taskInstance, executionContext, chain) -> {
            LOG.info("Setting MDC before execution");
            MDC.put((String)MDC_TASKNAME, (String)taskInstance.getTaskName());
            MDC.put((String)MDC_TASKINSTANCEID, (String)taskInstance.getId());
            try {
                CompletionHandler completionHandler = chain.proceed(taskInstance, executionContext);
                return completionHandler;
            }
            finally {
                MDC.remove((String)MDC_TASKNAME);
                MDC.remove((String)MDC_TASKINSTANCEID);
            }
        };
    }
}

