/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.CounterService;
import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.HasTaskName;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.TaskWithoutDataDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.EventLogger;

@Configuration
public class BasicExamplesConfiguration {
    public static final TaskWithoutDataDescriptor BASIC_ONE_TIME_TASK = new TaskWithoutDataDescriptor("sample-one-time-task");
    public static final TaskWithoutDataDescriptor BASIC_RECURRING_TASK = new TaskWithoutDataDescriptor("recurring-sample-task");
    private static final Logger log = LoggerFactory.getLogger(BasicExamplesConfiguration.class);
    private static int ID = 1;

    public static void triggerOneTime(ExampleContext ctx) {
        ctx.log("Scheduling a basic one-time task to run 'Instant.now()+seconds'. If seconds=0, the scheduler will pick these up immediately since it is configured with 'immediate-execution-enabled=true'");
        ctx.schedulerClient.schedule(BASIC_ONE_TIME_TASK.instance(String.valueOf(ID++)), Instant.now());
    }

    @Bean
    Task<Void> recurringSampleTask(CounterService counter) {
        return Tasks.recurring((TaskDescriptor)BASIC_RECURRING_TASK, (Schedule)Schedules.fixedDelay((Duration)Duration.ofMinutes(1L))).execute((instance, ctx) -> {
            log.info("Running recurring-simple-task. Instance: {}, ctx: {}", (Object)instance, (Object)ctx);
            counter.increase();
            EventLogger.logTask((HasTaskName)BASIC_RECURRING_TASK, "Ran. Run-counter current-value=" + counter.read());
        });
    }

    @Bean
    Task<Void> sampleOneTimeTask() {
        return Tasks.oneTime((TaskDescriptor)BASIC_ONE_TIME_TASK).execute((instance, ctx) -> log.info("I am a one-time task!"));
    }
}

