/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.HasTaskName;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.TaskWithoutDataDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.time.Instant;
import java.util.Random;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.EventLogger;

@Configuration
public class TransactionallyStagedJobConfiguration {
    public static final TaskWithoutDataDescriptor TRANSACTIONALLY_STAGED_TASK = new TaskWithoutDataDescriptor("transactionally-staged-task");
    private static int ID = 1;

    public static void start(ExampleContext ctx) {
        ctx.log("Scheduling a one-time task in a transaction. If the transaction rolls back, the insert of the task also rolls back, i.e. it will never run.");
        ctx.tx.executeWithoutResult(status -> {
            ctx.schedulerClient.schedule(TRANSACTIONALLY_STAGED_TASK.instance(String.valueOf(ID++)), Instant.now());
            if (new Random().nextBoolean()) {
                throw new RuntimeException("Simulated failure happening after task was scheduled. Scheduled task will never run.");
            }
        });
    }

    @Bean
    public Task<Void> transactionallyStagedTask() {
        return Tasks.oneTime((TaskDescriptor)TRANSACTIONALLY_STAGED_TASK).execute((taskInstance, executionContext) -> EventLogger.logTask((HasTaskName)TRANSACTIONALLY_STAGED_TASK, "Ran. Will only run if transactions it was scheduled commits. "));
    }
}

