/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.serializer.GsonSerializer;
import com.github.kagkarlsson.scheduler.serializer.JavaSerializer;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.serializer.SerializerWithFallbackDeserializers;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;

public class SerializingExperimentMain {
    public static void main(String[] args) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setServerNames(new String[]{"localhost"});
        ds.setDatabaseName("postgres");
        ds.setUser("postgres");
        ds.setPassword("my_password");
        ds.setPortNumbers(new int[]{54320});
        new SerializingExperimentMain().run((DataSource)ds);
    }

    public void run(DataSource dataSource) {
        RecurringTask task = Tasks.recurring((String)"serializing-task", (Schedule)Schedules.fixedDelay((Duration)Duration.ofSeconds(1L)), MyData.class).executeStateful((inst, ctx) -> {
            System.out.println("Executed! Custom data: " + String.valueOf(inst.getData()));
            return new MyData(1002L, Instant.now());
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[0]).startTasks((Task[])new RecurringTask[]{task}).pollingInterval(Duration.ofSeconds(1L)).heartbeatInterval(Duration.ofSeconds(3L)).serializer((Serializer)new SerializerWithFallbackDeserializers((Serializer)new JavaSerializer(), (Serializer)new GsonSerializer())).registerShutdownHook().build();
        scheduler.start();
    }

    public static class MyData
    implements Serializable {
        public final long id;
        private final Instant time;
        private static final long serialVersionUID = 6236001007065622457L;

        public MyData(long id, Instant time) {
            this.id = id;
            this.time = time;
        }

        public Instant getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyData myData = (MyData)o;
            return this.id == myData.id && Objects.equals(this.time, myData.time);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.time);
        }

        public String toString() {
            return "JsonData{id=" + this.id + ", time=" + String.valueOf(this.time) + "}";
        }
    }
}

