/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class JobChainingUsingTaskDataMain
extends Example {
    public static final TaskDescriptor<JobState> JOB_CHAIN_TASK = TaskDescriptor.of((String)"job-chain-poc", JobState.class);

    public static void main(String[] args) {
        new JobChainingUsingTaskDataMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        CustomTask chainingTask = Tasks.custom(JOB_CHAIN_TASK).execute((taskInstance, executionContext) -> {
            if (((JobState)taskInstance.getData()).currentStep == Step.STEP1) {
                System.out.println("Step1 ran. Job: " + taskInstance.getData());
                return (executionComplete, executionOperations) -> {
                    JobState nextJobState = ((JobState)taskInstance.getData()).nextStep(Step.STEP2);
                    executionOperations.reschedule(executionComplete, Instant.now(), (Object)nextJobState);
                };
            }
            if (((JobState)taskInstance.getData()).currentStep == Step.STEP2) {
                System.out.println("Step2 ran. Job: " + taskInstance.getData());
                return (executionComplete, executionOperations) -> {
                    JobState nextJobState = ((JobState)taskInstance.getData()).nextStep(Step.STEP3);
                    executionOperations.reschedule(executionComplete, Instant.now(), (Object)nextJobState);
                };
            }
            if (((JobState)taskInstance.getData()).currentStep == Step.STEP3) {
                System.out.println("Step3 ran. Removing multistep-job. Job: " + taskInstance.getData());
                return new CompletionHandler.OnCompleteRemove();
            }
            throw new RuntimeException("Unknown step: " + taskInstance.getData());
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{chainingTask}).enableImmediateExecution().pollingInterval(Duration.ofSeconds(1L)).build();
        scheduler.start();
        this.sleep(1000);
        scheduler.schedule(JOB_CHAIN_TASK.instance("job-507").data((Object)JobState.newJob(507)).scheduledTo(Instant.now().plusSeconds(1L)));
    }

    public static class JobState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Step currentStep;
        public int id;

        public JobState(int id, Step currentStep) {
            this.id = id;
            this.currentStep = currentStep;
        }

        public static JobState newJob(int id) {
            return new JobState(id, Step.STEP1);
        }

        public JobState nextStep(Step nextStep) {
            return new JobState(this.id, nextStep);
        }

        public String toString() {
            return "JobState{currentStep=" + this.currentStep + ", id=" + this.id + "}";
        }
    }

    public static enum Step {
        STEP1,
        STEP2,
        STEP3;

    }
}

