/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelay;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.io.Serializable;
import java.time.Duration;
import javax.sql.DataSource;

public class TrackingProgressRecurringTaskMain
extends Example {
    public static void main(String[] args) {
        new TrackingProgressRecurringTaskMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        FixedDelay schedule = FixedDelay.ofSeconds((int)2);
        RecurringTask statefulTask = Tasks.recurring((String)"counting-task", (Schedule)schedule, Counter.class).initialData((Object)new Counter(0)).executeStateful((taskInstance, executionContext) -> {
            Counter startingCounter = (Counter)taskInstance.getData();
            for (int i = 0; i < 10; ++i) {
                System.out.println("Counting " + (startingCounter.value + i));
            }
            return new Counter(startingCounter.value + 10);
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[0]).pollingInterval(Duration.ofSeconds(5L)).startTasks((Task[])new RecurringTask[]{statefulTask}).registerShutdownHook().build();
        scheduler.start();
    }

    private static final class Counter
    implements Serializable {
        private final int value;

        public Counter(int value) {
            this.value = value;
        }
    }
}

