/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.ScheduledExecutionsFilter;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.serializer.JacksonSerializer;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.time.Instant;
import java.util.stream.Stream;
import javax.sql.DataSource;

public class SchedulerClientMain
extends Example {
    public static final TaskDescriptor<Integer> MY_TASK = TaskDescriptor.of((String)"task-a", Integer.class);

    public static void main(String[] args) {
        new SchedulerClientMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask task = Tasks.oneTime(MY_TASK).execute((taskInstance, executionContext) -> System.out.println("Task a executed"));
        SchedulerClient clientWithTypeInformation = SchedulerClient.Builder.create((DataSource)dataSource, (Task[])new Task[]{task}).serializer((Serializer)new JacksonSerializer()).build();
        Instant now = Instant.now();
        for (int i = 0; i < 5; ++i) {
            clientWithTypeInformation.scheduleIfNotExists(MY_TASK.instance("id" + i).data((Object)i).scheduledTo(now.plusSeconds(i)));
        }
        clientWithTypeInformation.scheduleBatch(Stream.of(MY_TASK.instance("batch-id-1").data((Object)1).build(), MY_TASK.instance("batch-id-2").data((Object)2).build(), MY_TASK.instance("batch-id-3").data((Object)3).build()), now.plusSeconds(8L));
        System.out.println("Listing scheduled executions");
        clientWithTypeInformation.getScheduledExecutions(ScheduledExecutionsFilter.all()).forEach(execution -> System.out.printf("Scheduled execution: taskName=%s, instance=%s, executionTime=%s, data=%s%n", execution.getTaskInstance().getTaskName(), execution.getTaskInstance().getId(), execution.getExecutionTime(), execution.getData()));
        SchedulerClient rawClient = SchedulerClient.Builder.create((DataSource)dataSource, (Task[])new Task[0]).build();
        System.out.println("Listing scheduled executions for client with no known tasks (data-classes and implementations)");
        rawClient.getScheduledExecutions(ScheduledExecutionsFilter.all()).forEach(execution -> System.out.printf("Scheduled execution: taskName=%s, instance=%s, executionTime=%s, data=%s%n", execution.getTaskInstance().getTaskName(), execution.getTaskInstance().getId(), execution.getExecutionTime(), new String((byte[])execution.getData())));
    }
}

