/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.io.Serializable;
import java.time.Instant;
import javax.sql.DataSource;

public class OneTimeTaskMain
extends Example {
    public static final TaskDescriptor<MyTaskData> MY_TASK = TaskDescriptor.of((String)"my-onetime-task", MyTaskData.class);

    public static void main(String[] args) {
        new OneTimeTaskMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask taskImplementation = Tasks.oneTime(MY_TASK).execute((inst, ctx) -> System.out.println("Executed! Custom data, Id: " + ((MyTaskData)inst.getData()).id));
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{taskImplementation}).registerShutdownHook().build();
        scheduler.start();
        scheduler.schedule(MY_TASK.instance("1045").data((Object)new MyTaskData(1001L)).scheduledTo(Instant.now().plusSeconds(5L)));
    }

    public static class MyTaskData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final long id;

        public MyTaskData(long id) {
            this.id = id;
        }
    }
}

