/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.SchedulableInstance;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class JobChainingUsingSeparateTasksMain
extends Example {
    public static final TaskDescriptor<JobId> STEP1_TASK = TaskDescriptor.of((String)"job-step-1", JobId.class);
    public static final TaskDescriptor<JobId> STEP2_TASK = TaskDescriptor.of((String)"job-step-2", JobId.class);

    public static void main(String[] args) {
        new JobChainingUsingSeparateTasksMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        CustomTask jobStep1 = Tasks.custom(STEP1_TASK).execute((taskInstance, executionContext) -> {
            System.out.println("Step1 ran. Job: " + taskInstance.getData());
            return new OnCompleteRemoveAndCreateNextStep(STEP2_TASK.getTaskName());
        });
        CustomTask jobStep2 = Tasks.custom(STEP2_TASK).execute((taskInstance, executionContext) -> {
            System.out.println("Step2 ran. Removing multistep-job. Job: " + taskInstance.getData());
            return new CompletionHandler.OnCompleteRemove();
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{jobStep1, jobStep2}).enableImmediateExecution().pollingInterval(Duration.ofSeconds(10L)).build();
        scheduler.start();
        this.sleep(1000);
        scheduler.schedule(STEP1_TASK.instance("job-507").data((Object)new JobId(507)).scheduledTo(Instant.now()));
    }

    static class OnCompleteRemoveAndCreateNextStep
    implements CompletionHandler<JobId> {
        private final String newTaskName;

        public OnCompleteRemoveAndCreateNextStep(String newTaskName) {
            this.newTaskName = newTaskName;
        }

        public void complete(ExecutionComplete executionComplete, ExecutionOperations<JobId> executionOperations) {
            TaskInstance taskInstance = executionComplete.getExecution().taskInstance;
            TaskInstance nextInstance = new TaskInstance(this.newTaskName, taskInstance.getId(), (Object)((JobId)taskInstance.getData()));
            executionOperations.removeAndScheduleNew(SchedulableInstance.of((TaskInstance)nextInstance, (Instant)Instant.now()));
        }
    }

    public static class JobId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int id;

        public JobId(int id) {
            this.id = id;
        }

        public String toString() {
            return "JobId{id=" + this.id + "}";
        }
    }
}

