/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.jdbc.JdbcRunner;
import com.github.kagkarlsson.jdbc.PreparedStatementSetter;
import com.github.kagkarlsson.scheduler.HeartbeatState;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class HeartbeatMonitoringMain
extends Example {
    public static void main(String[] args) {
        new HeartbeatMonitoringMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask waitForStaleHeartbeatTask = Tasks.oneTime((String)"wait-for-stale-heartbeat-task", Void.class).execute((inst, ctx) -> {
            System.out.println("Running!");
            while (ctx.getCurrentlyExecuting().getHeartbeatState().getFractionDead() < 0.7) {
                this.sleep(100);
                this.printHeartbeat(ctx.getCurrentlyExecuting().getHeartbeatState());
            }
            this.printHeartbeat(ctx.getCurrentlyExecuting().getHeartbeatState());
            System.out.println("Done!");
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{waitForStaleHeartbeatTask}).threads(5).heartbeatInterval(Duration.ofSeconds(1L)).missedHeartbeatsLimit(8).pollingInterval(Duration.ofSeconds(1L)).build();
        scheduler.start();
        scheduler.schedule(waitForStaleHeartbeatTask.instance("1045"), Instant.now());
        this.sleep(4000);
        JdbcRunner jdbcRunner = new JdbcRunner(dataSource);
        System.out.println("Fake update on execution to cause heartbeat-update to fail.");
        jdbcRunner.execute("update scheduled_tasks set version = version + 1", PreparedStatementSetter.NOOP);
    }

    private void printHeartbeat(HeartbeatState heartbeatState) {
        System.out.printf("Will keep running until heartbeat-failure detected. Current state: failed-heartbeats=%s, fraction-dead=%s, stale=%s\n", heartbeatState.getFailedHeartbeats(), heartbeatState.getFractionDead(), heartbeatState.hasStaleHeartbeat());
    }
}

