/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FailureHandler<T> {
    public void onFailure(ExecutionComplete var1, ExecutionOperations<T> var2);

    public static class OnFailureReschedule<T>
    implements FailureHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(CompletionHandler.OnCompleteReschedule.class);
        private final Schedule schedule;

        public OnFailureReschedule(Schedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public void onFailure(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            Instant nextExecution = this.schedule.getNextExecutionTime(executionComplete);
            LOG.debug("Execution failed. Rescheduling task {} to {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextExecution);
            executionOperations.reschedule(executionComplete, nextExecution);
        }
    }

    public static class OnFailureRetryLater<T>
    implements FailureHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(CompletionHandler.OnCompleteReschedule.class);
        private final Duration sleepDuration;

        public OnFailureRetryLater(Duration sleepDuration) {
            this.sleepDuration = sleepDuration;
        }

        @Override
        public void onFailure(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            Instant nextTry = Instant.now().plus(this.sleepDuration);
            LOG.debug("Execution failed. Retrying task {} at {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextTry);
            executionOperations.reschedule(executionComplete, nextTry);
        }
    }
}

