/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.Execution;
import java.time.Instant;
import java.util.Optional;

public class ExecutionComplete {
    private final Execution execution;
    private final Instant timeDone;
    private final Result result;
    private final Throwable cause;

    ExecutionComplete(Execution execution, Instant timeDone, Result result, Throwable cause) {
        this.cause = cause;
        if (result == Result.OK && cause != null) {
            throw new IllegalArgumentException("Result 'OK' should never have a cause.");
        }
        this.execution = execution;
        this.timeDone = timeDone;
        this.result = result;
    }

    public static ExecutionComplete success(Execution execution, Instant timeDone) {
        return new ExecutionComplete(execution, timeDone, Result.OK, null);
    }

    public static ExecutionComplete failure(Execution execution, Instant timeDone, Throwable cause) {
        return new ExecutionComplete(execution, timeDone, Result.FAILED, cause);
    }

    public Execution getExecution() {
        return this.execution;
    }

    public Instant getTimeDone() {
        return this.timeDone;
    }

    public Result getResult() {
        return this.result;
    }

    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }

    public static enum Result {
        OK,
        FAILED;

    }
}

