/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.config;

import com.github.kagkarlsson.scheduler.SchedulerBuilder;
import com.github.kagkarlsson.scheduler.logging.LogLevel;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="db-scheduler")
public class DbSchedulerProperties {
    private boolean enabled = true;
    private int threads = 10;
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration heartbeatInterval = SchedulerBuilder.DEFAULT_HEARTBEAT_INTERVAL;
    private String schedulerName;
    private String tableName = "scheduled_tasks";
    private boolean immediateExecutionEnabled = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration pollingInterval = SchedulerBuilder.DEFAULT_POLLING_INTERVAL;
    private Optional<Integer> pollingLimit = Optional.empty();
    private boolean delayStartupUntilContextReady = false;
    @DurationUnit(value=ChronoUnit.HOURS)
    private Duration deleteUnresolvedAfter = SchedulerBuilder.DEFAULT_DELETION_OF_UNRESOLVED_TASKS_DURATION;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration shutdownMaxWait = SchedulerBuilder.SHUTDOWN_MAX_WAIT;
    private LogLevel failureLoggerLevel = SchedulerBuilder.DEFAULT_FAILURE_LOG_LEVEL;
    private boolean failureLoggerLogStackTrace = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isImmediateExecutionEnabled() {
        return this.immediateExecutionEnabled;
    }

    public void setImmediateExecutionEnabled(boolean immediateExecutionEnabled) {
        this.immediateExecutionEnabled = immediateExecutionEnabled;
    }

    public Duration getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public Optional<Integer> getPollingLimit() {
        return this.pollingLimit;
    }

    public void setPollingLimit(Optional<Integer> pollingLimit) {
        this.pollingLimit = pollingLimit;
    }

    public boolean isDelayStartupUntilContextReady() {
        return this.delayStartupUntilContextReady;
    }

    public void setDelayStartupUntilContextReady(boolean delayStartupUntilContextReady) {
        this.delayStartupUntilContextReady = delayStartupUntilContextReady;
    }

    public Duration getDeleteUnresolvedAfter() {
        return this.deleteUnresolvedAfter;
    }

    public void setDeleteUnresolvedAfter(Duration deleteUnresolvedAfter) {
        this.deleteUnresolvedAfter = deleteUnresolvedAfter;
    }

    public Duration getShutdownMaxWait() {
        return this.shutdownMaxWait;
    }

    public void setShutdownMaxWait(Duration shutdownMaxWait) {
        this.shutdownMaxWait = shutdownMaxWait;
    }

    public LogLevel getFailureLoggerLevel() {
        return this.failureLoggerLevel;
    }

    public void setFailureLoggerLevel(LogLevel failureLoggerLevel) {
        this.failureLoggerLevel = failureLoggerLevel;
    }

    public boolean isFailureLoggerLogStackTrace() {
        return this.failureLoggerLogStackTrace;
    }

    public void setFailureLoggerLogStackTrace(boolean failureLoggerLogStackTrace) {
        this.failureLoggerLogStackTrace = failureLoggerLogStackTrace;
    }
}

