/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.boot.autoconfigure;

import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerBuilder;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.boot.actuator.DbSchedulerHealthIndicator;
import com.github.kagkarlsson.scheduler.boot.config.DbSchedulerCustomizer;
import com.github.kagkarlsson.scheduler.boot.config.DbSchedulerProperties;
import com.github.kagkarlsson.scheduler.boot.config.DbSchedulerStarter;
import com.github.kagkarlsson.scheduler.boot.config.startup.ContextReadyStart;
import com.github.kagkarlsson.scheduler.boot.config.startup.ImmediateStart;
import com.github.kagkarlsson.scheduler.stats.MicrometerStatsRegistry;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.Task;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@Configuration
@EnableConfigurationProperties(value={DbSchedulerProperties.class})
@AutoConfigurationPackage
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HealthIndicatorAutoConfiguration.class, MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(value={"db-scheduler.enabled"}, matchIfMissing=true)
public class DbSchedulerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DbSchedulerAutoConfiguration.class);
    private static Predicate<Task<?>> shouldBeStarted = task -> task instanceof OnStartup;
    private final DbSchedulerProperties config;
    private final DataSource existingDataSource;
    private final List<Task<?>> configuredTasks;

    public DbSchedulerAutoConfiguration(DbSchedulerProperties dbSchedulerProperties, DataSource dataSource, List<Task<?>> configuredTasks) {
        this.config = Objects.requireNonNull(dbSchedulerProperties, "Can't configure db-scheduler without required configuration");
        this.existingDataSource = Objects.requireNonNull(dataSource, "An existing javax.sql.DataSource is required");
        this.configuredTasks = Objects.requireNonNull(configuredTasks, "At least one Task must be configured");
    }

    @ConditionalOnMissingBean
    @Bean
    public DbSchedulerCustomizer noopCustomizer() {
        return new DbSchedulerCustomizer(){};
    }

    @ConditionalOnClass(value={MeterRegistry.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnMissingBean(value={StatsRegistry.class})
    @Bean
    StatsRegistry micrometerStatsRegistry(MeterRegistry registry) {
        log.debug("Missing StatsRegistry bean in context but Micrometer detected. Will use: {}", (Object)registry.getClass().getName());
        return new MicrometerStatsRegistry(registry, this.configuredTasks);
    }

    @ConditionalOnMissingBean(value={StatsRegistry.class})
    @Bean
    StatsRegistry noopStatsRegistry() {
        log.debug("Missing StatsRegistry bean in context, creating a no-op StatsRegistry");
        return StatsRegistry.NOOP;
    }

    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnMissingBean
    @Bean(destroyMethod="stop")
    public Scheduler scheduler(DbSchedulerCustomizer customizer, StatsRegistry registry) {
        log.info("Creating db-scheduler using tasks from Spring context: {}", this.configuredTasks);
        DataSource transactionalDataSource = DbSchedulerAutoConfiguration.configureDataSource(this.existingDataSource);
        SchedulerBuilder builder = Scheduler.create((DataSource)transactionalDataSource, DbSchedulerAutoConfiguration.nonStartupTasks(this.configuredTasks));
        builder.threads(this.config.getThreads());
        builder.pollingInterval(this.config.getPollingInterval());
        this.config.getPollingLimit().ifPresent(arg_0 -> ((SchedulerBuilder)builder).pollingLimit(arg_0));
        builder.heartbeatInterval(this.config.getHeartbeatInterval());
        if (customizer.schedulerName().isPresent()) {
            builder.schedulerName(customizer.schedulerName().get());
        } else if (this.config.getSchedulerName() != null) {
            builder.schedulerName((SchedulerName)new SchedulerName.Fixed(this.config.getSchedulerName()));
        }
        builder.tableName(this.config.getTableName());
        customizer.serializer().ifPresent(arg_0 -> ((SchedulerBuilder)builder).serializer(arg_0));
        if (this.config.isImmediateExecutionEnabled()) {
            builder.enableImmediateExecution();
        }
        customizer.executorService().ifPresent(arg_0 -> ((SchedulerBuilder)builder).executorService(arg_0));
        builder.deleteUnresolvedAfter(this.config.getDeleteUnresolvedAfter());
        builder.startTasks(DbSchedulerAutoConfiguration.startupTasks(this.configuredTasks));
        builder.statsRegistry(registry);
        return builder.build();
    }

    @ConditionalOnEnabledHealthIndicator(value="db-scheduler")
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnBean(value={Scheduler.class})
    @Bean
    public HealthIndicator dbScheduler(Scheduler scheduler) {
        return new DbSchedulerHealthIndicator(scheduler);
    }

    @ConditionalOnBean(value={Scheduler.class})
    @ConditionalOnMissingBean
    @Bean
    public DbSchedulerStarter dbSchedulerStarter(Scheduler scheduler) {
        if (this.config.isDelayStartupUntilContextReady()) {
            return new ContextReadyStart(scheduler);
        }
        return new ImmediateStart(scheduler);
    }

    private static DataSource configureDataSource(DataSource existingDataSource) {
        if (existingDataSource instanceof TransactionAwareDataSourceProxy) {
            log.debug("Using an already transaction aware DataSource");
            return existingDataSource;
        }
        log.debug("The configured DataSource is not transaction aware: '{}'. Wrapping in TransactionAwareDataSourceProxy.", (Object)existingDataSource);
        return new TransactionAwareDataSourceProxy(existingDataSource);
    }

    private static <T extends Task<?>> List<T> startupTasks(List<Task<?>> tasks) {
        return tasks.stream().filter(shouldBeStarted).map(task -> task).collect(Collectors.toList());
    }

    private static List<Task<?>> nonStartupTasks(List<Task<?>> tasks) {
        return tasks.stream().filter(shouldBeStarted.negate()).collect(Collectors.toList());
    }
}

