/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium.environment;

import com.github.jsdevel.testng.selenium.environment.EnvironmentConfigDefaults;
import java.io.File;

public class EnvironmentConfig {
    public static final String ENDPOINT = System.getProperty("testng.selenium.endpoint", EnvironmentConfigDefaults.ENDPOINT);
    public static final String LOGGING_PREFIX = System.getProperty("testng.selenium.logging.prefix", "TestNG-Selenium");
    public static final String SCREENSIZE = System.getProperty("testng.selenium.screensize", "Phone");
    public static final String TMPDIR = System.getProperty("testng.selenium.tmpdir", EnvironmentConfigDefaults.TMPDIR);
    public static final File SCREENSHOT_DIR;
    private static final String SCREENSIZE_OPTIONS = "LargeDesktop,Desktop,Tablet,Phone";

    static {
        if (ENDPOINT == null) {
            System.out.println("testng.selenium.endpoint must be a configured System property!");
            System.exit(1);
        } else {
            System.out.println("testng.selenium.endpoint set to " + ENDPOINT);
        }
        System.out.println("testng.selenium.logging.prefix was set to " + LOGGING_PREFIX);
        if (!",LargeDesktop,Desktop,Tablet,Phone,".contains("," + SCREENSIZE + ",")) {
            System.out.println("testng.selenium.screensize must be one of LargeDesktop,Desktop,Tablet,Phone");
            System.out.println("Saw " + SCREENSIZE);
            System.exit(1);
        }
        if (TMPDIR == null) {
            System.out.println("testng.selenium.tmpdir must be a configured System property!");
            System.exit(1);
        } else {
            File tmpdir = new File(TMPDIR);
            if (tmpdir.exists()) {
                if (!tmpdir.isDirectory()) {
                    System.out.println("testng.selenium.tmpdir cannot use non directories for tmp dir.");
                    System.exit(1);
                }
            } else {
                tmpdir.mkdirs();
            }
            System.out.println("testng.selenium.endpoint set to " + ENDPOINT);
        }
        SCREENSHOT_DIR = new File(TMPDIR, "screenshots");
        SCREENSHOT_DIR.mkdirs();
    }
}

