/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.MethodContext;
import com.github.jsdevel.testng.selenium.PageFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebDriver;

class MethodContextImpl<PF extends PageFactory>
implements MethodContext<PF> {
    final Method method;
    private PF pageFactory;
    private WebDriver webDriver;
    private final List<String> output;
    private String userAgent;
    private String endpoint;

    public MethodContextImpl(Method method) {
        this.method = method;
        this.output = new ArrayList<String>();
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public PF getPageFactory() {
        return this.pageFactory;
    }

    @Override
    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void log(String msg) {
        this.output.add(msg);
    }

    List<String> getOutput() {
        return Collections.unmodifiableList(this.output);
    }

    void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    void setPageFactory(PF pageFactory) {
        this.pageFactory = pageFactory;
    }

    void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }

    void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

