/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.AbsractSuiteHelpers;
import com.github.jsdevel.testng.selenium.EnvironmentConfig;
import com.github.jsdevel.testng.selenium.MethodContextImpl;
import com.github.jsdevel.testng.selenium.PageFactory;
import com.github.jsdevel.testng.selenium.TestNGSeleniumLogger;
import java.lang.reflect.Method;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class AbstractSuite<PF extends PageFactory> {
    private final ThreadLocal<MethodContextImpl<PF>> methodContext = new ThreadLocal();

    protected PF getPageFactory() {
        return this.methodContext.get().getPageFactory();
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(Method method) {
        MethodContextImpl context = new MethodContextImpl(method);
        context.setEndpoint(EnvironmentConfig.ENDPOINT);
        AbsractSuiteHelpers.addWebDriver(context);
        AbsractSuiteHelpers.addPageFactory(context);
        this.methodContext.set(context);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        MethodContextImpl<PF> context = this.methodContext.get();
        if (context == null) {
            return;
        }
        if (context.getOutput() != null) {
            for (String line : context.getOutput()) {
                TestNGSeleniumLogger.log(line);
            }
        }
        context.getWebDriver().quit();
        this.methodContext.remove();
    }
}

