/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.AbstractPage;
import com.github.jsdevel.testng.selenium.MethodContext;
import org.openqa.selenium.WebDriver;

public class AbstractPageFactory {
    private String endpoint;
    private WebDriver webDriver;
    private MethodContext context;

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected WebDriver getWebDriver() {
        return this.webDriver;
    }

    protected <P extends AbstractPage> P initializePage(String desiredUrl, P page) {
        String proposedUrl = this.endpoint + desiredUrl;
        this.context.log("Initializing a[n] " + page.getClass().getSimpleName());
        page.setMethodContext(this.context);
        page.setWebDriver(this.webDriver);
        if (this.webDriver.getCurrentUrl().equals("about:blank")) {
            this.context.log("Detected about:blank.");
            this.context.log("Navigating to " + proposedUrl);
            this.context.log("Handling initial Page load.");
            this.webDriver.get(proposedUrl);
            page.handleInitialPageLoad();
        }
        this.context.log("Asserting that the page is Viewable from " + proposedUrl);
        page.assertPageIsViewableFrom(proposedUrl);
        return page;
    }

    void setEndoint(String endpoint) {
        this.endpoint = endpoint;
    }

    void setMethodContext(MethodContext context) {
        this.context = context;
    }

    void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }
}

