/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsdevel.testng.selenium;

import com.github.jsdevel.testng.selenium.MethodContext;
import com.github.jsdevel.testng.selenium.Page;
import com.github.jsdevel.testng.selenium.PageAssertions;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriver;
import org.testng.AssertJUnit;

public abstract class AbstractPage<P extends AbstractPage>
implements Page<P>,
PageAssertions<P> {
    protected WebDriver webDriver;
    protected MethodContext context;

    @Override
    public P assertCurrentUrlPathStartsWith(String proposal) {
        URL currentUrl;
        this.context.log("Asserting that the current URL path starts with " + proposal);
        String currentWebDriverUrl = this.webDriver.getCurrentUrl();
        this.context.log("The current WebDriver URL is " + currentWebDriverUrl);
        try {
            currentUrl = new URL(currentWebDriverUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        this.context.log("The current WebDriver URL path is " + currentUrl.getPath());
        AssertJUnit.assertTrue((currentUrl.getPath().indexOf(proposal) == 0 ? 1 : 0) != 0);
        return (P)this;
    }

    @Override
    public P handleInitialPageLoad() {
        return (P)this;
    }

    void setMethodContext(MethodContext context) {
        this.context = context;
    }

    void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }
}

