/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage.img;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.webkit.MimeTypeMap;
import com.vansuita.pickimage.bundle.PickSetup;
import com.vansuita.pickimage.enums.EPickType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class ImageHandler {
    private Context context;
    private Uri uri;
    private EPickType provider;
    private PickSetup setup;

    public ImageHandler(Context context) {
        this.context = context;
    }

    public static ImageHandler with(Context context) {
        return new ImageHandler(context);
    }

    public ImageHandler uri(Uri uri) {
        this.uri = uri;
        return this;
    }

    public ImageHandler provider(EPickType provider) {
        this.provider = provider;
        return this;
    }

    public ImageHandler setup(PickSetup setup) {
        this.setup = setup;
        return this;
    }

    private Bitmap rotateIfNeeded(Bitmap bitmap) {
        int rotation = this.provider == EPickType.CAMERA ? this.getRotationFromCamera() : this.getRotationFromGallery();
        return this.rotate(bitmap, rotation);
    }

    private int getRotationFromCamera() {
        int rotate = 0;
        try {
            ExifInterface exif = new ExifInterface(this.uri.getPath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
                default: {
                    rotate = 0;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rotate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRotationFromGallery() {
        int result = 0;
        String[] columns = new String[]{"orientation"};
        try (Cursor cursor = null;){
            cursor = this.context.getContentResolver().query(this.uri, columns, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int orientationColumnIndex = cursor.getColumnIndex(columns[0]);
                result = cursor.getInt(orientationColumnIndex);
            }
        }
        return result;
    }

    public Bitmap rotate(Bitmap bitmap, int degrees) {
        if (bitmap != null && degrees != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degrees);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return bitmap;
    }

    private Bitmap flip(Bitmap bitmap) {
        Matrix m = new Matrix();
        m.preScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)false);
    }

    public Bitmap decode() throws FileNotFoundException {
        if (this.setup.getWidth() == 0 && this.setup.getHeight() == 0) {
            this.setup.setWidth(this.setup.getMaxSize());
            this.setup.setHeight(this.setup.getMaxSize());
        }
        Bitmap bitmap = this.setup.getWidth() - this.setup.getHeight() == 0 ? this.scaleDown() : this.resize();
        if (this.provider.equals((Object)EPickType.CAMERA) && this.setup.isFlipped()) {
            bitmap = this.flip(bitmap);
        }
        return this.rotateIfNeeded(bitmap);
    }

    public Uri getUri() {
        return this.uri;
    }

    public String getUriPath() {
        if (this.provider.equals((Object)EPickType.CAMERA)) {
            return this.uri.getPath();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return this.getGalleryNewPath(this.uri);
        }
        return this.getGalleryPath();
    }

    private String getGalleryNewPath(Uri uri) {
        File folder = new File(this.context.getFilesDir() + "/Pictures");
        if (!folder.exists()) {
            folder.mkdir();
        }
        File galleryFile = new File(folder.getAbsolutePath(), this.getGalleryFileName(uri));
        try {
            FileOutputStream fos = new FileOutputStream(galleryFile);
            InputStream fis = this.context.getContentResolver().openInputStream(uri);
            this.copy(fis, fos);
            fos.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return galleryFile.getPath();
    }

    void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGalleryFileName(Uri uri) {
        try (Cursor cursor = null;){
            cursor = this.context.getContentResolver().query(uri, null, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_display_name");
            cursor.moveToFirst();
            String string2 = cursor.getString(column_index);
            return string2;
        }
    }

    private String getExtension(Uri uri) {
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        String extension = mime.getExtensionFromMimeType(this.context.getContentResolver().getType(uri));
        return extension != null ? extension : "";
    }

    private String getTimestampString() {
        Calendar date = Calendar.getInstance();
        return new SimpleDateFormat("yyyy MM dd hh mm ss", Locale.US).format(date.getTime()).replace(" ", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGalleryPath() {
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = this.context.getContentResolver().query(this.uri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String string2 = cursor.getString(column_index);
            return string2;
        }
    }

    private BitmapFactory.Options getOptions() throws FileNotFoundException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)this.context.getContentResolver().openInputStream(this.uri), null, (BitmapFactory.Options)options);
        int w = options.outWidth;
        int h = options.outHeight;
        int scale = 1;
        while (w / 2 >= this.setup.getWidth() && h / 2 >= this.setup.getHeight()) {
            w /= 2;
            h /= 2;
            scale *= 2;
        }
        options = new BitmapFactory.Options();
        options.inSampleSize = scale;
        return options;
    }

    private Bitmap scaleDown() throws FileNotFoundException {
        return BitmapFactory.decodeStream((InputStream)this.context.getContentResolver().openInputStream(this.uri), null, (BitmapFactory.Options)this.getOptions());
    }

    public Bitmap resize() throws FileNotFoundException {
        return Bitmap.createScaledBitmap((Bitmap)this.scaleDown(), (int)this.setup.getWidth(), (int)this.setup.getHeight(), (boolean)false);
    }
}

