/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.vansuita.pickimage.EPickTypes;
import com.vansuita.pickimage.IPickResult;
import com.vansuita.pickimage.PickSetup;
import com.vansuita.pickimage.R;
import com.vansuita.pickimage.Util;
import java.io.Serializable;

public class PickImageDialog
extends DialogFragment {
    private static final String SETUP_TAG = "SETUP_TAG";
    private static final int FROM_CAMERA = 1;
    private static final int FROM_GALLERY = 2;
    private CardView cvRoot;
    private TextView tvTitle;
    private TextView tvCamera;
    private TextView tvGallery;
    private TextView tvCancel;
    private IPickResult.IPickResultBitmap onBitmapResult;
    private IPickResult.IPickResultUri onUriResult;
    private IPickResult.IPickClick onClick;
    private IPickResult.IPickError OnError;
    private PickSetup setup;
    private View.OnClickListener listener = new View.OnClickListener(){

        public void onClick(View view) {
            if (view.getId() == R.id.cancel) {
                PickImageDialog.this.dismiss();
            } else if (view.getId() == R.id.camera) {
                if (PickImageDialog.this.onClick != null) {
                    PickImageDialog.this.onClick.onCameraClick();
                } else {
                    Util.launchCamera(PickImageDialog.this, 1);
                }
            } else if (view.getId() == R.id.gallery) {
                if (PickImageDialog.this.onClick != null) {
                    PickImageDialog.this.onClick.onGalleryClick();
                } else {
                    Util.launchGalery(PickImageDialog.this, 2);
                }
            }
        }
    };

    public static PickImageDialog newInstance(PickSetup setup) {
        PickImageDialog frag = new PickImageDialog();
        Bundle args = new Bundle();
        args.putSerializable(SETUP_TAG, (Serializable)setup);
        frag.setArguments(args);
        return frag;
    }

    public static PickImageDialog on(FragmentActivity activity, PickSetup setup) {
        PickImageDialog d = PickImageDialog.newInstance(setup);
        d.show(activity.getSupportFragmentManager(), "dialog");
        return d;
    }

    public static PickImageDialog on(FragmentActivity activity) {
        return PickImageDialog.on(activity, new PickSetup());
    }

    public PickImageDialog setOnBitmapResult(IPickResult.IPickResultBitmap onBitmapResult) {
        this.onBitmapResult = onBitmapResult;
        return this;
    }

    public void setOnUriResult(IPickResult.IPickResultUri onUriResult) {
        this.onUriResult = onUriResult;
    }

    public void setOnClick(IPickResult.IPickClick onClick) {
        this.onClick = onClick;
    }

    public void setOnError(IPickResult.IPickError onError) {
        this.OnError = onError;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.cvRoot = (CardView)inflater.inflate(R.layout.dialog, null, false);
        this.bindView();
        this.setUp();
        this.bindListeners();
        this.requestPermissions();
        return this.cvRoot;
    }

    private void setUp() {
        this.getDialog().getWindow().requestFeature(1);
        this.getDialog().getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setup = (PickSetup)this.getArguments().getSerializable(SETUP_TAG);
        this.cvRoot.setCardBackgroundColor(this.setup.getBackgroundColor());
        this.tvTitle.setTextColor(this.setup.getTitleColor());
        if (this.setup.getOptionsColor() > 0) {
            this.tvCamera.setTextColor(this.setup.getOptionsColor());
            this.tvGallery.setTextColor(this.setup.getOptionsColor());
        }
        this.tvCancel.setText((CharSequence)this.setup.getCancelText());
        this.tvTitle.setText((CharSequence)this.setup.getTitle());
        Util.gone((View)this.tvCamera, !EPickTypes.CAMERA.inside(this.setup.getPickTypes()));
        Util.gone((View)this.tvGallery, !EPickTypes.GALERY.inside(this.setup.getPickTypes()));
        Util.setDimAmount(this.setup.getDimAmount(), this.getDialog());
        this.onAttaching((Context)this.getActivity());
    }

    public void onAttaching(Context context) {
        if (this.onBitmapResult == null && context instanceof IPickResult.IPickResultBitmap) {
            this.onBitmapResult = (IPickResult.IPickResultBitmap)context;
        }
        if (this.onUriResult == null && context instanceof IPickResult.IPickResultUri) {
            this.onUriResult = (IPickResult.IPickResultUri)context;
        }
        if (this.onClick == null && context instanceof IPickResult.IPickClick) {
            this.onClick = (IPickResult.IPickClick)context;
        }
        if (this.OnError == null && context instanceof IPickResult.IPickError) {
            this.OnError = (IPickResult.IPickError)context;
        }
    }

    private void bindView() {
        this.tvTitle = (TextView)this.cvRoot.findViewById(R.id.title);
        this.tvCamera = (TextView)this.cvRoot.findViewById(R.id.camera);
        this.tvGallery = (TextView)this.cvRoot.findViewById(R.id.gallery);
        this.tvCancel = (TextView)this.cvRoot.findViewById(R.id.cancel);
    }

    private void bindListeners() {
        this.tvCancel.setOnClickListener(this.listener);
        this.tvCamera.setOnClickListener(this.listener);
        this.tvGallery.setOnClickListener(this.listener);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.dismiss();
        if (resultCode == -1) {
            try {
                if (this.onBitmapResult != null) {
                    Bitmap bitmap = null;
                    if (requestCode == 1) {
                        bitmap = Util.decodeUri(Util.tempUri(), this.getContext(), this.setup.getImageSize());
                        if (this.setup.isFlipped()) {
                            bitmap = Util.flip(bitmap);
                        }
                    } else if (requestCode == 2) {
                        bitmap = Util.decodeUri(data.getData(), this.getContext(), this.setup.getImageSize());
                    }
                    this.onBitmapResult.onPickImageResult(bitmap);
                }
                if (this.onUriResult != null) {
                    if (requestCode == 1) {
                        this.onUriResult.onPickImageResult(Util.tempUri());
                    } else if (requestCode == 2) {
                        this.onUriResult.onPickImageResult(data.getData());
                    }
                }
            }
            catch (Exception e) {
                this.OnError.onPickError(e);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] == 0) continue;
            this.dismissAllowingStateLoss();
            break;
        }
    }

    public boolean requestPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.getActivity().checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0 && this.getActivity().checkSelfPermission("android.permission.CAMERA") == 0) {
                return true;
            }
            this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"}, 1);
            return false;
        }
        return true;
    }
}

