/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage.dialog;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.vansuita.pickimage.bundle.PickSetup;
import com.vansuita.pickimage.dialog.PickImageBaseDialog;
import com.vansuita.pickimage.keep.Keep;
import com.vansuita.pickimage.listeners.IPickCancel;
import com.vansuita.pickimage.listeners.IPickClick;
import com.vansuita.pickimage.listeners.IPickResult;
import java.io.Serializable;

public class PickImageDialog
extends PickImageBaseDialog {
    public static PickImageDialog newInstance(PickSetup setup) {
        PickImageDialog frag = new PickImageDialog();
        Bundle bundle = new Bundle();
        bundle.putSerializable("SETUP_TAG", (Serializable)setup);
        frag.setArguments(bundle);
        return frag;
    }

    public static PickImageDialog build(PickSetup setup, IPickResult pickResult) {
        PickImageDialog d = PickImageDialog.newInstance(setup);
        d.setOnPickResult(pickResult);
        return d;
    }

    public static PickImageDialog build(IPickResult pickResult) {
        return PickImageDialog.build(new PickSetup(), pickResult);
    }

    public static PickImageDialog build(PickSetup setup) {
        return PickImageDialog.build(setup, null);
    }

    public static PickImageDialog build() {
        return PickImageDialog.build();
    }

    public PickImageDialog show(FragmentActivity fragmentActivity) {
        return this.show(fragmentActivity.getSupportFragmentManager());
    }

    public PickImageDialog show(FragmentManager fragmentManager) {
        super.show(fragmentManager, DIALOG_FRAGMENT_TAG);
        return this;
    }

    @Override
    public void onCameraClick() {
        this.launchCamera();
    }

    @Override
    public void onGalleryClick() {
        this.launchGallery();
    }

    @Override
    public PickImageDialog setOnClick(IPickClick onClick) {
        return (PickImageDialog)super.setOnClick(onClick);
    }

    @Override
    public PickImageDialog setOnPickResult(IPickResult onPickResult) {
        return (PickImageDialog)super.setOnPickResult(onPickResult);
    }

    @Override
    public PickImageDialog setOnPickCancel(IPickCancel onPickCancel) {
        return (PickImageDialog)super.setOnPickCancel(onPickCancel);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 99) {
            if (resultCode == -1) {
                this.showProgress(true);
                this.getAsyncResult().execute(new Intent[]{data});
            } else {
                this.dismissAllowingStateLoss();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 99) {
            boolean granted = true;
            int[] nArray = grantResults;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer i2 = nArray[i];
                granted = granted && i2 == 0;
            }
            if (granted) {
                if (!this.launchSystemDialog()) {
                    int cameraIndex = -1;
                    for (int i = 0; i < permissions.length; ++i) {
                        if (!permissions[i].equals("android.permission.CAMERA")) continue;
                        cameraIndex = i;
                        break;
                    }
                    if (cameraIndex == -1) {
                        this.launchGallery();
                    } else {
                        this.launchCamera();
                    }
                }
            } else {
                this.dismissAllowingStateLoss();
                if (grantResults.length > 1) {
                    Keep.with((Context)this.getActivity()).askedForPermission();
                }
            }
        }
    }
}

