/*
 * Decompiled with CFR 0.152.
 */
package com.vansuita.pickimage.util;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.StateSet;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import java.util.Arrays;

public class Util {
    @TargetApi(value=16)
    public static void background(View v, Drawable d) {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            v.setBackgroundDrawable(d);
        } else {
            v.setBackground(d);
        }
    }

    @TargetApi(value=16)
    public static void background(View v, Bitmap b) {
        Util.background(v, (Drawable)new BitmapDrawable(v.getResources(), b));
    }

    public static void setDimAmount(float dim, Dialog dialog) {
        if (Build.VERSION.SDK_INT >= 14) {
            dialog.getWindow().setDimAmount(dim);
        } else {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = dim;
            dialog.getWindow().setAttributes(lp);
        }
    }

    public static void gone(View v, boolean gone) {
        if (gone) {
            v.setVisibility(8);
        } else {
            v.setVisibility(0);
        }
    }

    public static void setIcon(TextView tv, int icon, int gravity) {
        int left;
        int right = 0;
        int bottom = 0;
        int top = 0;
        if (gravity > 0) {
            left = gravity == 3 ? icon : 0;
            right = gravity == 5 ? icon : 0;
            bottom = gravity == 80 ? icon : 0;
            top = gravity == 48 ? icon : 0;
        } else {
            left = icon;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            tv.setCompoundDrawablesRelativeWithIntrinsicBounds(left, top, right, bottom);
        } else {
            tv.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
        }
        if (bottom + top != 0) {
            tv.setGravity(17);
        }
    }

    public static Drawable getAdaptiveRippleDrawable(int normalColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new RippleDrawable(ColorStateList.valueOf((int)Util.darker(normalColor)), Util.getRippleMask(normalColor), null);
        }
        return Util.getStateListDrawable(normalColor, Util.darker(normalColor));
    }

    private static Drawable getRippleMask(int color) {
        float[] outerRadii = new float[8];
        Arrays.fill(outerRadii, 3.0f);
        RoundRectShape r = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)r);
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    private static StateListDrawable getStateListDrawable(int normalColor, int pressedColor) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16842908}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16843518}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[0], (Drawable)new ColorDrawable(normalColor));
        states.addState(StateSet.WILD_CARD, (Drawable)new ColorDrawable(normalColor));
        return states;
    }

    public static int darker(int color) {
        int r = Color.red((int)color);
        int b = Color.blue((int)color);
        int g = Color.green((int)color);
        return Color.rgb((int)((int)((double)r * 0.9)), (int)((int)((double)g * 0.9)), (int)((int)((double)b * 0.9)));
    }
}

